/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom.annotation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleSegment;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.aes.AesScaling;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.annotation.Annotation;
import org.jetbrains.letsPlot.core.plot.base.geom.annotation.AnnotationUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.annotation.BarAnnotation;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Label;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JN\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J2\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\b\u0010\u0018\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0015H\u0002J:\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\b\u0010\u0018\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/annotation/CrossBarAnnotation;", "", "()V", "build", "", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "rectangles", "", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "midLines", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleSegment;", "fatten", "", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "findLocation", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "viewPort", "rect", "midLine", "strokeWidth", "textSize", "findTextLocation", "isHorizontallyOriented", "", "plot-base"})
@SourceDebugExtension(value={"SMAP\nCrossBarAnnotation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrossBarAnnotation.kt\norg/jetbrains/letsPlot/core/plot/base/geom/annotation/CrossBarAnnotation\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,154:1\n1#2:155\n125#3:156\n152#3,3:157\n1855#4:160\n1549#4:161\n1620#4,3:162\n1855#4,2:165\n1856#4:167\n*S KotlinDebug\n*F\n+ 1 CrossBarAnnotation.kt\norg/jetbrains/letsPlot/core/plot/base/geom/annotation/CrossBarAnnotation\n*L\n36#1:156\n36#1:157,3\n37#1:160\n69#1:161\n69#1:162,3\n85#1:165,2\n37#1:167\n*E\n"})
public final class CrossBarAnnotation {
    @NotNull
    public static final CrossBarAnnotation INSTANCE = new CrossBarAnnotation();

    private CrossBarAnnotation() {
    }

    /*
     * WARNING - void declaration
     */
    public final void build(@NotNull SvgRoot root, @NotNull Map<DataPointAesthetics, DoubleRectangle> rectangles, @NotNull Map<Integer, DoubleSegment> midLines, double fatten, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(rectangles, (String)"rectangles");
        Intrinsics.checkNotNullParameter(midLines, (String)"midLines");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        Annotation annotation = ctx2.getAnnotation();
        if (annotation == null) {
            return;
        }
        Annotation annotation2 = annotation;
        DoubleRectangle p0 = GeomBase.Companion.overallAesBounds(ctx2);
        boolean $i$a$-let-CrossBarAnnotation$build$viewPort$22 = false;
        DoubleRectangle doubleRectangle = coord.toClient(p0);
        if (doubleRectangle == null) {
            return;
        }
        DoubleRectangle viewPort = doubleRectangle;
        double padding = annotation2.getTextStyle().getSize() / (double)2;
        boolean isHorizontallyOriented = ctx2.getFlipped();
        Map<DataPointAesthetics, DoubleRectangle> $i$a$-let-CrossBarAnnotation$build$viewPort$22 = rectangles;
        boolean $i$f$map = false;
        Iterator iterator2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator3 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator3.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator3.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            DataPointAesthetics aes2 = (DataPointAesthetics)entry.getKey();
            DoubleRectangle rect2 = (DoubleRectangle)entry.getValue();
            collection.add(new Triple((Object)aes2, (Object)rect2, (Object)midLines.get(aes2.index())));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            void $this$mapTo$iv$iv2;
            Triple triple = (Triple)element$iv;
            boolean bl = false;
            DataPointAesthetics aes3 = (DataPointAesthetics)triple.component1();
            DoubleRectangle rect3 = (DoubleRectangle)triple.component2();
            DoubleSegment midLine = (DoubleSegment)triple.component3();
            String text2 = annotation2.getAnnotationText(aes3.index(), ctx2.getPlotContext());
            DoubleVector textSize = (DoubleVector)AnnotationUtil.INSTANCE.textSizeGetter(annotation2.getTextStyle(), ctx2).invoke((Object)text2, (Object)aes3);
            double midLineStrokeWidth = AesScaling.INSTANCE.strokeWidth(aes3) * fatten;
            DoubleVector location2 = null;
            location2 = INSTANCE.findTextLocation(viewPort, rect3, midLine, midLineStrokeWidth, textSize.add(new DoubleVector((double)2 * padding, (double)2 * padding)), isHorizontallyOriented);
            DoubleRectangle textRect = new DoubleRectangle(location2.subtract(textSize.mul(0.5)), textSize);
            Pair<Color, Double> pair2 = AnnotationUtil.INSTANCE.textColorAndLabelAlpha(annotation2, aes3.color(), aes3.fill(), BarAnnotation.INSTANCE.contains$plot_base(rect3, textRect));
            Color textColor2 = (Color)pair2.component1();
            double alpha = ((Number)pair2.component2()).doubleValue();
            List<String> labels = Label.Companion.splitLines(text2);
            location2 = location2.subtract(new DoubleVector(0.0, annotation2.getTextStyle().getSize() * (double)labels.size() / (double)2));
            Iterable $this$map$iv2 = labels;
            boolean $i$f$map2 = false;
            Iterable iterable = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void line2;
                SvgGElement svgGElement;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                SvgGElement it = svgGElement = AnnotationUtil.INSTANCE.createLabelElement((String)line2, location2, new AnnotationUtil.TextParams(annotation2.getTextStyle(), textColor2, "middle", "top", null, ctx2.getBackgroundColor(), alpha, 16, null), ctx2);
                boolean bl3 = false;
                location2 = location2.add(new DoubleVector(0.0, annotation2.getTextStyle().getSize()));
                collection.add(svgGElement);
            }
            $this$map$iv2 = (List)destination$iv$iv2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                SvgNode p02 = (SvgNode)element$iv2;
                boolean bl4 = false;
                root.add(p02);
            }
        }
    }

    private final DoubleVector findTextLocation(DoubleRectangle viewPort, DoubleRectangle rect2, DoubleSegment midLine, double strokeWidth, DoubleVector textSize, boolean isHorizontallyOriented) {
        DoubleVector doubleVector;
        if (isHorizontallyOriented) {
            DoubleSegment doubleSegment = midLine;
            doubleVector = this.findLocation(viewPort.flip(), rect2.flip(), doubleSegment != null ? doubleSegment.flip() : null, strokeWidth, textSize.flip()).flip();
        } else {
            doubleVector = this.findLocation(viewPort, rect2, midLine, strokeWidth, textSize);
        }
        return doubleVector;
    }

    private final DoubleVector findLocation(DoubleRectangle viewPort, DoubleRectangle rect2, DoubleSegment midLine, double strokeWidth, DoubleVector textSize) {
        DoubleRectangle upperOuterRect = new DoubleRectangle(new DoubleVector(rect2.getOrigin().getX(), viewPort.getOrigin().getY()), new DoubleVector(rect2.getWidth(), rect2.getTop() - viewPort.getOrigin().getY()));
        DoubleRectangle lowerOuterRect = new DoubleRectangle(new DoubleVector(rect2.getOrigin().getX(), rect2.getBottom()), new DoubleVector(rect2.getWidth(), viewPort.getBottom() - rect2.getBottom()));
        if (midLine != null) {
            DoubleRectangle upperInnerRect = new DoubleRectangle(rect2.getOrigin(), new DoubleVector(rect2.getWidth(), midLine.getStart().getY() - strokeWidth / (double)2 - rect2.getOrigin().getY()));
            DoubleRectangle lowerInnerRect = new DoubleRectangle(new DoubleVector(rect2.getOrigin().getX(), midLine.getStart().getY() + strokeWidth / (double)2), new DoubleVector(rect2.getWidth(), rect2.getOrigin().getY() + rect2.getHeight() - (midLine.getStart().getY() + strokeWidth / (double)2)));
            return upperInnerRect.getHeight() > textSize.getY() ? upperInnerRect.getCenter() : (lowerInnerRect.getHeight() > textSize.getY() ? lowerInnerRect.getCenter() : (upperOuterRect.getHeight() > textSize.getY() ? new DoubleVector(rect2.getCenter().getX(), upperOuterRect.getBottom() - textSize.getY() / (double)2) : (lowerOuterRect.getHeight() > textSize.getY() ? new DoubleVector(rect2.getCenter().getX(), lowerOuterRect.getTop() + textSize.getY() / (double)2) : rect2.getCenter())));
        }
        return rect2.getHeight() > textSize.getY() ? rect2.getCenter() : (upperOuterRect.getHeight() > textSize.getY() ? new DoubleVector(rect2.getCenter().getX(), upperOuterRect.getBottom() - textSize.getY() / (double)2) : (lowerOuterRect.getHeight() > textSize.getY() ? new DoubleVector(rect2.getCenter().getX(), lowerOuterRect.getTop() + textSize.getY() / (double)2) : rect2.getCenter()));
    }
}

