/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.svggen;

import java.awt.Polygon;
import java.awt.geom.PathIterator;
import org.jetbrains.relocated.apache.batik.svggen.SVGGeneratorContext;
import org.jetbrains.relocated.apache.batik.svggen.SVGGraphicObjectConverter;
import org.w3c.dom.Element;

public class SVGPolygon
extends SVGGraphicObjectConverter {
    public SVGPolygon(SVGGeneratorContext generatorContext) {
        super(generatorContext);
    }

    public Element toSVG(Polygon polygon2) {
        Element svgPolygon = this.generatorContext.domFactory.createElementNS("http://www.w3.org/2000/svg", "polygon");
        StringBuffer points2 = new StringBuffer(" ");
        PathIterator pi = polygon2.getPathIterator(null);
        float[] seg = new float[6];
        while (!pi.isDone()) {
            int segType = pi.currentSegment(seg);
            switch (segType) {
                case 0: {
                    this.appendPoint(points2, seg[0], seg[1]);
                    break;
                }
                case 1: {
                    this.appendPoint(points2, seg[0], seg[1]);
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    throw new RuntimeException("invalid segmentType:" + segType);
                }
            }
            pi.next();
        }
        svgPolygon.setAttributeNS(null, "points", points2.substring(0, points2.length() - 1));
        return svgPolygon;
    }

    private void appendPoint(StringBuffer points2, float x2, float y2) {
        points2.append(this.doubleString(x2));
        points2.append(" ");
        points2.append(this.doubleString(y2));
        points2.append(" ");
    }
}

