/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.com.github.weisj.jsvg.attributes;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.relocated.com.github.weisj.jsvg.geometry.size.Length;
import org.jetbrains.relocated.com.github.weisj.jsvg.geometry.size.MeasureContext;

public enum UnitType {
    UserSpaceOnUse,
    ObjectBoundingBox;


    @NotNull
    public MeasureContext deriveMeasure(@NotNull MeasureContext measure) {
        return this.deriveMeasure(measure, 1.0, 1.0);
    }

    @NotNull
    public MeasureContext deriveMeasure(@NotNull MeasureContext measure, double objectWidth, double objectHeight) {
        if (this == ObjectBoundingBox) {
            return measure.derive((float)objectWidth, (float)objectHeight);
        }
        return measure;
    }

    @NotNull
    public AffineTransform viewTransform(@NotNull Rectangle2D bounds) {
        if (this == ObjectBoundingBox) {
            AffineTransform at = AffineTransform.getTranslateInstance(bounds.getX(), bounds.getY());
            at.scale(bounds.getWidth(), bounds.getHeight());
            return at;
        }
        return new AffineTransform();
    }

    @NotNull
    public Rectangle2D.Double computeViewBounds(@NotNull MeasureContext measure, @NotNull Rectangle2D elementBounds, @NotNull Length x2, @NotNull Length y2, @NotNull Length width2, @NotNull Length height) {
        MeasureContext patternMeasure = this.deriveMeasure(measure, elementBounds.getWidth(), elementBounds.getHeight());
        Rectangle2D.Double viewBounds = new Rectangle2D.Double(x2.resolveWidth(patternMeasure), y2.resolveHeight(patternMeasure), width2.resolveWidth(patternMeasure), height.resolveHeight(patternMeasure));
        if (this == ObjectBoundingBox) {
            viewBounds.x += elementBounds.getX();
            viewBounds.y += elementBounds.getY();
        }
        return viewBounds;
    }
}

