/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.GenericLineWrapPositionStrategy;
import com.intellij.openapi.project.Project;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeader;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownLinkDestination;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableCell;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableRow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JB\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/intellij/plugins/markdown/editor/MarkdownLineWrapPositionStrategy;", "Lcom/intellij/openapi/editor/GenericLineWrapPositionStrategy;", "<init>", "()V", "calculateWrapPosition", "", "document", "Lcom/intellij/openapi/editor/Document;", "project", "Lcom/intellij/openapi/project/Project;", "startOffset", "endOffset", "maxPreferredOffset", "allowToBeyondMaxPreferredOffset", "", "isSoftWrap", "Companion", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nMarkdownLineWrapPositionStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownLineWrapPositionStrategy.kt\norg/intellij/plugins/markdown/editor/MarkdownLineWrapPositionStrategy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n1#2:63\n1807#3,3:64\n*S KotlinDebug\n*F\n+ 1 MarkdownLineWrapPositionStrategy.kt\norg/intellij/plugins/markdown/editor/MarkdownLineWrapPositionStrategy\n*L\n47#1:64,3\n*E\n"})
public final class MarkdownLineWrapPositionStrategy
extends GenericLineWrapPositionStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<Class<? extends NavigatablePsiElement>> stopSet;

    public MarkdownLineWrapPositionStrategy() {
        this.addRule(new GenericLineWrapPositionStrategy.Rule(' ', GenericLineWrapPositionStrategy.WrapCondition.AFTER));
        this.addRule(new GenericLineWrapPositionStrategy.Rule('\t', GenericLineWrapPositionStrategy.WrapCondition.AFTER));
        this.addRule(new GenericLineWrapPositionStrategy.Rule(',', GenericLineWrapPositionStrategy.WrapCondition.AFTER));
        this.addRule(new GenericLineWrapPositionStrategy.Rule('.', GenericLineWrapPositionStrategy.WrapCondition.AFTER));
        this.addRule(new GenericLineWrapPositionStrategy.Rule('!', GenericLineWrapPositionStrategy.WrapCondition.AFTER));
        this.addRule(new GenericLineWrapPositionStrategy.Rule('?', GenericLineWrapPositionStrategy.WrapCondition.AFTER));
        this.addRule(new GenericLineWrapPositionStrategy.Rule(';', GenericLineWrapPositionStrategy.WrapCondition.AFTER));
        this.addRule(new GenericLineWrapPositionStrategy.Rule(')', GenericLineWrapPositionStrategy.WrapCondition.AFTER));
        this.addRule(new GenericLineWrapPositionStrategy.Rule(']', GenericLineWrapPositionStrategy.WrapCondition.AFTER));
        this.addRule(new GenericLineWrapPositionStrategy.Rule('}', GenericLineWrapPositionStrategy.WrapCondition.AFTER));
        this.addRule(new GenericLineWrapPositionStrategy.Rule('(', GenericLineWrapPositionStrategy.WrapCondition.BEFORE));
        this.addRule(new GenericLineWrapPositionStrategy.Rule('[', GenericLineWrapPositionStrategy.WrapCondition.BEFORE));
        this.addRule(new GenericLineWrapPositionStrategy.Rule('{', GenericLineWrapPositionStrategy.WrapCondition.BEFORE));
    }

    public int calculateWrapPosition(@NotNull Document document, @Nullable Project project, int startOffset, int endOffset, int maxPreferredOffset, boolean allowToBeyondMaxPreferredOffset, boolean isSoftWrap) {
        Project project2;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)document, (String)"document");
                project2 = project;
                if (project2 == null) break block4;
                Project it = project2;
                boolean bl = false;
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
                project2 = psiFile;
                if (psiFile != null) break block5;
            }
            return super.calculateWrapPosition(document, project, startOffset, endOffset, maxPreferredOffset, allowToBeyondMaxPreferredOffset, isSoftWrap);
        }
        Project file = project2;
        if (((Boolean)ActionsKt.runReadAction(() -> MarkdownLineWrapPositionStrategy.calculateWrapPosition$lambda$1((PsiFile)file, startOffset))).booleanValue()) {
            return -1;
        }
        return super.calculateWrapPosition(document, project, startOffset, endOffset, maxPreferredOffset, allowToBeyondMaxPreferredOffset, isSoftWrap);
    }

    private static final boolean calculateWrapPosition$lambda$1(PsiFile $file, int $startOffset) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = stopSet;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Class it = (Class)element$iv;
                    boolean bl2 = false;
                    if (!(PsiTreeUtil.findElementOfClassAtOffset((PsiFile)$file, (int)$startOffset, (Class)it, (boolean)true) != null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    static {
        Object[] objectArray = new Class[]{MarkdownHeader.class, MarkdownLinkDestination.class, MarkdownTableCell.class, MarkdownTableRow.class, MarkdownTable.class};
        stopSet = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/intellij/plugins/markdown/editor/MarkdownLineWrapPositionStrategy$Companion;", "", "<init>", "()V", "stopSet", "", "Ljava/lang/Class;", "Lcom/intellij/psi/NavigatablePsiElement;", "intellij.markdown"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

