/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.codeInsight.attributes;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.polySymbols.completion.PolySymbolCodeCompletionItem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.vuejs.codeInsight.attributes.VueAttributeNameParser;
import org.jetbrains.vuejs.model.VueSlotUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/vuejs/codeInsight/attributes/VueAttributeValueCompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "<init>", "()V", "VUE_SCRIPT_LANGUAGE", "", "", "VUE_STYLE_LANGUAGE", "VUE_TEMPLATE_LANGUAGE", "addCompletions", "", "parameters", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "listOfCompletions", "xmlTag", "Lcom/intellij/psi/xml/XmlTag;", "xmlAttribute", "Lcom/intellij/psi/xml/XmlAttribute;", "vueStyleLanguages", "intellij.vuejs.backend"})
@SourceDebugExtension(value={"SMAP\nVueAttributeValueCompletionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VueAttributeValueCompletionProvider.kt\norg/jetbrains/vuejs/codeInsight/attributes/VueAttributeValueCompletionProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n1586#2:59\n1661#2,3:60\n1915#2,2:63\n*S KotlinDebug\n*F\n+ 1 VueAttributeValueCompletionProvider.kt\norg/jetbrains/vuejs/codeInsight/attributes/VueAttributeValueCompletionProvider\n*L\n42#1:59\n42#1:60,3\n49#1:63,2\n*E\n"})
public final class VueAttributeValueCompletionProvider
extends CompletionProvider<CompletionParameters> {
    @NotNull
    private final Set<String> VUE_SCRIPT_LANGUAGE;
    @NotNull
    private final Set<String> VUE_STYLE_LANGUAGE;
    @NotNull
    private final Set<String> VUE_TEMPLATE_LANGUAGE;

    public VueAttributeValueCompletionProvider() {
        Object[] objectArray = new String[]{"js", "ts"};
        this.VUE_SCRIPT_LANGUAGE = SetsKt.setOf((Object[])objectArray);
        this.VUE_STYLE_LANGUAGE = this.vueStyleLanguages();
        objectArray = new String[]{"html", "pug"};
        this.VUE_TEMPLATE_LANGUAGE = SetsKt.setOf((Object[])objectArray);
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), XmlTag.class, (boolean)false);
        XmlAttribute xmlAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), XmlAttribute.class, (boolean)false);
        if (xmlTag == null || xmlAttribute == null) {
            return;
        }
        for (String completion : this.listOfCompletions(xmlTag, xmlAttribute)) {
            result.addElement((LookupElement)LookupElementBuilder.create((String)completion));
        }
    }

    private final Set<String> listOfCompletions(XmlTag xmlTag, XmlAttribute xmlAttribute) {
        String string = xmlAttribute.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return switch (WhenMappings.$EnumSwitchMapping$0[VueAttributeNameParser.Companion.parse((CharSequence)string, xmlTag).getKind().ordinal()]) {
            case 1 -> this.VUE_SCRIPT_LANGUAGE;
            case 2 -> this.VUE_STYLE_LANGUAGE;
            case 3 -> this.VUE_TEMPLATE_LANGUAGE;
            case 4 -> {
                void $this$mapTo$iv$iv;
                XmlTag v2 = xmlAttribute.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getParent(...)");
                Iterable $this$map$iv = VueSlotUtilsKt.getAvailableSlotsCompletions(v2, "", 0, false);
                boolean $i$f$map = false;
                Iterable var5_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    PolySymbolCodeCompletionItem var10_10 = (PolySymbolCodeCompletionItem)item$iv$iv;
                    Collection var12_12 = destination$iv$iv;
                    boolean $i$a$-map-VueAttributeValueCompletionProvider$listOfCompletions$1 = false;
                    var12_12.add(it.getName());
                }
                yield CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            }
            default -> SetsKt.emptySet();
        };
    }

    private final Set<String> vueStyleLanguages() {
        List result = new ArrayList();
        result.add("css");
        List list = CSSLanguage.INSTANCE.getDialects();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDialects(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string;
            Language it = (Language)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it.getDisplayName(), (Object)"JQuery-CSS")) continue;
            Intrinsics.checkNotNullExpressionValue((Object)it.getDisplayName(), (String)"getDisplayName(...)");
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            result.add(string2);
        }
        return CollectionsKt.toSet((Iterable)result);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VueAttributeNameParser.VueAttributeKind.values().length];
            try {
                nArray[VueAttributeNameParser.VueAttributeKind.SCRIPT_LANG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VueAttributeNameParser.VueAttributeKind.STYLE_LANG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VueAttributeNameParser.VueAttributeKind.TEMPLATE_LANG.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VueAttributeNameParser.VueAttributeKind.SLOT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

