/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.model.source;

import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.model.Pointer;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolService;
import com.intellij.polySymbols.PolySymbolKind;
import com.intellij.polySymbols.search.PsiSourcedPolySymbol;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.codeInsight.VueUtilKt;
import org.jetbrains.vuejs.model.VueDirective;
import org.jetbrains.vuejs.model.VueDirectiveModifier;
import org.jetbrains.vuejs.model.VueEntitiesContainer;
import org.jetbrains.vuejs.model.VueMode;
import org.jetbrains.vuejs.model.typed.VueTypedDirectives;
import org.jetbrains.vuejs.web.VueSymbolQueryConfiguratorKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00000 H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\t\u0010%\u001a\u00020\u0004H\u00c6\u0003J\t\u0010&\u001a\u00020\u0006H\u00c2\u0003J\t\u0010'\u001a\u00020\bH\u00c2\u0003J'\u0010(\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0014\u0010)\u001a\u00020\"2\b\u0010*\u001a\u0004\u0018\u00010+H\u00d6\u0083\u0004J\n\u0010,\u001a\u00020-H\u00d6\u0081\u0004J\n\u0010.\u001a\u00020\u0004H\u00d6\u0081\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0016\u001a\u00020\u00178VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0011\u00a8\u0006/"}, d2={"Lorg/jetbrains/vuejs/model/source/VueScriptSetupLocalDirective;", "Lorg/jetbrains/vuejs/model/VueDirective;", "Lcom/intellij/polySymbols/search/PsiSourcedPolySymbol;", "name", "", "rawSource", "Lcom/intellij/lang/javascript/psi/JSPsiNamedElementBase;", "mode", "Lorg/jetbrains/vuejs/model/VueMode;", "<init>", "(Ljava/lang/String;Lcom/intellij/lang/javascript/psi/JSPsiNamedElementBase;Lorg/jetbrains/vuejs/model/VueMode;)V", "getName", "()Ljava/lang/String;", "parents", "", "Lorg/jetbrains/vuejs/model/VueEntitiesContainer;", "getParents", "()Ljava/util/List;", "kind", "Lcom/intellij/polySymbols/PolySymbolKind;", "getKind", "()Lcom/intellij/polySymbols/PolySymbolKind;", "source", "Lcom/intellij/psi/PsiElement;", "getSource", "()Lcom/intellij/psi/PsiElement;", "source$delegate", "Lkotlin/Lazy;", "directiveModifiers", "Lorg/jetbrains/vuejs/model/VueDirectiveModifier;", "getDirectiveModifiers", "createPointer", "Lcom/intellij/model/Pointer;", "isEquivalentTo", "", "symbol", "Lcom/intellij/model/Symbol;", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "", "toString", "intellij.vuejs.backend"})
@SourceDebugExtension(value={"SMAP\nVueScriptSetupLocalDirective.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VueScriptSetupLocalDirective.kt\norg/jetbrains/vuejs/model/source/VueScriptSetupLocalDirective\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n1#2:63\n*E\n"})
public final class VueScriptSetupLocalDirective
implements VueDirective,
PsiSourcedPolySymbol {
    @NotNull
    private final String name;
    @NotNull
    private final JSPsiNamedElementBase rawSource;
    @NotNull
    private final VueMode mode;
    @NotNull
    private final List<VueEntitiesContainer> parents;
    @NotNull
    private final Lazy source$delegate;

    public VueScriptSetupLocalDirective(@NotNull String name, @NotNull JSPsiNamedElementBase rawSource, @NotNull VueMode mode) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)rawSource, (String)"rawSource");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this.name = name;
        this.rawSource = rawSource;
        this.mode = mode;
        this.parents = CollectionsKt.emptyList();
        this.source$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> VueScriptSetupLocalDirective.source_delegate$lambda$0(this));
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public List<VueEntitiesContainer> getParents() {
        return this.parents;
    }

    @NotNull
    public PolySymbolKind getKind() {
        return VueSymbolQueryConfiguratorKt.getVUE_SCRIPT_SETUP_LOCAL_DIRECTIVES();
    }

    @Override
    @NotNull
    public PsiElement getSource() {
        Lazy lazy = this.source$delegate;
        return (PsiElement)lazy.getValue();
    }

    @Override
    @NotNull
    public List<VueDirectiveModifier> getDirectiveModifiers() {
        Object object = CachedValuesManager.getCachedValue((PsiElement)this.getSource(), () -> VueScriptSetupLocalDirective._get_directiveModifiers_$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (List)object;
    }

    @NotNull
    public Pointer<VueScriptSetupLocalDirective> createPointer() {
        String name = this.getName();
        SmartPsiElementPointer source = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)this.rawSource));
        VueMode mode = this.mode;
        return () -> VueScriptSetupLocalDirective.createPointer$lambda$0(source, name, mode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isEquivalentTo(@NotNull Symbol symbol) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        if (super.isEquivalentTo(symbol)) return true;
        PsiElement psiElement = PsiSymbolService.getInstance().extractElementFromSymbol(symbol);
        if (psiElement == null) return false;
        PsiElement it = psiElement;
        boolean bl = false;
        if (!it.getManager().areElementsEquivalent(it, (PsiElement)this.rawSource)) return false;
        return true;
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    private final JSPsiNamedElementBase component2() {
        return this.rawSource;
    }

    private final VueMode component3() {
        return this.mode;
    }

    @NotNull
    public final VueScriptSetupLocalDirective copy(@NotNull String name, @NotNull JSPsiNamedElementBase rawSource, @NotNull VueMode mode) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)rawSource, (String)"rawSource");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        return new VueScriptSetupLocalDirective(name, rawSource, mode);
    }

    public static /* synthetic */ VueScriptSetupLocalDirective copy$default(VueScriptSetupLocalDirective vueScriptSetupLocalDirective, String string, JSPsiNamedElementBase jSPsiNamedElementBase, VueMode vueMode, int n, Object object) {
        if ((n & 1) != 0) {
            string = vueScriptSetupLocalDirective.name;
        }
        if ((n & 2) != 0) {
            jSPsiNamedElementBase = vueScriptSetupLocalDirective.rawSource;
        }
        if ((n & 4) != 0) {
            vueMode = vueScriptSetupLocalDirective.mode;
        }
        return vueScriptSetupLocalDirective.copy(string, jSPsiNamedElementBase, vueMode);
    }

    @NotNull
    public String toString() {
        return "VueScriptSetupLocalDirective(name=" + this.name + ", rawSource=" + this.rawSource + ", mode=" + this.mode + ")";
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + this.rawSource.hashCode();
        result = result * 31 + this.mode.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VueScriptSetupLocalDirective)) {
            return false;
        }
        VueScriptSetupLocalDirective vueScriptSetupLocalDirective = (VueScriptSetupLocalDirective)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)vueScriptSetupLocalDirective.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.rawSource, (Object)vueScriptSetupLocalDirective.rawSource)) {
            return false;
        }
        return this.mode == vueScriptSetupLocalDirective.mode;
    }

    private static final JSPsiNamedElementBase source_delegate$lambda$0(VueScriptSetupLocalDirective this$0) {
        return VueUtilKt.resolveIfImportSpecifier(this$0.rawSource);
    }

    private static final CachedValueProvider.Result _get_directiveModifiers_$lambda$0(VueScriptSetupLocalDirective this$0) {
        Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
        return CachedValueProvider.Result.create(VueTypedDirectives.INSTANCE.getDirectiveModifiers(this$0.getSource(), this$0.mode), (Object[])objectArray);
    }

    private static final VueScriptSetupLocalDirective createPointer$lambda$0(SmartPsiElementPointer $source, String $name, VueMode $mode) {
        JSPsiNamedElementBase jSPsiNamedElementBase = (JSPsiNamedElementBase)$source.dereference();
        if (jSPsiNamedElementBase == null) {
            return null;
        }
        JSPsiNamedElementBase newSource = jSPsiNamedElementBase;
        return new VueScriptSetupLocalDirective($name, newSource, $mode);
    }
}

