/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.model.typed;

import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.modules.JSDirectorySearchProcessor;
import com.intellij.lang.javascript.frameworks.modules.JSExactFileReference;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterfaceClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.stubs.JSFrameworkMarkersIndex;
import com.intellij.lang.javascript.psi.stubs.JSStubElement;
import com.intellij.lang.javascript.psi.stubs.TypeScriptSingleTypeStub;
import com.intellij.lang.javascript.psi.stubs.TypeScriptTypeArgumentListStub;
import com.intellij.lang.javascript.psi.stubs.TypeScriptUnionOrIntersectionTypeStub;
import com.intellij.lang.javascript.psi.types.JSModuleTypeImpl;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.modules.TypeScriptNodeSearchProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveVisitor;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubElement;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.codeInsight.VueUtilKt;
import org.jetbrains.vuejs.model.VueComponent;
import org.jetbrains.vuejs.model.VueLocallyDefinedComponent;
import org.jetbrains.vuejs.model.VueNamedComponent;
import org.jetbrains.vuejs.model.typed.VueTypedComponent;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\r\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00110\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/vuejs/model/typed/VueTypedEntitiesProvider;", "", "<init>", "()V", "vueComponentTypenameRegex", "Lkotlin/text/Regex;", "isComponentDefinition", "", "definition", "Lcom/intellij/lang/javascript/psi/ecmal4/JSQualifiedNamedElement;", "checkType", "typeElement", "Lcom/intellij/lang/javascript/psi/ecma6/TypeScriptType;", "checkTypeName", "typeName", "", "getComponent", "Lorg/jetbrains/vuejs/model/VueNamedComponent;", "element", "Lcom/intellij/psi/PsiElement;", "calculateDtsComponents", "", "moduleDir", "Lcom/intellij/psi/PsiDirectory;", "intellij.vuejs.backend"})
@SourceDebugExtension(value={"SMAP\nVueTypedEntitiesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VueTypedEntitiesProvider.kt\norg/jetbrains/vuejs/model/typed/VueTypedEntitiesProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,163:1\n1#2:164\n18#3:165\n1915#4,2:166\n1915#4,2:168\n1915#4,2:170\n*S KotlinDebug\n*F\n+ 1 VueTypedEntitiesProvider.kt\norg/jetbrains/vuejs/model/typed/VueTypedEntitiesProvider\n*L\n55#1:165\n128#1:166,2\n153#1:168,2\n82#1:170,2\n*E\n"})
public final class VueTypedEntitiesProvider {
    @NotNull
    public static final VueTypedEntitiesProvider INSTANCE = new VueTypedEntitiesProvider();
    @NotNull
    private static final Regex vueComponentTypenameRegex = new Regex("(import\\s*\\(\\s*['\"]vue['\"]\\s*\\)\\s*\\.\\s*|vue\\s*\\.\\s*)?(DefineComponent|ComponentOptionsBase|ComponentOptionsMixin|ComponentCustomProps|__VLS_WithTemplateSlots|__VLS_WithSlots(\\$[0-9]+)?)");

    private VueTypedEntitiesProvider() {
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isComponentDefinition(@NotNull JSQualifiedNamedElement definition) {
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        if (definition.getName() == null) return false;
        if (definition instanceof JSField) {
            return false;
        }
        JSQualifiedNamedElement jSQualifiedNamedElement = definition;
        if (jSQualifiedNamedElement instanceof TypeScriptVariable) {
            TypeScriptTypeAlias typeScriptTypeAlias;
            void $this$asSafely$iv;
            TypeScriptType typeScriptType = ((TypeScriptVariable)definition).getTypeElement();
            if (typeScriptType == null) {
                return false;
            }
            TypeScriptType typeElement = typeScriptType;
            if (this.checkType(typeElement)) {
                return true;
            }
            if (!(typeElement instanceof TypeScriptSingleType)) return false;
            String string = ((TypeScriptSingleType)typeElement).getQualifiedTypeName();
            if (string == null) return false;
            String it = string;
            boolean bl = false;
            PsiElement psiElement = JSStubBasedPsiTreeUtil.resolveLocally((String)it, (PsiElement)((PsiElement)typeElement));
            if (psiElement == null) return false;
            it = psiElement;
            boolean $i$f$asSafely = false;
            Object v1 = $this$asSafely$iv;
            if (!(v1 instanceof TypeScriptTypeAlias)) {
                v1 = null;
            }
            if ((typeScriptTypeAlias = (TypeScriptTypeAlias)v1) == null) return false;
            TypeScriptType typeScriptType2 = typeScriptTypeAlias.getTypeDeclaration();
            TypeScriptType aliasedType = typeScriptType2;
            if (aliasedType == null) return false;
            if (!this.checkType(aliasedType)) return false;
            return true;
        }
        if (!(jSQualifiedNamedElement instanceof TypeScriptClass)) return false;
        return TypeScriptUtil.isDefinitionFile((PsiFile)((TypeScriptClass)definition).getContainingFile());
    }

    private final boolean checkType(TypeScriptType typeElement) {
        StubElement typeStub;
        Ref.BooleanRef result = new Ref.BooleanRef();
        StubBasedPsiElement stubBasedPsiElement = typeElement instanceof StubBasedPsiElement ? (StubBasedPsiElement)typeElement : null;
        Object object = typeStub = stubBasedPsiElement != null ? stubBasedPsiElement.getStub() : null;
        if (typeStub != null) {
            VueTypedEntitiesProvider.checkType$visit(result, (Stub)typeStub);
        } else {
            typeElement.accept((PsiElementVisitor)new PsiRecursiveVisitor(result){
                final /* synthetic */ Ref.BooleanRef $result;
                {
                    this.$result = $result;
                }

                public void visitJSElement(JSElement node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    if (node instanceof TypeScriptSingleType && VueTypedEntitiesProvider.access$checkTypeName(VueTypedEntitiesProvider.INSTANCE, ((TypeScriptSingleType)node).getQualifiedTypeName())) {
                        this.$result.element = true;
                    } else if (node instanceof TypeScriptTypeArgumentList || node instanceof TypeScriptUnionOrIntersectionType || node instanceof TypeScriptSingleType) {
                        node.acceptChildren((PsiElementVisitor)this);
                    }
                }
            });
        }
        return result.element;
    }

    private final boolean checkTypeName(String typeName) {
        CharSequence charSequence;
        return typeName != null && vueComponentTypenameRegex.matches(charSequence = (CharSequence)typeName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final VueNamedComponent getComponent(@Nullable PsiElement element) {
        JSElement jSElement;
        JSElement jSElement2 = new JSElement[]{Reflection.getOrCreateKotlinClass(TypeScriptVariable.class), Reflection.getOrCreateKotlinClass(TypeScriptInterfaceClass.class)};
        JSElement jSElement3 = (JSElement)VueUtilKt.resolveElementTo(element, jSElement2);
        if (jSElement3 == null) return null;
        JSElement it = jSElement = jSElement3;
        boolean bl = false;
        if (!INSTANCE.isComponentDefinition((JSQualifiedNamedElement)it)) return null;
        JSElement jSElement4 = jSElement;
        jSElement2 = jSElement4;
        if (jSElement2 == null) return null;
        it = jSElement2;
        boolean bl2 = false;
        VueNamedComponent vueNamedComponent = VueTypedComponent.Companion.create((JSQualifiedNamedElement)it);
        return vueNamedComponent;
    }

    @NotNull
    public final Map<String, VueNamedComponent> calculateDtsComponents(@NotNull PsiDirectory moduleDir) {
        JSFile mainPsiFile;
        PsiFile psiFile;
        VirtualFile mainFile;
        Intrinsics.checkNotNullParameter((Object)moduleDir, (String)"moduleDir");
        Map componentsFromDts = new LinkedHashMap();
        Project project = moduleDir.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Set componentDefs = CollectionsKt.toSet((Iterable)JSFrameworkMarkersIndex.Companion.getElements("Vue Typed Component", TypeScriptVariable.class, project, GlobalSearchScopesCore.directoryScope((PsiDirectory)moduleDir, (boolean)true)));
        if (componentDefs.isEmpty()) {
            return MapsKt.emptyMap();
        }
        TypeScriptNodeSearchProcessor searchProcessor = new TypeScriptNodeSearchProcessor();
        VirtualFile virtualFile = mainFile = JSExactFileReference.resolveForNpmPackages((VirtualFile)moduleDir.getVirtualFile(), (JSDirectorySearchProcessor)((JSDirectorySearchProcessor)searchProcessor));
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            psiFile = moduleDir.getManager().findFile(it);
        } else {
            psiFile = null;
        }
        Object object = psiFile;
        JSFile jSFile = mainPsiFile = object instanceof JSFile ? (JSFile)object : null;
        if (mainPsiFile != null) {
            object = new JSModuleTypeImpl(mainPsiFile, false).asRecordType().getProperties();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getProperties(...)");
            object = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KClass[] kClassArray;
                KClass[] kClassArray2;
                block15: {
                    JSRecordType.PropertySignature export = (JSRecordType.PropertySignature)element$iv;
                    boolean bl = false;
                    List list = export.getMemberSource().getAllSourceElements();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllSourceElements(...)");
                    for (KClass[] memberSource : (Iterable)list) {
                        VueNamedComponent vueNamedComponent;
                        boolean bl2 = false;
                        JSPsiNamedElementBase jSPsiNamedElementBase = memberSource instanceof JSPsiNamedElementBase ? (JSPsiNamedElementBase)memberSource : null;
                        if (!Intrinsics.areEqual((Object)(jSPsiNamedElementBase != null ? jSPsiNamedElementBase.getName() : null), (Object)export.getMemberName())) {
                            vueNamedComponent = null;
                        } else {
                            TypeScriptVariable variable;
                            KClass[] kClassArray3 = memberSource;
                            TypeScriptVariable typeScriptVariable = kClassArray3 instanceof TypeScriptVariable ? (TypeScriptVariable)kClassArray3 : null;
                            if (typeScriptVariable == null) {
                                kClassArray3 = new KClass[]{Reflection.getOrCreateKotlinClass(TypeScriptVariable.class)};
                                typeScriptVariable = (TypeScriptVariable)VueUtilKt.resolveElementTo((PsiElement)memberSource, kClassArray3);
                            }
                            if ((variable = typeScriptVariable) != null && componentDefs.contains(variable)) {
                                VueNamedComponent vueNamedComponent2 = VueTypedComponent.Companion.create((JSQualifiedNamedElement)variable);
                                if (vueNamedComponent2 != null) {
                                    VueNamedComponent it = vueNamedComponent2;
                                    boolean bl3 = false;
                                    vueNamedComponent = !Intrinsics.areEqual((Object)memberSource, (Object)variable) ? (VueNamedComponent)VueLocallyDefinedComponent.Companion.create((VueComponent)it, (JSPsiNamedElementBase)memberSource) : it;
                                } else {
                                    vueNamedComponent = null;
                                }
                            } else {
                                vueNamedComponent = null;
                            }
                        }
                        if ((memberSource = vueNamedComponent) == null) continue;
                        kClassArray2 = memberSource;
                        break block15;
                    }
                    kClassArray2 = null;
                }
                if ((kClassArray = kClassArray2) == null) continue;
                KClass[] it = kClassArray;
                boolean bl = false;
                componentsFromDts.put(it.getName(), it);
            }
        } else {
            $this$forEach$iv = componentDefs;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VueNamedComponent it;
                TypeScriptVariable variable = (TypeScriptVariable)element$iv;
                boolean bl = false;
                String name = variable.getName();
                if (!variable.isExported() || name == null) continue;
                if (VueTypedComponent.Companion.create((JSQualifiedNamedElement)variable) == null) continue;
                boolean bl4 = false;
                componentsFromDts.put(name, it);
            }
        }
        return componentsFromDts;
    }

    private static final void checkType$visit(Ref.BooleanRef result, Stub stub) {
        if (stub instanceof TypeScriptSingleTypeStub && INSTANCE.checkTypeName(((TypeScriptSingleTypeStub)stub).getQualifiedTypeName())) {
            result.element = true;
        } else if (stub instanceof TypeScriptTypeArgumentListStub || stub instanceof TypeScriptUnionOrIntersectionTypeStub || stub instanceof TypeScriptSingleTypeStub) {
            List list = ((JSStubElement)stub).getChildrenStubs();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenStubs(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                StubElement it = (StubElement)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                VueTypedEntitiesProvider.checkType$visit(result, (Stub)it);
            }
        }
    }

    public static final /* synthetic */ boolean access$checkTypeName(VueTypedEntitiesProvider $this, String typeName) {
        return $this.checkTypeName(typeName);
    }
}

