/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.impl.CoreCommandProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class CommandListeners
implements CommandListener {
    private final List<CommandListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    CommandListeners() {
    }

    void addCommandListener(@NotNull CommandListener listener) {
        if (listener == null) {
            CommandListeners.$$$reportNull$$$0(0);
        }
        this.myListeners.add(listener);
    }

    public void commandStarted(@NotNull CommandEvent event) {
        if (event == null) {
            CommandListeners.$$$reportNull$$$0(1);
        }
        for (CommandListener listener : this.myListeners) {
            try {
                listener.commandStarted(event);
            }
            catch (Throwable e) {
                CoreCommandProcessor.LOG.error(e);
            }
        }
    }

    public void beforeCommandFinished(@NotNull CommandEvent event) {
        if (event == null) {
            CommandListeners.$$$reportNull$$$0(2);
        }
        for (CommandListener listener : this.myListeners) {
            try {
                listener.beforeCommandFinished(event);
            }
            catch (Throwable e) {
                CoreCommandProcessor.LOG.error(e);
            }
        }
    }

    public void commandFinished(@NotNull CommandEvent event) {
        if (event == null) {
            CommandListeners.$$$reportNull$$$0(3);
        }
        for (CommandListener listener : this.myListeners) {
            try {
                listener.commandFinished(event);
            }
            catch (Throwable e) {
                CoreCommandProcessor.LOG.error(e);
            }
        }
    }

    public void undoTransparentActionStarted() {
        for (CommandListener listener : this.myListeners) {
            try {
                listener.undoTransparentActionStarted();
            }
            catch (Throwable e) {
                CoreCommandProcessor.LOG.error(e);
            }
        }
    }

    public void beforeUndoTransparentActionFinished() {
        for (CommandListener listener : this.myListeners) {
            try {
                listener.beforeUndoTransparentActionFinished();
            }
            catch (Throwable e) {
                CoreCommandProcessor.LOG.error(e);
            }
        }
    }

    public void undoTransparentActionFinished() {
        for (CommandListener listener : this.myListeners) {
            try {
                listener.undoTransparentActionFinished();
            }
            catch (Throwable e) {
                CoreCommandProcessor.LOG.error(e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/command/impl/CommandListeners";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCommandListener";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "commandStarted";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeCommandFinished";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "commandFinished";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

