/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.codeInsight.multiverse.CodeInsightContextManager;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiManagerEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PsiConsistencyAssertions {
    public static void assertNoFileTextMismatch(@NotNull PsiFile psiFile, @NotNull ASTNode tree, @NotNull String psiFileText) {
        FileViewProvider viewProvider;
        Document document;
        if (psiFile == null) {
            PsiConsistencyAssertions.$$$reportNull$$$0(0);
        }
        if (tree == null) {
            PsiConsistencyAssertions.$$$reportNull$$$0(1);
        }
        if (psiFileText == null) {
            PsiConsistencyAssertions.$$$reportNull$$$0(2);
        }
        Document document2 = document = (viewProvider = psiFile.getViewProvider()) instanceof AbstractFileViewProvider ? ((AbstractFileViewProvider)viewProvider).getCachedDocument() : FileDocumentManager.getInstance().getCachedDocument(viewProvider.getVirtualFile());
        if (document == null) {
            throw new AssertionError((Object)("File text mismatch: tree.length=" + tree.getTextLength() + "; psi.length=" + psiFileText.length() + "; this=" + psiFile + "; vp=" + viewProvider));
        }
        PsiConsistencyAssertions.assertNoFileTextMismatch(psiFile, document, psiFileText);
    }

    public static void assertNoFileTextMismatch(@NotNull PsiFile psiFile, @NotNull Document document, @Nullable(value="null means not computed yet") @Nullable(value="null means not computed yet") String psiFileText) {
        String psiFileTextLength;
        if (psiFile == null) {
            PsiConsistencyAssertions.$$$reportNull$$$0(3);
        }
        if (document == null) {
            PsiConsistencyAssertions.$$$reportNull$$$0(4);
        }
        int docLength = document.getTextLength();
        int psiLength = psiFile.getTextLength();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)psiFile.getProject());
        boolean committed = !documentManager.isUncommited(document);
        FileASTNode node = psiFile.getNode();
        FileViewProvider viewProvider = psiFile.getViewProvider();
        if (docLength == psiLength && committed && (node == null || node.getTextLength() == viewProvider.getContents().length())) {
            return;
        }
        String message = "file text mismatch:";
        message = message + "\nmatching=" + (psiFile == documentManager.getPsiFile(document));
        message = message + "\ninjected=" + (document instanceof DocumentWindow);
        message = message + "\ninjectedFile=" + InjectedLanguageManager.getInstance((Project)psiFile.getProject()).isInjectedFragment(psiFile);
        message = message + "\ncommitted=" + committed;
        message = message + "\nfile=" + psiFile.getName();
        message = message + "\nfile class=" + psiFile.getClass();
        message = message + "\nfile.valid=" + psiFile.isValid();
        message = message + "\nfile.physical=" + psiFile.isPhysical();
        message = message + "\nfile.eventSystemEnabled=" + viewProvider.isEventSystemEnabled();
        message = message + "\nlanguage=" + psiFile.getLanguage();
        message = message + "\ndoc.length=" + docLength;
        message = message + "\npsiFile.length=" + psiLength;
        message = message + "\ncached.psiFiles=" + PsiManagerEx.getInstanceEx(psiFile.getProject()).getFileManagerEx().findCachedViewProviders(viewProvider.getVirtualFile()).size();
        message = message + "\ncode.insight.contexts=" + CodeInsightContextManager.getInstance((Project)psiFile.getProject()).getCodeInsightContexts(viewProvider.getVirtualFile()).size();
        try {
            if (psiFileText == null) {
                psiFileText = psiFile.getText();
            }
            psiFileTextLength = "" + psiFileText.length();
        }
        catch (Throwable e) {
            psiFileText = "";
            psiFileTextLength = "(unknown; " + e + ")";
        }
        message = message + "\npsiFile.text.length=" + psiFileTextLength;
        if (node != null) {
            message = message + "\nnode.length=" + node.getTextLength();
            String nodeText = node.getText();
            message = message + "\nnode.text.length=" + nodeText.length();
        }
        message = message + "\ncontents.length=" + viewProvider.getContents().length();
        message = message + "\nviewProvider=" + viewProvider;
        VirtualFile virtualFile = viewProvider.getVirtualFile();
        message = message + "\nvirtualFile=" + virtualFile;
        message = message + "\nvirtualFile.class=" + virtualFile.getClass();
        message = message + "\n" + DebugUtil.currentStackTrace();
        throw new RuntimeExceptionWithAttachments("File text mismatch", message, new Attachment[]{new Attachment(virtualFile.getPath() + "_file.txt", psiFileText), PsiConsistencyAssertions.createAstAttachment(psiFile, psiFile), new Attachment("docText.txt", document.getText())});
    }

    private static Attachment createAstAttachment(PsiFile fileCopy, PsiFile originalFile) {
        return new Attachment(originalFile.getViewProvider().getVirtualFile().getPath() + " syntactic tree.txt", DebugUtil.psiToString((PsiElement)fileCopy, true, true));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "tree";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "psiFileText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "document";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/PsiConsistencyAssertions";
        objectArray[2] = "assertNoFileTextMismatch";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

