/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.CachedValueBase;
import com.intellij.util.CachedValueLeakChecker;
import com.intellij.util.CachedValueStabilityChecker;
import com.intellij.util.CachedValuesFactory;
import com.intellij.util.DefaultCachedValuesFactory;
import com.intellij.util.containers.CollectionFactory;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CachedValuesManagerImpl
extends CachedValuesManager
implements Disposable {
    private static final Object NULL = new Object();
    private ConcurrentMap<UserDataHolder, Object> myCacheHolders = CollectionFactory.createConcurrentWeakIdentityMap();
    private Set<Key<?>> myKeys = ConcurrentHashMap.newKeySet();
    private final Project myProject;
    private final CachedValuesFactory myFactory;

    public CachedValuesManagerImpl(Project project) {
        this(project, (CachedValuesFactory)project.getService(CachedValuesFactory.class));
    }

    @NonInjectable
    public CachedValuesManagerImpl(Project project, CachedValuesFactory factory) {
        this.myProject = project;
        this.myFactory = factory == null ? new DefaultCachedValuesFactory(project) : factory;
    }

    @NotNull
    public <T> CachedValue<T> createCachedValue(@NotNull CachedValueProvider<T> provider, boolean trackValue) {
        if (provider == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(0);
        }
        CachedValue<T> cachedValue = this.myFactory.createCachedValue(provider, trackValue);
        if (cachedValue == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(1);
        }
        return cachedValue;
    }

    @NotNull
    public <T> CachedValue<T> createCachedValue(@NotNull UserDataHolder userDataHolder, @NotNull CachedValueProvider<T> provider, boolean trackValue) {
        if (userDataHolder == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(2);
        }
        if (provider == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(3);
        }
        CachedValue<T> cachedValue = this.myFactory.createCachedValue(userDataHolder, provider, trackValue);
        if (cachedValue == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(4);
        }
        return cachedValue;
    }

    @NotNull
    public <T, P> ParameterizedCachedValue<T, P> createParameterizedCachedValue(@NotNull ParameterizedCachedValueProvider<T, P> provider, boolean trackValue) {
        if (provider == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(5);
        }
        ParameterizedCachedValue<T, P> parameterizedCachedValue = this.myFactory.createParameterizedCachedValue(provider, trackValue);
        if (parameterizedCachedValue == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(6);
        }
        return parameterizedCachedValue;
    }

    @NotNull
    protected <T, P> ParameterizedCachedValue<T, P> createParameterizedCachedValue(@NotNull UserDataHolder userDataHolder, @NotNull ParameterizedCachedValueProvider<T, P> provider, boolean trackValue) {
        if (userDataHolder == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(7);
        }
        if (provider == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(8);
        }
        ParameterizedCachedValue<T, P> parameterizedCachedValue = this.myFactory.createParameterizedCachedValue(userDataHolder, provider, trackValue);
        if (parameterizedCachedValue == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(9);
        }
        return parameterizedCachedValue;
    }

    private boolean isFromMyProject(@NotNull CachedValue<?> v) {
        if (v == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(10);
        }
        if (v instanceof CachedValueBase) {
            return ((CachedValueBase)v).isFromMyProject(this.myProject);
        }
        return true;
    }

    @Nullable
    public <T> T getCachedValue(@NotNull UserDataHolder dataHolder, @NotNull Key<CachedValue<T>> key, @NotNull CachedValueProvider<T> provider, boolean trackValue) {
        CachedValue<T> value;
        if (dataHolder == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(11);
        }
        if (key == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(12);
        }
        if (provider == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(13);
        }
        if ((value = (CachedValue<T>)dataHolder.getUserData(key)) != null && this.isFromMyProject(value)) {
            Getter data = value.getUpToDateOrNull();
            if (data != null) {
                return data.get();
            }
            CachedValueStabilityChecker.checkProvidersEquivalent(provider, value.getValueProvider(), key);
        }
        if (value == null) {
            value = this.saveInUserData(dataHolder, key, this.freshCachedValue(dataHolder, key, provider, trackValue));
        }
        return (T)value.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> CachedValue<T> saveInUserData(@NotNull UserDataHolder dataHolder, @NotNull Key<CachedValue<T>> key, CachedValue<T> value) {
        if (dataHolder == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(14);
        }
        if (key == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(15);
        }
        this.trackKeyHolder(dataHolder, key);
        if (dataHolder instanceof UserDataHolderEx) {
            return (CachedValue)((UserDataHolderEx)dataHolder).putUserDataIfAbsent(key, value);
        }
        UserDataHolder userDataHolder = dataHolder;
        synchronized (userDataHolder) {
            CachedValue existing = (CachedValue)dataHolder.getUserData(key);
            if (existing != null) {
                return existing;
            }
            dataHolder.putUserData(key, value);
            return value;
        }
    }

    protected void trackKeyHolder(@NotNull UserDataHolder dataHolder, @NotNull Key<?> key) {
        if (dataHolder == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(16);
        }
        if (key == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(17);
        }
        if (!CachedValuesManagerImpl.isClearedOnPluginUnload(dataHolder)) {
            this.myCacheHolders.put(dataHolder, NULL);
            this.myKeys.add(key);
        }
    }

    @ApiStatus.Internal
    public void dispose() {
        this.clearMyCacheHolders();
    }

    private static boolean isClearedOnPluginUnload(@NotNull UserDataHolder dataHolder) {
        if (dataHolder == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(18);
        }
        return dataHolder instanceof PsiElement || dataHolder instanceof ASTNode || dataHolder instanceof FileViewProvider;
    }

    private <T> CachedValue<T> freshCachedValue(UserDataHolder dh, Key<CachedValue<T>> key, CachedValueProvider<T> provider, boolean trackValue) {
        CachedValueLeakChecker.checkProviderDoesNotLeakPSI(provider, key, dh);
        CachedValue<T> value = this.myFactory.createCachedValue(dh, provider, trackValue);
        assert (this.isFromMyProject(value));
        return value;
    }

    @ApiStatus.Internal
    public void clearCachedValues() {
        this.clearMyCacheHolders();
        CachedValueStabilityChecker.cleanupFieldCache();
        this.myCacheHolders = CollectionFactory.createConcurrentWeakIdentityMap();
        this.myKeys = ConcurrentHashMap.newKeySet();
    }

    private void clearMyCacheHolders() {
        for (UserDataHolder holder : this.myCacheHolders.keySet()) {
            for (Key<?> key : this.myKeys) {
                holder.putUserData(key, null);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/CachedValuesManagerImpl";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userDataHolder";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 11: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataHolder";
                break;
            }
            case 12: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/CachedValuesManagerImpl";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createCachedValue";
                break;
            }
            case 6: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameterizedCachedValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCachedValue";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: {
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createParameterizedCachedValue";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isFromMyProject";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCachedValue";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "saveInUserData";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "trackKeyHolder";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isClearedOnPluginUnload";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

