/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.context;

import com.intellij.find.SearchReplaceComponent;
import com.intellij.ide.IdeEventQueue;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u001f\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010\nJ!\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a8\u0006\u0012"}, d2={"Lcom/intellij/notebooks/visualization/context/NotebookDataContextUtils;", "", "<init>", "()V", "getHoveredLine", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "contextComponent", "Ljava/awt/Component;", "(Lcom/intellij/openapi/editor/Editor;Ljava/awt/Component;)Ljava/lang/Integer;", "getCurrentEditor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "getRespectiveLineNumberInEditor", "component", "getMouseEditorOffset", "hasFocusedSearchReplaceComponent", "", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nNotebookDataContextUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookDataContextUtils.kt\ncom/intellij/notebooks/visualization/context/NotebookDataContextUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,88:1\n1#2:89\n18#3:90\n*S KotlinDebug\n*F\n+ 1 NotebookDataContextUtils.kt\ncom/intellij/notebooks/visualization/context/NotebookDataContextUtils\n*L\n84#1:90\n*E\n"})
public final class NotebookDataContextUtils {
    @NotNull
    public static final NotebookDataContextUtils INSTANCE = new NotebookDataContextUtils();

    private NotebookDataContextUtils() {
    }

    @Nullable
    public final Integer getHoveredLine(@Nullable Editor editor, @Nullable Component contextComponent) {
        Integer calculatedLine;
        Integer mouseEditorOffset;
        EditorImpl editorImpl = editor instanceof EditorImpl ? (EditorImpl)editor : null;
        if (editorImpl == null) {
            return null;
        }
        EditorImpl noteEditor = editorImpl;
        if (contextComponent instanceof EditorGutterComponentEx && (mouseEditorOffset = this.getMouseEditorOffset((Editor)noteEditor, contextComponent)) != null) {
            return mouseEditorOffset;
        }
        if (contextComponent != null && !Intrinsics.areEqual((Object)((EditorImpl)editor).getContentComponent(), (Object)contextComponent) && (calculatedLine = this.getRespectiveLineNumberInEditor((Editor)noteEditor, contextComponent)) != null) {
            return calculatedLine;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        Point point = ((EditorImpl)editor).getContentComponent().getMousePosition();
        if (point == null) {
            return null;
        }
        Point point2 = point;
        LogicalPosition logicalPosition = ((EditorImpl)editor).xyToLogicalPosition(point2);
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"xyToLogicalPosition(...)");
        LogicalPosition logicalPosition2 = logicalPosition;
        return logicalPosition2.line;
    }

    @Nullable
    public final EditorImpl getCurrentEditor(@Nullable Editor editor, @Nullable Component contextComponent) {
        EditorImpl editorImpl;
        block6: {
            Editor cachedEditor;
            Editor editor2;
            Editor editor3 = editor;
            if (editor3 != null) {
                Editor it = editor2 = editor3;
                boolean bl = false;
                v1 = NotebookCellLines.Companion.hasSupport(it) ? editor2 : null;
            } else {
                v1 = cachedEditor = null;
            }
            if (cachedEditor != null) {
                editor2 = cachedEditor;
                return editor2 instanceof EditorImpl ? (EditorImpl)editor2 : null;
            }
            Sequence componentSequence = SequencesKt.generateSequence((Object)contextComponent, NotebookDataContextUtils::getCurrentEditor$lambda$1);
            for (Component component : componentSequence) {
                EditorImpl editorImpl2;
                Object object;
                boolean bl = false;
                if ((component instanceof EditorComponentImpl ? (EditorComponentImpl)component : null) == null) {
                    object = null;
                } else {
                    EditorImpl noteEditor;
                    EditorComponentImpl editorComponentImpl;
                    editorComponentImpl = editorComponentImpl;
                    Intrinsics.checkNotNullExpressionValue((Object)editorComponentImpl.getEditor(), (String)"getEditor(...)");
                    object = NotebookCellLines.Companion.hasSupport((Editor)noteEditor) ? noteEditor : null;
                }
                if ((editorImpl2 = object) == null) continue;
                editorImpl = editorImpl2;
                break block6;
            }
            editorImpl = null;
        }
        EditorImpl noteEditor = editorImpl;
        return noteEditor;
    }

    private final Integer getRespectiveLineNumberInEditor(Editor editor, Component component) {
        Point point = SwingUtilities.convertPoint(component, 0, component.getHeight(), editor.getContentComponent());
        int documentLineCount = editor.getDocument().getLineCount();
        if (point.y < 0) {
            return null;
        }
        int prospectiveLineNumber = editor.xyToLogicalPosition((Point)point).line;
        if (prospectiveLineNumber >= documentLineCount) {
            prospectiveLineNumber = documentLineCount - 1;
        }
        return prospectiveLineNumber;
    }

    private final Integer getMouseEditorOffset(Editor editor, Component contextComponent) {
        AWTEvent aWTEvent = IdeEventQueue.Companion.getInstance().getTrueCurrentEvent();
        MouseEvent mouseEvent = aWTEvent instanceof MouseEvent ? (MouseEvent)aWTEvent : null;
        if (mouseEvent == null) {
            return null;
        }
        MouseEvent mouseEvent2 = mouseEvent;
        Point point = SwingUtilities.convertMouseEvent(mouseEvent2.getComponent(), mouseEvent2, contextComponent).getPoint();
        return editor.logicalPositionToOffset(editor.xyToLogicalPosition(point));
    }

    public final boolean hasFocusedSearchReplaceComponent(@NotNull Editor editor, @Nullable Component contextComponent) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        JComponent $this$asSafely$iv = editor.getHeaderComponent();
        boolean $i$f$asSafely = false;
        JComponent jComponent = $this$asSafely$iv;
        if (!(jComponent instanceof SearchReplaceComponent)) {
            jComponent = null;
        }
        SearchReplaceComponent searchReplaceComponent = (SearchReplaceComponent)jComponent;
        if (searchReplaceComponent == null) {
            return false;
        }
        SearchReplaceComponent searchReplaceComponent2 = searchReplaceComponent;
        return contextComponent == searchReplaceComponent2.getSearchTextComponent() || contextComponent == searchReplaceComponent2.getReplaceTextComponent();
    }

    private static final Component getCurrentEditor$lambda$1(Component it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParent();
    }
}

