/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.ui.cell.runCell;

import com.intellij.icons.AllIcons;
import com.intellij.notebooks.jupyter.core.jupyter.CellType;
import com.intellij.notebooks.ui.NotebookEditorUiUtilKt;
import com.intellij.notebooks.visualization.controllers.selfUpdate.SelfManagedCellController;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.EditorNotebookKt;
import com.intellij.notebooks.visualization.ui.ProgressStatus;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.project.DumbAwareAction;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\rH\u0002J\n\u0010\u0010\u001a\u0004\u0018\u00010\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/notebooks/visualization/ui/cell/runCell/EditorCellRunGutterController;", "Lcom/intellij/notebooks/visualization/controllers/selfUpdate/SelfManagedCellController;", "cell", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "<init>", "(Lcom/intellij/notebooks/visualization/ui/EditorCell;)V", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "runAction", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lorg/jetbrains/annotations/NotNull;", "stopAction", "dispose", "", "checkAndRebuildInlays", "updateGutterAction", "calculateAction", "intellij.notebooks.visualization"})
public final class EditorCellRunGutterController
implements SelfManagedCellController {
    @NotNull
    private final EditorCell cell;
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final DumbAwareAction runAction;
    @NotNull
    private final DumbAwareAction stopAction;

    public EditorCellRunGutterController(@NotNull EditorCell cell) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        this.cell = cell;
        this.editor = this.cell.getEditor();
        DumbAwareAction dumbAwareAction = DumbAwareAction.SimpleDumbAwareAction.create((Icon)AllIcons.Actions.Execute, arg_0 -> EditorCellRunGutterController.runAction$lambda$1(arg_0 -> EditorCellRunGutterController.runAction$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)dumbAwareAction, (String)"create(...)");
        this.runAction = dumbAwareAction;
        DumbAwareAction dumbAwareAction2 = DumbAwareAction.SimpleDumbAwareAction.create((Icon)AllIcons.Run.Stop, arg_0 -> EditorCellRunGutterController.stopAction$lambda$1(EditorCellRunGutterController::stopAction$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)dumbAwareAction2, (String)"create(...)");
        this.stopAction = dumbAwareAction2;
        NotebookEditorUiUtilKt.afterDistinctChange((ObservableProperty)((ObservableProperty)this.cell.isSelected()), (Disposable)((Disposable)this), arg_0 -> EditorCellRunGutterController._init_$lambda$0(this, arg_0));
        NotebookEditorUiUtilKt.afterDistinctChange((ObservableProperty)((ObservableProperty)this.cell.isHovered()), (Disposable)((Disposable)this), arg_0 -> EditorCellRunGutterController._init_$lambda$1(this, arg_0));
        NotebookEditorUiUtilKt.afterDistinctChange(this.cell.getNotebook().getReadOnly(), (Disposable)((Disposable)this), arg_0 -> EditorCellRunGutterController._init_$lambda$2(this, arg_0));
        NotebookEditorUiUtilKt.afterDistinctChange((ObservableProperty)((ObservableProperty)this.cell.getExecutionStatus()), (Disposable)((Disposable)this), arg_0 -> EditorCellRunGutterController._init_$lambda$3(this, arg_0));
        this.updateGutterAction();
    }

    public void dispose() {
        this.cell.getGutterAction().set(null);
    }

    @Override
    public void checkAndRebuildInlays() {
    }

    private final void updateGutterAction() {
        AnAction currentGutterAction;
        if (this.cell.getType() == CellType.MARKDOWN) {
            return;
        }
        DumbAwareAction newAction = this.calculateAction();
        if (Intrinsics.areEqual((Object)newAction, (Object)(currentGutterAction = (AnAction)this.cell.getGutterAction().get()))) {
            return;
        }
        ActionsKt.runInEdt$default(null, () -> EditorCellRunGutterController.updateGutterAction$lambda$0(this, newAction), (int)1, null);
    }

    private final DumbAwareAction calculateAction() {
        boolean isHoveredOrSelected;
        boolean isReadOnlyNotebook;
        ObservableProperty<Boolean> observableProperty = EditorNotebookKt.getNotebook((Editor)this.editor);
        boolean bl = observableProperty != null && (observableProperty = observableProperty.getReadOnly()) != null ? ((Boolean)observableProperty.get()).booleanValue() : (isReadOnlyNotebook = false);
        if (isReadOnlyNotebook) {
            return null;
        }
        boolean bl2 = isHoveredOrSelected = this.cell.isHovered().get() != false || this.cell.isSelected().get() != false;
        if (!isHoveredOrSelected) {
            return null;
        }
        ProgressStatus status = ((EditorCell.ExecutionStatus)this.cell.getExecutionStatus().get()).getStatus();
        if (status == ProgressStatus.RUNNING || status == ProgressStatus.QUEUED) {
            return this.stopAction;
        }
        return this.runAction;
    }

    private static final Unit runAction$lambda$0(EditorCellRunGutterController this$0, AnActionEvent it) {
        int cellLineOffset = this$0.cell.getInterval().getLines().getFirst();
        this$0.editor.getCaretModel().moveToOffset(this$0.editor.getDocument().getLineStartOffset(cellLineOffset));
        AnAction anAction = ActionUtil.getAction((String)"NotebookRunCellAction");
        Intrinsics.checkNotNull((Object)anAction);
        AnAction runCellAction = anAction;
        runCellAction.actionPerformed(it);
        return Unit.INSTANCE;
    }

    private static final void runAction$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit stopAction$lambda$0(AnActionEvent it) {
        AnAction anAction = ActionUtil.getAction((String)"JupyterInterruptKernelAction");
        Intrinsics.checkNotNull((Object)anAction);
        AnAction interruptKernelAction = anAction;
        interruptKernelAction.actionPerformed(it);
        return Unit.INSTANCE;
    }

    private static final void stopAction$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit _init_$lambda$0(EditorCellRunGutterController this$0, boolean it) {
        this$0.updateGutterAction();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(EditorCellRunGutterController this$0, boolean it) {
        this$0.updateGutterAction();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(EditorCellRunGutterController this$0, boolean it) {
        this$0.updateGutterAction();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(EditorCellRunGutterController this$0, EditorCell.ExecutionStatus it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateGutterAction();
        return Unit.INSTANCE;
    }

    private static final Unit updateGutterAction$lambda$0(EditorCellRunGutterController this$0, DumbAwareAction $newAction) {
        this$0.cell.getGutterAction().set((Object)$newAction);
        return Unit.INSTANCE;
    }
}

