/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.connections.actions;

import com.intellij.ide.BrowserUtil;
import com.intellij.jupyter.core.core.impl.actions.JupyterActonUpdater;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.executor.JupyterExecutionManager;
import com.intellij.jupyter.core.jupyter.actions.JupyterEditorActionBase;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterNotebookSession;
import com.intellij.jupyter.core.jupyter.connections.server.JupyterServer;
import com.intellij.jupyter.core.jupyter.connections.server.JupyterServers;
import com.intellij.jupyter.core.jupyter.helper.JupyterAnActionEventExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.py.connections.actions.JupyterOpenNotebookInBrowserActionKt;
import com.intellij.jupyter.py.connections.server.JupyterlabServer;
import com.intellij.jupyter.py.utils.JupyterPyBundle;
import com.intellij.notebooks.jupyter.core.jupyter.preview.JupyterHttpUtilsKt;
import com.intellij.notebooks.ui.editor.actions.JupyterEditorAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import java.net.URI;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/jupyter/py/connections/actions/JupyterOpenNotebookInBrowserAction;", "Lcom/intellij/jupyter/core/jupyter/actions/JupyterEditorActionBase;", "<init>", "()V", "createActionUpdater", "Lcom/intellij/jupyter/core/core/impl/actions/JupyterActonUpdater;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterOpenNotebookInBrowserAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterOpenNotebookInBrowserAction.kt\ncom/intellij/jupyter/py/connections/actions/JupyterOpenNotebookInBrowserAction\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,74:1\n23#2:75\n*S KotlinDebug\n*F\n+ 1 JupyterOpenNotebookInBrowserAction.kt\ncom/intellij/jupyter/py/connections/actions/JupyterOpenNotebookInBrowserAction\n*L\n54#1:75\n*E\n"})
public final class JupyterOpenNotebookInBrowserAction
extends JupyterEditorActionBase {
    @NotNull
    protected JupyterActonUpdater createActionUpdater() {
        return super.createActionUpdater().derive(JupyterOpenNotebookInBrowserAction::createActionUpdater$lambda$0);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Editor editor = JupyterAnActionEventExtensionsKt.getEditor((AnActionEvent)e);
        if (editor == null || (editor = JupyterEditorExtensionsKt.getNotebookFileOrNull((Editor)editor)) == null) {
            return;
        }
        Editor jupyterFile = editor;
        JupyterNotebookSession session = JupyterExecutionManager.Companion.getInstance(project2, (BackedNotebookVirtualFile)jupyterFile).getSession();
        if (session == null) {
            JupyterOpenNotebookInBrowserAction $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JupyterOpenNotebookInBrowserAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Can't open a notebook since no session is running");
            return;
        }
        URI serverUri = session.getConnectionParameters().getHttpParams().toURI();
        String notebookPath = session.getPathFromRoot();
        URI jupyterNotebookPath = JupyterHttpUtilsKt.addPathSegment((URI)JupyterHttpUtilsKt.addPathSegment((URI)serverUri, (String)"notebooks"), (String)notebookPath);
        CloseableHttpClient client = HttpClients.createMinimal();
        CloseableHttpResponse request2 = client.execute((HttpUriRequest)new HttpGet(jupyterNotebookPath));
        if (request2.getStatusLine().getStatusCode() == 200) {
            BrowserUtil.open((String)jupyterNotebookPath.toASCIIString());
            return;
        }
        URI jupyterLabPath = JupyterHttpUtilsKt.addPathSegment((URI)JupyterHttpUtilsKt.addPathSegment((URI)serverUri, (String)"lab/tree/"), (String)notebookPath);
        BrowserUtil.open((String)jupyterLabPath.toASCIIString());
    }

    private static final boolean createActionUpdater$lambda$0$0(JupyterEditorAction jupyterEditorAction, AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)jupyterEditorAction, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = event.getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        Editor editor = JupyterAnActionEventExtensionsKt.getEditor((AnActionEvent)event);
        if (editor == null || (editor = JupyterEditorExtensionsKt.getNotebookFileOrNull((Editor)editor)) == null) {
            return false;
        }
        Editor jupyterFile = editor;
        if (!event.getPresentation().isVisible()) {
            return false;
        }
        JupyterNotebookSession jupyterNotebookSession = JupyterExecutionManager.Companion.getInstance(project2, (BackedNotebookVirtualFile)jupyterFile).getSession();
        if (jupyterNotebookSession == null) {
            return false;
        }
        JupyterNotebookSession notebookSession = jupyterNotebookSession;
        JupyterServer jupyterServer = JupyterServers.Companion.getInstance().getCachedServer(notebookSession.getConnectionParameters());
        if (jupyterServer == null) {
            return false;
        }
        JupyterServer server = jupyterServer;
        return server instanceof JupyterlabServer && !JupyterOpenNotebookInBrowserActionKt.access$isItLocalFileConnectedToRemoteServer(notebookSession);
    }

    private static final Unit createActionUpdater$lambda$0$1(JupyterEditorAction jupyterEditorAction, AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)jupyterEditorAction, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String string = event.getPresentation().isEnabled() ? JupyterPyBundle.message("action.JupyterOpenNotebookInBrowserAction.text", new Object[0]) : JupyterPyBundle.message("action.JupyterOpenNotebookInBrowserAction.remote.not.started", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit createActionUpdater$lambda$0(JupyterActonUpdater.Builder $this$derive) {
        Intrinsics.checkNotNullParameter((Object)$this$derive, (String)"$this$derive");
        $this$derive.addEnabledAndVisibleProvider(JupyterOpenNotebookInBrowserAction::createActionUpdater$lambda$0$0);
        $this$derive.addVisualCustomizer(JupyterOpenNotebookInBrowserAction::createActionUpdater$lambda$0$1);
        return Unit.INSTANCE;
    }
}

