/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.debugger;

import com.intellij.jupyter.py.debugger.JupyterLineBreakpointType;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002J(\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J/\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/intellij/jupyter/py/debugger/JupyterAutoBreakpointHelper;", "", "<init>", "()V", "addBreakpointToCellIfNeeded", "", "cellPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isBreakpointInAnyJupyterNotebook", "", "manager", "Lcom/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl;", "cellLines", "Lkotlin/ranges/IntRange;", "addBreakpointToCell", "getFirstValidLineForBreakpoint", "", "jupyterLineBreakpointType", "Lcom/intellij/jupyter/py/debugger/JupyterLineBreakpointType;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/jupyter/py/debugger/JupyterLineBreakpointType;Lkotlin/ranges/IntRange;)Ljava/lang/Integer;", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterAutoBreakpointHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterAutoBreakpointHelper.kt\ncom/intellij/jupyter/py/debugger/JupyterAutoBreakpointHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n296#2,2:68\n*S KotlinDebug\n*F\n+ 1 JupyterAutoBreakpointHelper.kt\ncom/intellij/jupyter/py/debugger/JupyterAutoBreakpointHelper\n*L\n63#1:68,2\n*E\n"})
public final class JupyterAutoBreakpointHelper {
    @NotNull
    public static final JupyterAutoBreakpointHelper INSTANCE = new JupyterAutoBreakpointHelper();

    private JupyterAutoBreakpointHelper() {
    }

    public final void addBreakpointToCellIfNeeded(@NotNull NotebookIntervalPointer cellPointer, @NotNull Project project, @NotNull VirtualFile virtualFile) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            NotebookCellLines.Interval interval = cellPointer.get();
            if (interval == null || (interval = interval.getLines()) == null) break block1;
            NotebookCellLines.Interval cellLines = interval;
            boolean bl = false;
            XBreakpointManager xBreakpointManager = XDebuggerManager.getInstance((Project)project).getBreakpointManager();
            Intrinsics.checkNotNull((Object)xBreakpointManager, (String)"null cannot be cast to non-null type com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl");
            XBreakpointManagerImpl breakpointManager = (XBreakpointManagerImpl)xBreakpointManager;
            if (!INSTANCE.isBreakpointInAnyJupyterNotebook(breakpointManager, (IntRange)cellLines, virtualFile)) {
                INSTANCE.addBreakpointToCell(breakpointManager, project, virtualFile, (IntRange)cellLines);
            }
        }
    }

    private final boolean isBreakpointInAnyJupyterNotebook(XBreakpointManagerImpl manager, IntRange cellLines, VirtualFile virtualFile) {
        Collection collection = manager.getBreakpoints(JupyterLineBreakpointType.class);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getBreakpoints(...)");
        return !collection.isEmpty();
    }

    private final void addBreakpointToCell(XBreakpointManagerImpl manager, Project project, VirtualFile virtualFile, IntRange cellLines) {
        JupyterLineBreakpointType breakpointType = (JupyterLineBreakpointType)XDebuggerUtil.getInstance().findBreakpointType(JupyterLineBreakpointType.class);
        Intrinsics.checkNotNull((Object)((Object)breakpointType));
        Integer n = this.getFirstValidLineForBreakpoint(project, virtualFile, breakpointType, cellLines);
        if (n == null) {
            return;
        }
        int firstValidLine = n;
        manager.addLineBreakpoint((XLineBreakpointType)breakpointType, virtualFile.getUrl(), firstValidLine, null);
    }

    private final Integer getFirstValidLineForBreakpoint(Project project, VirtualFile virtualFile, JupyterLineBreakpointType jupyterLineBreakpointType, IntRange cellLines) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = (Iterable)cellLines;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                int line = ((Number)element$iv).intValue();
                boolean bl = false;
                if (!jupyterLineBreakpointType.canPutAt(virtualFile, line, project)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }
}

