/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.backend;

import com.intellij.terminal.backend.JediTerminalListener;
import com.intellij.util.EventDispatcher;
import com.jediterm.terminal.TerminalDisplay;
import com.jediterm.terminal.model.JediTerminal;
import com.jediterm.terminal.model.StyleState;
import com.jediterm.terminal.model.TerminalTextBuffer;
import java.util.EventListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\fJ\u000e\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\fJ\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u0010H\u0016J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u0010H\u0016J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u0010H\u0016J\u0010\u0010\"\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u0010H\u0016J\u0010\u0010#\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u0010H\u0016R!\u0010\n\u001a\u0015\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f0\u000b\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u001e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u001e\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013\u00a8\u0006$"}, d2={"Lcom/intellij/terminal/backend/ObservableJediTerminal;", "Lcom/jediterm/terminal/model/JediTerminal;", "terminalDisplay", "Lcom/jediterm/terminal/TerminalDisplay;", "textBuffer", "Lcom/jediterm/terminal/model/TerminalTextBuffer;", "initialStyleState", "Lcom/jediterm/terminal/model/StyleState;", "<init>", "(Lcom/jediterm/terminal/TerminalDisplay;Lcom/jediterm/terminal/model/TerminalTextBuffer;Lcom/jediterm/terminal/model/StyleState;)V", "dispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/terminal/backend/JediTerminalListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "value", "", "applicationArrowKeys", "getApplicationArrowKeys", "()Z", "applicationKeypad", "getApplicationKeypad", "altSendsEscape", "getAltSendsEscape", "alternativeBufferEnabled", "getAlternativeBufferEnabled", "addListener", "", "listener", "removeListener", "setApplicationArrowKeys", "enabled", "setApplicationKeypad", "setAutoNewLine", "setAltSendsEscape", "useAlternateBuffer", "intellij.terminal.backend"})
public final class ObservableJediTerminal
extends JediTerminal {
    @NotNull
    private final EventDispatcher<JediTerminalListener> dispatcher;
    private boolean applicationArrowKeys;
    private boolean applicationKeypad;
    private boolean altSendsEscape;
    private boolean alternativeBufferEnabled;

    public ObservableJediTerminal(@NotNull TerminalDisplay terminalDisplay, @NotNull TerminalTextBuffer textBuffer, @NotNull StyleState initialStyleState) {
        Intrinsics.checkNotNullParameter((Object)terminalDisplay, (String)"terminalDisplay");
        Intrinsics.checkNotNullParameter((Object)textBuffer, (String)"textBuffer");
        Intrinsics.checkNotNullParameter((Object)initialStyleState, (String)"initialStyleState");
        super(terminalDisplay, textBuffer, initialStyleState);
        EventDispatcher eventDispatcher2 = EventDispatcher.create(JediTerminalListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher2, (String)"create(...)");
        this.dispatcher = eventDispatcher2;
        this.altSendsEscape = true;
    }

    public final boolean getApplicationArrowKeys() {
        return this.applicationArrowKeys;
    }

    public final boolean getApplicationKeypad() {
        return this.applicationKeypad;
    }

    public final boolean getAltSendsEscape() {
        return this.altSendsEscape;
    }

    public final boolean getAlternativeBufferEnabled() {
        return this.alternativeBufferEnabled;
    }

    public final void addListener(@NotNull JediTerminalListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.dispatcher.addListener((EventListener)listener2);
    }

    public final void removeListener(@NotNull JediTerminalListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.dispatcher.removeListener((EventListener)listener2);
    }

    public void setApplicationArrowKeys(boolean enabled) {
        super.setApplicationArrowKeys(enabled);
        if (this.applicationArrowKeys != enabled) {
            this.applicationArrowKeys = enabled;
            ((JediTerminalListener)this.dispatcher.getMulticaster()).arrowKeysModeChanged(enabled);
        }
    }

    public void setApplicationKeypad(boolean enabled) {
        super.setApplicationKeypad(enabled);
        if (this.applicationKeypad != enabled) {
            this.applicationKeypad = enabled;
            ((JediTerminalListener)this.dispatcher.getMulticaster()).keypadModeChanged(enabled);
        }
    }

    public void setAutoNewLine(boolean enabled) {
        boolean autoNewLine = this.isAutoNewLine();
        super.setAutoNewLine(enabled);
        if (autoNewLine != enabled) {
            ((JediTerminalListener)this.dispatcher.getMulticaster()).autoNewLineChanged(enabled);
        }
    }

    public void setAltSendsEscape(boolean enabled) {
        super.setAltSendsEscape(enabled);
        if (this.altSendsEscape != enabled) {
            this.altSendsEscape = enabled;
            ((JediTerminalListener)this.dispatcher.getMulticaster()).altSendsEscapeChanged(enabled);
        }
    }

    public void useAlternateBuffer(boolean enabled) {
        if (this.alternativeBufferEnabled != enabled) {
            this.alternativeBufferEnabled = enabled;
            ((JediTerminalListener)this.dispatcher.getMulticaster()).beforeAlternateScreenBufferChanged(enabled);
        }
        super.useAlternateBuffer(enabled);
    }
}

