/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.client.ClientKind;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.client.ClientSystemInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.impl.ui.KeymapPanel;
import com.intellij.openapi.observable.properties.AtomicBooleanProperty;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.Strings;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.platform.rpc.topics.ApplicationRemoteTopicKt;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.FontComboBox;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldWithHistoryWithBrowseButtonKt;
import com.intellij.ui.dsl.listCellRenderer.BuilderKt;
import com.intellij.ui.layout.ComponentPredicate;
import com.intellij.ui.layout.ComponentPredicateKt;
import com.intellij.ui.render.RenderersKt;
import com.intellij.util.PathUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.system.OS;
import com.intellij.util.ui.UiScopeKt;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.ShortcutItem;
import org.jetbrains.plugins.terminal.ShortcutPreset;
import org.jetbrains.plugins.terminal.TerminalActionShortcutChangedEvent;
import org.jetbrains.plugins.terminal.TerminalActionShortcutChangedTopicKt;
import org.jetbrains.plugins.terminal.TerminalBundle;
import org.jetbrains.plugins.terminal.TerminalOptionsConfigurable;
import org.jetbrains.plugins.terminal.TerminalProjectOptionsProvider;
import org.jetbrains.plugins.terminal.runner.LocalShellIntegrationInjector;
import org.jetbrains.plugins.terminal.util.TerminalUtilKt;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u009c\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u001a\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u001aE\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\t0\b\"\b\b\u0000\u0010\t*\u00020\n*\b\u0012\u0004\u0012\u0002H\t0\b2\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\b\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0002\u001a \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\b*\b\u0012\u0004\u0012\u00020\u00110\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\b\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\f\u0010\u0016\u001a\u00020\u0015*\u00020\u0011H\u0002\u001a\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0001H\u0002\u001a\b\u0010\u001a\u001a\u00020\u001bH\u0002\u001a\b\u0010\u001c\u001a\u00020\u001bH\u0002\u001a!\u0010\u001d\u001a\u00020\u001b2\u0012\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u001f\"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010 \u001a\b\u0010!\u001a\u00020\"H\u0002\u001a\u0010\u0010#\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u0010\u0010$\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a,\u0010)\u001a\u00020\u0003*\u00020*2\b\b\u0001\u0010+\u001a\u00020\u00012\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u00052\u0006\u0010.\u001a\u00020\u0001H\u0002\u001a,\u0010/\u001a\u00020\u0003*\u00020\u00042\b\b\u0001\u0010+\u001a\u00020\u00012\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u00052\u0006\u0010.\u001a\u00020\u0001H\u0002\u001a\u001a\u00100\u001a\b\u0012\u0004\u0012\u0002010\b*\u00020*2\u0006\u0010.\u001a\u00020\u0001H\u0002\u001a\u0016\u00102\u001a\b\u0012\u0004\u0012\u0002030\u00052\u0006\u0010.\u001a\u00020\u0001H\u0002\u001a\u001a\u00104\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u00012\b\u00105\u001a\u0004\u0018\u000106H\u0002\u001a\u0010\u0010:\u001a\u00020-2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\"\u0010\u0010\u0000\u001a\u00020\u00018\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u00107\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u00108\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u00109\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"TERMINAL_CONFIGURABLE_ID", "", "configurables", "", "Lcom/intellij/ui/dsl/builder/Panel;", "", "Lcom/intellij/openapi/options/UnnamedConfigurable;", "setupDefaultValue", "Lcom/intellij/ui/dsl/builder/Cell;", "T", "Ljavax/swing/JComponent;", "textComponent", "Lkotlin/Function1;", "Ljavax/swing/JTextField;", "Lkotlin/ExtensionFunctionType;", "defaultValue", "setupShellField", "Lcom/intellij/ui/TextFieldWithHistoryWithBrowseButton;", "project", "Lcom/intellij/openapi/project/Project;", "newUiPredicate", "Lcom/intellij/ui/layout/ComponentPredicate;", "shellWithIntegrationSelected", "isShellWithIntegration", "", "text", "getDefaultValueColor", "Ljava/awt/Color;", "getChangedValueColor", "findColorByKey", "colorKeys", "", "([Ljava/lang/String;)Ljava/awt/Color;", "fontComboBox", "Lcom/intellij/ui/FontComboBox;", "isMac", "isWindows", "getClientSystemInfo", "Lcom/intellij/openapi/client/ClientSystemInfo;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "actionShortcutCombobox", "Lcom/intellij/ui/dsl/builder/Row;", "labelText", "presets", "Lorg/jetbrains/plugins/terminal/ShortcutPreset;", "actionId", "actionShortcutComboboxWithEnabledCheckbox", "changeActionShortcutLink", "Lcom/intellij/ui/components/ActionLink;", "getActionShortcuts", "Lcom/intellij/openapi/actionSystem/Shortcut;", "setActionShortcut", "value", "Lcom/intellij/openapi/actionSystem/KeyboardShortcut;", "TAB_SHORTCUT_PRESET", "ENTER_SHORTCUT_PRESET", "ESCAPE_SHORTCUT_PRESET", "getCtrlSpacePreset", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalOptionsConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalOptionsConfigurable.kt\norg/jetbrains/plugins/terminal/TerminalOptionsConfigurableKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,774:1\n1#2:775\n1586#3:776\n1661#3,3:777\n1586#3:780\n1661#3,3:781\n13#4:784\n*S KotlinDebug\n*F\n+ 1 TerminalOptionsConfigurable.kt\norg/jetbrains/plugins/terminal/TerminalOptionsConfigurableKt\n*L\n626#1:776\n626#1:777,3\n706#1:780\n706#1:781,3\n609#1:784\n*E\n"})
public final class TerminalOptionsConfigurableKt {
    @ApiStatus.Internal
    @NotNull
    public static final String TERMINAL_CONFIGURABLE_ID = "terminal";
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final ShortcutPreset TAB_SHORTCUT_PRESET;
    @NotNull
    private static final ShortcutPreset ENTER_SHORTCUT_PRESET;
    @NotNull
    private static final ShortcutPreset ESCAPE_SHORTCUT_PRESET;

    private static final void configurables(Panel $this$configurables, List<? extends UnnamedConfigurable> configurables) {
        for (UnnamedConfigurable unnamedConfigurable : configurables) {
            JComponent component2;
            if (unnamedConfigurable.createComponent() == null) continue;
            Panel.row$default((Panel)$this$configurables, null, arg_0 -> TerminalOptionsConfigurableKt.configurables$lambda$0(component2, unnamedConfigurable, arg_0), (int)1, null);
        }
    }

    private static final <T extends JComponent> Cell<T> setupDefaultValue(Cell<? extends T> $this$setupDefaultValue, Function1<? super T, ? extends JTextField> textComponent, String defaultValue) {
        Cell<? extends T> cell;
        Cell<? extends T> $this$setupDefaultValue_u24lambda_u240 = cell = $this$setupDefaultValue;
        boolean bl = false;
        CharSequence charSequence = defaultValue;
        if (!(charSequence == null || charSequence.length() == 0)) {
            JTextField component2 = (JTextField)textComponent.invoke((Object)$this$setupDefaultValue_u24lambda_u240.getComponent());
            Function0 updateForeground = () -> TerminalOptionsConfigurableKt.setupDefaultValue$lambda$0$0(component2, defaultValue);
            component2.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter((Function0<Unit>)updateForeground){
                final /* synthetic */ Function0<Unit> $updateForeground;
                {
                    this.$updateForeground = $updateForeground;
                }

                protected void textChanged(DocumentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.$updateForeground.invoke();
                }
            });
            updateForeground.invoke();
            if (component2 instanceof JBTextField) {
                ((JBTextField)component2).getEmptyText().setText(defaultValue);
            }
        }
        return cell;
    }

    private static final Cell<TextFieldWithHistoryWithBrowseButton> setupShellField(Cell<? extends TextFieldWithHistoryWithBrowseButton> $this$setupShellField, Project project) {
        Cell<? extends TextFieldWithHistoryWithBrowseButton> cell;
        Cell<? extends TextFieldWithHistoryWithBrowseButton> $this$setupShellField_u24lambda_u240 = cell = $this$setupShellField;
        boolean bl = false;
        Cell<? extends TextFieldWithHistoryWithBrowseButton> cell2 = $this$setupShellField_u24lambda_u240;
        JTextField jTextField = ((TextFieldWithHistory)((TextFieldWithHistoryWithBrowseButton)$this$setupShellField_u24lambda_u240.getComponent()).getChildComponent()).getTextEditor();
        Intrinsics.checkNotNullExpressionValue((Object)jTextField, (String)"getTextEditor(...)");
        JTextField textEditor = jTextField;
        if (textEditor instanceof JBTextField) {
            ((JBTextField)textEditor).getEmptyText().setText(TerminalBundle.message("settings.shell.path.detecting.default", new Object[0]));
        }
        TerminalProjectOptionsProvider projectOptionsProvider = TerminalProjectOptionsProvider.Companion.getInstance(project);
        AtomicReference<String> defaultShellPathRef = new AtomicReference<String>();
        UiScopeKt.initOnShow$default((Component)$this$setupShellField_u24lambda_u240.getComponent(), (String)"Terminal (default shell path detection)", null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(textEditor, cell2, projectOptionsProvider, defaultShellPathRef, null){
            int label;
            final /* synthetic */ JTextField $textEditor;
            final /* synthetic */ Cell<TextFieldWithHistoryWithBrowseButton> $cell;
            final /* synthetic */ TerminalProjectOptionsProvider $projectOptionsProvider;
            final /* synthetic */ AtomicReference<String> $defaultShellPathRef;
            {
                this.$textEditor = $textEditor;
                this.$cell = $cell;
                this.$projectOptionsProvider = $projectOptionsProvider;
                this.$defaultShellPathRef = $defaultShellPathRef;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(this.$projectOptionsProvider, this.$defaultShellPathRef, null){
                            int label;
                            final /* synthetic */ TerminalProjectOptionsProvider $projectOptionsProvider;
                            final /* synthetic */ AtomicReference<String> $defaultShellPathRef;
                            {
                                this.$projectOptionsProvider = $projectOptionsProvider;
                                this.$defaultShellPathRef = $defaultShellPathRef;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var11_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        v0 = this.$projectOptionsProvider.defaultShellPath((Continuation<? super String>)((Continuation)this));
                                        ** if (v0 != var11_2) goto lbl11
lbl10:
                                        // 1 sources

                                        return var11_2;
lbl11:
                                        // 1 sources

                                        ** GOTO lbl17
                                    }
                                    case 1: {
                                        try {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl17:
                                            // 2 sources

                                            var2_3 = v0;
                                            var3_4 = this.$defaultShellPathRef;
                                            it = (String)var2_3;
                                            $i$a$-also-TerminalOptionsConfigurableKt$setupShellField$1$1$defaultShellPath$1$1 = false;
                                            var3_4.set(it);
                                            $this$debug_u24default$iv = TerminalOptionsConfigurableKt.access$getLOG$p();
                                            t$iv = null;
                                            $i$f$debug = false;
                                            if ($this$debug_u24default$iv.isDebugEnabled()) {
                                                var9_12 = $this$debug_u24default$iv;
                                                $i$a$-debug$default-TerminalOptionsConfigurableKt$setupShellField$1$1$defaultShellPath$1$1$1 = false;
                                                var9_12.debug("Detected default shell path: " + it, t$iv);
                                            }
                                            var2_3 = (String)var2_3;
                                        }
                                        catch (Exception e) {
                                            $i$f$currentCoroutineContext = false;
                                            JobKt.ensureActive((CoroutineContext)this.getContext());
                                            TerminalOptionsConfigurableKt.access$getLOG$p().warn("Cannot determine default shell path", (Throwable)e);
                                            var2_3 = null;
                                        }
                                        return var2_3;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        defaultShellPath = (String)v0;
                        if (this.$textEditor instanceof JBTextField) {
                            ((JBTextField)this.$textEditor).getEmptyText().clear();
                        }
                        if (defaultShellPath != null) {
                            v1 = this.$textEditor.getText();
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getText(...)");
                            if (((CharSequence)v1).length() == 0) {
                                this.$textEditor.setText(defaultShellPath);
                            }
                        }
                        TerminalOptionsConfigurableKt.access$setupDefaultValue(this.$cell, (Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$0(com.intellij.ui.TextFieldWithHistoryWithBrowseButton ), (Lcom/intellij/ui/TextFieldWithHistoryWithBrowseButton;)Ljavax/swing/JTextField;)(), defaultShellPath);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final JTextField invokeSuspend$lambda$0(TextFieldWithHistoryWithBrowseButton $this$setupDefaultValue) {
                JTextField jTextField = ((TextFieldWithHistory)$this$setupDefaultValue.getChildComponent()).getTextEditor();
                Intrinsics.checkNotNullExpressionValue((Object)jTextField, (String)"getTextEditor(...)");
                return jTextField;
            }
        }), (int)2, null);
        TextFieldWithHistoryWithBrowseButtonKt.bindText(cell2, () -> TerminalOptionsConfigurableKt.setupShellField$lambda$0$0(projectOptionsProvider, defaultShellPathRef), arg_0 -> TerminalOptionsConfigurableKt.setupShellField$lambda$0$1(projectOptionsProvider, defaultShellPathRef, arg_0));
        return cell;
    }

    private static final ComponentPredicate newUiPredicate() {
        return ExperimentalUI.Companion.isNewUI() ? ComponentPredicate.Companion.getTRUE() : ComponentPredicate.Companion.getFALSE();
    }

    private static final ComponentPredicate shellWithIntegrationSelected(TextFieldWithHistoryWithBrowseButton $this$shellWithIntegrationSelected) {
        JTextField jTextField = ((TextFieldWithHistory)$this$shellWithIntegrationSelected.getChildComponent()).getTextEditor();
        Intrinsics.checkNotNullExpressionValue((Object)jTextField, (String)"getTextEditor(...)");
        return ComponentPredicateKt.enteredTextSatisfies((JTextComponent)jTextField, TerminalOptionsConfigurableKt::shellWithIntegrationSelected$lambda$0);
    }

    private static final boolean isShellWithIntegration(String text) {
        List list = ParametersListUtil.parse((String)text, (boolean)false, (OS.CURRENT != OS.Windows ? 1 : 0) != 0);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"parse(...)");
        List command2 = list;
        String string = (String)CollectionsKt.firstOrNull((List)command2);
        if (string == null) {
            return false;
        }
        String shellPath2 = string;
        String string2 = PathUtil.getFileName((String)shellPath2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFileName(...)");
        String shellName = string2;
        return LocalShellIntegrationInjector.supportsBlocksShellIntegration(shellName, (EelDescriptor)LocalEelDescriptor.INSTANCE);
    }

    private static final Color getDefaultValueColor() {
        String[] stringArray = new String[]{"TextField.inactiveForeground", "nimbusDisabledText"};
        return TerminalOptionsConfigurableKt.findColorByKey(stringArray);
    }

    private static final Color getChangedValueColor() {
        String[] stringArray = new String[]{"TextField.foreground"};
        return TerminalOptionsConfigurableKt.findColorByKey(stringArray);
    }

    private static final Color findColorByKey(String ... colorKeys) {
        Color color;
        block3: {
            for (String it : colorKeys) {
                boolean bl = false;
                color = UIManager.getColor(it);
                if (color == null) {
                    continue;
                }
                break block3;
            }
            color = null;
        }
        if (color == null) {
            String string = Arrays.toString(colorKeys);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            throw new IllegalStateException("Can't find color for keys " + string);
        }
        return color;
    }

    private static final FontComboBox fontComboBox() {
        FontComboBox fontComboBox;
        FontComboBox $this$fontComboBox_u24lambda_u240 = fontComboBox = new FontComboBox();
        boolean bl = false;
        $this$fontComboBox_u24lambda_u240.setRenderer(RenderersKt.fontInfoRenderer((boolean)true));
        $this$fontComboBox_u24lambda_u240.setMonospacedOnly(true);
        return fontComboBox;
    }

    private static final boolean isMac(Project project) {
        Object object = TerminalOptionsConfigurableKt.getClientSystemInfo(project);
        return object != null && (object = object.getMacClient()) != null ? (Boolean)object : SystemInfo.isMac;
    }

    private static final boolean isWindows(Project project) {
        Object object = TerminalOptionsConfigurableKt.getClientSystemInfo(project);
        return object != null && (object = object.getWindowsClient()) != null ? (Boolean)object : SystemInfo.isWindows;
    }

    private static final ClientSystemInfo getClientSystemInfo(Project project) {
        ClientProjectSession clientProjectSession = (ClientProjectSession)CollectionsKt.singleOrNull((List)ClientSessionsUtil.sessions((Project)project, (ClientKind)ClientKind.CONTROLLER));
        if (clientProjectSession == null || (clientProjectSession = clientProjectSession.getClientId()) == null) {
            return null;
        }
        ClientProjectSession clientId = clientProjectSession;
        return (ClientSystemInfo)ClientId.Companion.withExplicitClientId((ClientId)clientId, TerminalOptionsConfigurableKt::getClientSystemInfo$lambda$0);
    }

    /*
     * WARNING - void declaration
     */
    private static final void actionShortcutCombobox(Row $this$actionShortcutCombobox, @NlsContexts.Label String labelText, List<ShortcutPreset> presets, String actionId) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = presets;
        Row row = $this$actionShortcutCombobox;
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ShortcutPreset shortcutPreset = (ShortcutPreset)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ShortcutItem.Preset((ShortcutPreset)it));
        }
        ComboBox comboBox = (ComboBox)ComboBoxKt.bindItem((Cell)Cell.label$default((Cell)row.comboBox((Collection)CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)ShortcutItem.Custom.INSTANCE), BuilderKt.textListCellRenderer(TerminalOptionsConfigurableKt::actionShortcutCombobox$lambda$1)), (String)labelText, null, (int)2, null), () -> TerminalOptionsConfigurableKt.actionShortcutCombobox$lambda$2(actionId, presets), arg_0 -> TerminalOptionsConfigurableKt.actionShortcutCombobox$lambda$3(actionId, arg_0)).getComponent();
        TerminalOptionsConfigurableKt.changeActionShortcutLink($this$actionShortcutCombobox, actionId).visibleIf(ComponentPredicateKt.selectedValueIs((JComboBox)((JComboBox)comboBox), (Object)ShortcutItem.Custom.INSTANCE));
    }

    private static final void actionShortcutComboboxWithEnabledCheckbox(Panel $this$actionShortcutComboboxWithEnabledCheckbox, @NlsContexts.Label String labelText, List<ShortcutPreset> presets, String actionId) {
        ShortcutItem.Preset initialPreset;
        ShortcutItem.Preset preset;
        List<Shortcut> curShortcuts = TerminalOptionsConfigurableKt.getActionShortcuts(actionId);
        if (!((Collection)curShortcuts).isEmpty()) {
            Object v0;
            block5: {
                Iterable iterable = presets;
                for (Object t : iterable) {
                    ShortcutPreset it = (ShortcutPreset)t;
                    boolean bl = false;
                    if (!curShortcuts.contains(it.getShortcut())) continue;
                    v0 = t;
                    break block5;
                }
                v0 = null;
            }
            ShortcutPreset shortcutPreset = v0;
            if (shortcutPreset != null) {
                ShortcutPreset it = shortcutPreset;
                boolean bl = false;
                preset = new ShortcutItem.Preset(it);
            } else {
                preset = null;
            }
        } else {
            preset = new ShortcutItem.Preset((ShortcutPreset)CollectionsKt.first(presets));
        }
        ShortcutItem.Preset preset2 = initialPreset = preset;
        ShortcutItem initialComboboxState = preset2 != null ? (ShortcutItem)preset2 : (ShortcutItem)ShortcutItem.Custom.INSTANCE;
        AtomicProperty comboboxProperty = new AtomicProperty((Object)initialComboboxState);
        boolean initialCheckboxState = !((Collection)curShortcuts).isEmpty();
        AtomicBooleanProperty checkboxProperty = new AtomicBooleanProperty(initialCheckboxState);
        $this$actionShortcutComboboxWithEnabledCheckbox.onApply(() -> TerminalOptionsConfigurableKt.actionShortcutComboboxWithEnabledCheckbox$lambda$2(checkboxProperty, comboboxProperty, actionId));
        $this$actionShortcutComboboxWithEnabledCheckbox.onReset(() -> TerminalOptionsConfigurableKt.actionShortcutComboboxWithEnabledCheckbox$lambda$3(checkboxProperty, initialCheckboxState, comboboxProperty, initialComboboxState));
        $this$actionShortcutComboboxWithEnabledCheckbox.onIsModified(() -> TerminalOptionsConfigurableKt.actionShortcutComboboxWithEnabledCheckbox$lambda$4(checkboxProperty, initialCheckboxState, comboboxProperty, initialComboboxState));
        Panel.row$default((Panel)$this$actionShortcutComboboxWithEnabledCheckbox, null, arg_0 -> TerminalOptionsConfigurableKt.actionShortcutComboboxWithEnabledCheckbox$lambda$5(labelText, checkboxProperty, presets, comboboxProperty, actionId, arg_0), (int)1, null);
    }

    private static final Cell<ActionLink> changeActionShortcutLink(Row $this$changeActionShortcutLink, String actionId) {
        String string = TerminalBundle.message("terminal.command.completion.shortcut.change", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return $this$changeActionShortcutLink.link(string, arg_0 -> TerminalOptionsConfigurableKt.changeActionShortcutLink$lambda$0(actionId, arg_0));
    }

    private static final List<Shortcut> getActionShortcuts(String actionId) {
        KeymapManager keymapManager = KeymapManager.getInstance();
        if (keymapManager == null) {
            return CollectionsKt.emptyList();
        }
        KeymapManager keymapManager2 = keymapManager;
        Shortcut[] shortcutArray = keymapManager2.getActiveKeymap().getShortcuts(actionId);
        Intrinsics.checkNotNullExpressionValue((Object)shortcutArray, (String)"getShortcuts(...)");
        return ArraysKt.toList((Object[])shortcutArray);
    }

    private static final void setActionShortcut(String actionId, KeyboardShortcut value) {
        TerminalUtilKt.updateActionShortcut(actionId, value);
        ApplicationRemoteTopicKt.broadcast(TerminalActionShortcutChangedTopicKt.getTERMINAL_ACTION_SHORTCUT_CHANGED_TOPIC(), (Object)new TerminalActionShortcutChangedEvent(actionId, value));
    }

    private static final ShortcutPreset getCtrlSpacePreset(Project project) {
        return new ShortcutPreset(new KeyboardShortcut(KeyStroke.getKeyStroke(32, 128), null), TerminalOptionsConfigurableKt.isMac(project) ? "\u2303 Space" : "Ctrl+Space");
    }

    private static final Unit configurables$lambda$0$0(UnnamedConfigurable $configurable) {
        try {
            $configurable.apply();
        }
        catch (Exception e) {
            LOG.warn("Terminal configurable " + $configurable + " threw an exception on apply", (Throwable)e);
        }
        return Unit.INSTANCE;
    }

    private static final Unit configurables$lambda$0$1(UnnamedConfigurable $configurable) {
        try {
            $configurable.reset();
        }
        catch (Exception e) {
            LOG.warn("Terminal configurable " + $configurable + " threw an exception on reset", (Throwable)e);
        }
        return Unit.INSTANCE;
    }

    private static final boolean configurables$lambda$0$2(UnnamedConfigurable $configurable) {
        return $configurable.isModified();
    }

    private static final Unit configurables$lambda$0(JComponent $component, UnnamedConfigurable $configurable, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell($component).onApply(() -> TerminalOptionsConfigurableKt.configurables$lambda$0$0($configurable)).onReset(() -> TerminalOptionsConfigurableKt.configurables$lambda$0$1($configurable)).onIsModified(() -> TerminalOptionsConfigurableKt.configurables$lambda$0$2($configurable));
        return Unit.INSTANCE;
    }

    private static final Unit setupDefaultValue$lambda$0$0(JTextField $component, String $defaultValue) {
        $component.setForeground(Intrinsics.areEqual((Object)$component.getText(), (Object)$defaultValue) ? TerminalOptionsConfigurableKt.getDefaultValueColor() : TerminalOptionsConfigurableKt.getChangedValueColor());
        return Unit.INSTANCE;
    }

    private static final String setupShellField$lambda$0$0(TerminalProjectOptionsProvider $projectOptionsProvider, AtomicReference $defaultShellPathRef) {
        String string = $projectOptionsProvider.getShellPathWithoutDefault$intellij_terminal();
        if (string == null && (string = (String)$defaultShellPathRef.get()) == null) {
            string = "";
        }
        return string;
    }

    private static final Unit setupShellField$lambda$0$1(TerminalProjectOptionsProvider $projectOptionsProvider, AtomicReference $defaultShellPathRef, String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        $projectOptionsProvider.setShellPathWithoutDefault$intellij_terminal(Strings.nullize((String)value, (String)((String)$defaultShellPathRef.get())));
        return Unit.INSTANCE;
    }

    private static final boolean shellWithIntegrationSelected$lambda$0(String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return TerminalOptionsConfigurableKt.isShellWithIntegration(text);
    }

    private static final ClientSystemInfo getClientSystemInfo$lambda$0() {
        return ClientSystemInfo.Companion.getInstance();
    }

    private static final String actionShortcutCombobox$lambda$1(ShortcutItem item) {
        String string;
        ShortcutItem shortcutItem = item;
        if (shortcutItem instanceof ShortcutItem.Preset) {
            string = ((ShortcutItem.Preset)item).getPreset().getText();
        } else if (shortcutItem instanceof ShortcutItem.Custom) {
            string = TerminalBundle.message("terminal.command.completion.shortcut.custom", new Object[0]);
        } else if (shortcutItem == null) {
            string = "";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private static final ShortcutItem actionShortcutCombobox$lambda$2(String $actionId, List $presets) {
        ShortcutItem shortcutItem;
        Object v0;
        block3: {
            List<Shortcut> currentShortcuts = TerminalOptionsConfigurableKt.getActionShortcuts($actionId);
            Iterable iterable = $presets;
            for (Object t : iterable) {
                ShortcutPreset it = (ShortcutPreset)t;
                boolean bl = false;
                if (!currentShortcuts.contains(it.getShortcut())) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        ShortcutPreset shortcutPreset = v0;
        if (shortcutPreset != null) {
            ShortcutPreset it = shortcutPreset;
            boolean bl = false;
            shortcutItem = new ShortcutItem.Preset(it);
        } else {
            shortcutItem = ShortcutItem.Custom.INSTANCE;
        }
        return shortcutItem;
    }

    private static final Unit actionShortcutCombobox$lambda$3(String $actionId, ShortcutItem item) {
        if (item instanceof ShortcutItem.Preset) {
            TerminalOptionsConfigurableKt.setActionShortcut($actionId, ((ShortcutItem.Preset)item).getPreset().getShortcut());
        }
        return Unit.INSTANCE;
    }

    private static final String actionShortcutComboboxWithEnabledCheckbox$lambda$5$1(ShortcutItem item) {
        String string;
        ShortcutItem shortcutItem = item;
        if (shortcutItem instanceof ShortcutItem.Preset) {
            string = ((ShortcutItem.Preset)item).getPreset().getText();
        } else if (shortcutItem instanceof ShortcutItem.Custom) {
            string = TerminalBundle.message("terminal.command.completion.shortcut.custom", new Object[0]);
        } else if (shortcutItem == null) {
            string = "";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private static final void actionShortcutComboboxWithEnabledCheckbox$updateActionShortcut(String $actionId, boolean checkboxChecked, ShortcutItem shortcutItem) {
        if (checkboxChecked) {
            if (shortcutItem instanceof ShortcutItem.Preset) {
                TerminalOptionsConfigurableKt.setActionShortcut($actionId, ((ShortcutItem.Preset)shortcutItem).getPreset().getShortcut());
            }
        } else {
            TerminalOptionsConfigurableKt.setActionShortcut($actionId, null);
        }
    }

    private static final Unit actionShortcutComboboxWithEnabledCheckbox$lambda$2(AtomicBooleanProperty $checkboxProperty, AtomicProperty $comboboxProperty, String $actionId) {
        TerminalOptionsConfigurableKt.actionShortcutComboboxWithEnabledCheckbox$updateActionShortcut($actionId, $checkboxProperty.get(), (ShortcutItem)$comboboxProperty.get());
        return Unit.INSTANCE;
    }

    private static final Unit actionShortcutComboboxWithEnabledCheckbox$lambda$3(AtomicBooleanProperty $checkboxProperty, boolean $initialCheckboxState, AtomicProperty $comboboxProperty, ShortcutItem $initialComboboxState) {
        $checkboxProperty.set($initialCheckboxState);
        $comboboxProperty.set((Object)$initialComboboxState);
        return Unit.INSTANCE;
    }

    private static final boolean actionShortcutComboboxWithEnabledCheckbox$lambda$4(AtomicBooleanProperty $checkboxProperty, boolean $initialCheckboxState, AtomicProperty $comboboxProperty, ShortcutItem $initialComboboxState) {
        return $checkboxProperty.get() != $initialCheckboxState || !Intrinsics.areEqual((Object)$comboboxProperty.get(), (Object)$initialComboboxState);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit actionShortcutComboboxWithEnabledCheckbox$lambda$5(String $labelText, AtomicBooleanProperty $checkboxProperty, List $presets, AtomicProperty $comboboxProperty, String $actionId, Row $this$row) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JBCheckBox checkbox = (JBCheckBox)ButtonKt.bindSelected((Cell)$this$row.checkBox($labelText).gap(RightGap.SMALL), (ObservableMutableProperty)((ObservableMutableProperty)$checkboxProperty)).getComponent();
        Iterable iterable = $presets;
        Row row = $this$row;
        boolean $i$f$map = false;
        void var10_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ShortcutPreset shortcutPreset = (ShortcutPreset)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ShortcutItem.Preset((ShortcutPreset)it));
        }
        ComboBox combobox = (ComboBox)ComboBoxKt.bindItem((Cell)row.comboBox((Collection)CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)ShortcutItem.Custom.INSTANCE), BuilderKt.textListCellRenderer(TerminalOptionsConfigurableKt::actionShortcutComboboxWithEnabledCheckbox$lambda$5$1)), (ObservableMutableProperty)((ObservableMutableProperty)$comboboxProperty)).enabledIf(ComponentPredicateKt.getSelected((AbstractButton)((AbstractButton)checkbox))).getComponent();
        TerminalOptionsConfigurableKt.changeActionShortcutLink($this$row, $actionId).visibleIf(ComponentPredicateKt.selectedValueIs((JComboBox)((JComboBox)combobox), (Object)ShortcutItem.Custom.INSTANCE));
        return Unit.INSTANCE;
    }

    private static final void changeActionShortcutLink$lambda$0$0(KeymapPanel $keymapPanel, String $actionId) {
        $keymapPanel.selectAction($actionId);
    }

    private static final Unit changeActionShortcutLink$lambda$0(String $actionId, ActionEvent it) {
        KeymapPanel keymapPanel;
        Settings allSettings;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DataManager dataManager = DataManager.getInstance();
        Object object = it.getSource();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.awt.Component");
        DataContext dataContext = dataManager.getDataContext((Component)object);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        Settings settings = allSettings = (Settings)Settings.KEY.getData(dataContext);
        KeymapPanel keymapPanel2 = keymapPanel = settings != null ? (KeymapPanel)settings.find(KeymapPanel.class) : null;
        if (keymapPanel != null) {
            allSettings.select((Configurable)keymapPanel).doWhenDone(() -> TerminalOptionsConfigurableKt.changeActionShortcutLink$lambda$0$0(keymapPanel, $actionId));
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$actionShortcutCombobox(Row $receiver, String labelText, List presets, String actionId) {
        TerminalOptionsConfigurableKt.actionShortcutCombobox($receiver, labelText, presets, actionId);
    }

    public static final /* synthetic */ ShortcutPreset access$getENTER_SHORTCUT_PRESET$p() {
        return ENTER_SHORTCUT_PRESET;
    }

    public static final /* synthetic */ ShortcutPreset access$getTAB_SHORTCUT_PRESET$p() {
        return TAB_SHORTCUT_PRESET;
    }

    public static final /* synthetic */ void access$actionShortcutComboboxWithEnabledCheckbox(Panel $receiver, String labelText, List presets, String actionId) {
        TerminalOptionsConfigurableKt.actionShortcutComboboxWithEnabledCheckbox($receiver, labelText, presets, actionId);
    }

    public static final /* synthetic */ ShortcutPreset access$getCtrlSpacePreset(Project project) {
        return TerminalOptionsConfigurableKt.getCtrlSpacePreset(project);
    }

    public static final /* synthetic */ void access$configurables(Panel $receiver, List configurables) {
        TerminalOptionsConfigurableKt.configurables($receiver, configurables);
    }

    public static final /* synthetic */ Cell access$setupDefaultValue(Cell $receiver, Function1 textComponent, String defaultValue) {
        return TerminalOptionsConfigurableKt.setupDefaultValue($receiver, textComponent, defaultValue);
    }

    public static final /* synthetic */ FontComboBox access$fontComboBox() {
        return TerminalOptionsConfigurableKt.fontComboBox();
    }

    public static final /* synthetic */ Cell access$setupShellField(Cell $receiver, Project project) {
        return TerminalOptionsConfigurableKt.setupShellField((Cell<? extends TextFieldWithHistoryWithBrowseButton>)$receiver, project);
    }

    public static final /* synthetic */ ComponentPredicate access$shellWithIntegrationSelected(TextFieldWithHistoryWithBrowseButton $receiver) {
        return TerminalOptionsConfigurableKt.shellWithIntegrationSelected($receiver);
    }

    public static final /* synthetic */ boolean access$isMac(Project project) {
        return TerminalOptionsConfigurableKt.isMac(project);
    }

    public static final /* synthetic */ boolean access$isWindows(Project project) {
        return TerminalOptionsConfigurableKt.isWindows(project);
    }

    public static final /* synthetic */ ShortcutPreset access$getESCAPE_SHORTCUT_PRESET$p() {
        return ESCAPE_SHORTCUT_PRESET;
    }

    public static final /* synthetic */ ComponentPredicate access$newUiPredicate() {
        return TerminalOptionsConfigurableKt.newUiPredicate();
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TerminalOptionsConfigurable.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        TAB_SHORTCUT_PRESET = new ShortcutPreset(new KeyboardShortcut(KeyStroke.getKeyStroke(9, 0), null), "Tab");
        ENTER_SHORTCUT_PRESET = new ShortcutPreset(new KeyboardShortcut(KeyStroke.getKeyStroke(10, 0), null), "Enter");
        ESCAPE_SHORTCUT_PRESET = new ShortcutPreset(new KeyboardShortcut(KeyStroke.getKeyStroke(27, 0), null), "Escape");
    }
}

