/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.completion.spec.impl;

import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.terminal.completion.spec.ShellCommandExecutor;
import com.intellij.terminal.completion.spec.ShellCommandResult;
import com.intellij.terminal.completion.spec.ShellDataGeneratorProcessBuilder;
import com.intellij.terminal.completion.spec.ShellFileInfo;
import com.intellij.terminal.completion.spec.ShellRuntimeContext;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.completion.TerminalCompletionUtil;
import org.jetbrains.plugins.terminal.block.completion.spec.ShellDataGeneratorProcessExecutor;
import org.jetbrains.plugins.terminal.block.completion.spec.ShellFileSystemSupport;
import org.jetbrains.plugins.terminal.block.completion.spec.impl.ShellDataGeneratorProcessBuilderImpl;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B[\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0004H\u0096@\u00a2\u0006\u0002\u0010!J\u0016\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0004H\u0096@\u00a2\u0006\u0002\u0010!J\u001c\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\b2\u0006\u0010'\u001a\u00020\u0004H\u0096@\u00a2\u0006\u0002\u0010!J\n\u0010(\u001a\u00020\u0004H\u0096\u0080\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0012\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0014R\u0014\u0010\u001c\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0014\u00a8\u0006)"}, d2={"Lorg/jetbrains/plugins/terminal/block/completion/spec/impl/ShellRuntimeContextImpl;", "Lcom/intellij/terminal/completion/spec/ShellRuntimeContext;", "Lcom/intellij/openapi/util/UserDataHolderBase;", "currentDirectory", "", "envVariables", "", "commandTokens", "", "definedShellName", "Lcom/intellij/terminal/completion/spec/ShellName;", "generatorCommandsRunner", "Lcom/intellij/terminal/completion/spec/ShellCommandExecutor;", "generatorProcessExecutor", "Lorg/jetbrains/plugins/terminal/block/completion/spec/ShellDataGeneratorProcessExecutor;", "fileSystemSupport", "Lorg/jetbrains/plugins/terminal/block/completion/spec/ShellFileSystemSupport;", "<init>", "(Ljava/lang/String;Ljava/util/Map;Ljava/util/List;Ljava/lang/String;Lcom/intellij/terminal/completion/spec/ShellCommandExecutor;Lorg/jetbrains/plugins/terminal/block/completion/spec/ShellDataGeneratorProcessExecutor;Lorg/jetbrains/plugins/terminal/block/completion/spec/ShellFileSystemSupport;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getCurrentDirectory", "()Ljava/lang/String;", "getEnvVariables", "()Ljava/util/Map;", "getCommandTokens", "()Ljava/util/List;", "Ljava/lang/String;", "typedPrefix", "getTypedPrefix", "shellName", "getShellName-_aRN8GM", "runShellCommand", "Lcom/intellij/terminal/completion/spec/ShellCommandResult;", "command", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createProcessBuilder", "Lcom/intellij/terminal/completion/spec/ShellDataGeneratorProcessBuilder;", "executable", "listDirectoryFiles", "Lcom/intellij/terminal/completion/spec/ShellFileInfo;", "path", "toString", "intellij.terminal"})
@ApiStatus.Internal
public final class ShellRuntimeContextImpl
extends UserDataHolderBase
implements ShellRuntimeContext {
    @NotNull
    private final String currentDirectory;
    @NotNull
    private final Map<String, String> envVariables;
    @NotNull
    private final List<String> commandTokens;
    @Nullable
    private final String definedShellName;
    @NotNull
    private final ShellCommandExecutor generatorCommandsRunner;
    @Nullable
    private final ShellDataGeneratorProcessExecutor generatorProcessExecutor;
    @Nullable
    private final ShellFileSystemSupport fileSystemSupport;
    @NotNull
    private final String typedPrefix;

    private ShellRuntimeContextImpl(String currentDirectory, Map<String, String> envVariables, List<String> commandTokens, String definedShellName, ShellCommandExecutor generatorCommandsRunner, ShellDataGeneratorProcessExecutor generatorProcessExecutor, ShellFileSystemSupport fileSystemSupport) {
        Intrinsics.checkNotNullParameter((Object)currentDirectory, (String)"currentDirectory");
        Intrinsics.checkNotNullParameter(envVariables, (String)"envVariables");
        Intrinsics.checkNotNullParameter(commandTokens, (String)"commandTokens");
        Intrinsics.checkNotNullParameter((Object)generatorCommandsRunner, (String)"generatorCommandsRunner");
        this.currentDirectory = currentDirectory;
        this.envVariables = envVariables;
        this.commandTokens = commandTokens;
        this.definedShellName = definedShellName;
        this.generatorCommandsRunner = generatorCommandsRunner;
        this.generatorProcessExecutor = generatorProcessExecutor;
        this.fileSystemSupport = fileSystemSupport;
        this.typedPrefix = TerminalCompletionUtil.INSTANCE.getTypedPrefix(this.getCommandTokens());
    }

    public /* synthetic */ ShellRuntimeContextImpl(String string, Map map2, List list, String string2, ShellCommandExecutor shellCommandExecutor, ShellDataGeneratorProcessExecutor shellDataGeneratorProcessExecutor, ShellFileSystemSupport shellFileSystemSupport, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            shellDataGeneratorProcessExecutor = null;
        }
        if ((n & 0x40) != 0) {
            shellFileSystemSupport = null;
        }
        this(string, map2, list, string2, shellCommandExecutor, shellDataGeneratorProcessExecutor, shellFileSystemSupport, null);
    }

    @Override
    @NotNull
    public String getCurrentDirectory() {
        return this.currentDirectory;
    }

    @Override
    @NotNull
    public Map<String, String> getEnvVariables() {
        return this.envVariables;
    }

    @Override
    @NotNull
    public List<String> getCommandTokens() {
        return this.commandTokens;
    }

    @Override
    @NotNull
    public String getTypedPrefix() {
        return this.typedPrefix;
    }

    @Override
    @NotNull
    public String getShellName-_aRN8GM() {
        String string = this.definedShellName;
        if (string == null) {
            throw new UnsupportedOperationException("Not supported in Reworked Terminal");
        }
        return string;
    }

    @Override
    @Nullable
    public Object runShellCommand(@NotNull String command2, @NotNull Continuation<? super ShellCommandResult> $completion) {
        return this.generatorCommandsRunner.runShellCommand(this.getCurrentDirectory(), command2, $completion);
    }

    @Override
    @Nullable
    public Object createProcessBuilder(@NotNull String executable, @NotNull Continuation<? super ShellDataGeneratorProcessBuilder> $completion) {
        if (this.generatorProcessExecutor == null) {
            TerminalCompletionUtil.INSTANCE.throwUnsupportedInExpTerminalException();
            throw new KotlinNothingValueException();
        }
        return new ShellDataGeneratorProcessBuilderImpl(executable, this.getCurrentDirectory(), this.generatorProcessExecutor);
    }

    @Override
    @Nullable
    public Object listDirectoryFiles(@NotNull String path, @NotNull Continuation<? super List<? extends ShellFileInfo>> $completion) {
        if (this.fileSystemSupport != null) {
            return this.fileSystemSupport.listDirectoryFiles(path, $completion);
        }
        TerminalCompletionUtil.INSTANCE.throwUnsupportedInExpTerminalException();
        throw new KotlinNothingValueException();
    }

    @NotNull
    public String toString() {
        return "ShellRuntimeContextImpl(currentDirectory='" + this.getCurrentDirectory() + "', typedPrefix='" + this.getTypedPrefix() + "')";
    }

    public /* synthetic */ ShellRuntimeContextImpl(String currentDirectory, Map envVariables, List commandTokens, String definedShellName, ShellCommandExecutor generatorCommandsRunner, ShellDataGeneratorProcessExecutor generatorProcessExecutor, ShellFileSystemSupport fileSystemSupport, DefaultConstructorMarker $constructor_marker) {
        this(currentDirectory, envVariables, commandTokens, definedShellName, generatorCommandsRunner, generatorProcessExecutor, fileSystemSupport);
    }
}

