/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.feedback;

import com.intellij.openapi.project.Project;
import com.intellij.platform.feedback.dialog.BaseFeedbackSystemInfoDialogKt;
import com.intellij.platform.feedback.dialog.BlockBasedFeedbackDialog;
import com.intellij.platform.feedback.dialog.CommonFeedbackSystemData;
import com.intellij.platform.feedback.dialog.uiBlocks.CheckBoxGroupBlock;
import com.intellij.platform.feedback.dialog.uiBlocks.CheckBoxItemData;
import com.intellij.platform.feedback.dialog.uiBlocks.DescriptionBlock;
import com.intellij.platform.feedback.dialog.uiBlocks.FeedbackBlock;
import com.intellij.platform.feedback.dialog.uiBlocks.RatingBlock;
import com.intellij.platform.feedback.dialog.uiBlocks.TextAreaBlock;
import com.intellij.platform.feedback.dialog.uiBlocks.TopLabelBlock;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalBundle;
import org.jetbrains.plugins.terminal.TerminalProjectOptionsProvider;
import org.jetbrains.plugins.terminal.block.feedback.ReworkedTerminalUsageData;
import org.jetbrains.plugins.terminal.block.feedback.TerminalFeedbackUtils;
import org.jetbrains.plugins.terminal.fus.TerminalShellInfoStatistics;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000f\u001a\u00020\u0002H\u0094@\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0014J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/terminal/block/feedback/ReworkedTerminalFeedbackDialog;", "Lcom/intellij/platform/feedback/dialog/BlockBasedFeedbackDialog;", "Lorg/jetbrains/plugins/terminal/block/feedback/ReworkedTerminalUsageData;", "project", "Lcom/intellij/openapi/project/Project;", "forTest", "", "<init>", "(Lcom/intellij/openapi/project/Project;Z)V", "myFeedbackReportId", "", "getMyFeedbackReportId", "()Ljava/lang/String;", "myTitle", "getMyTitle", "computeSystemInfoData", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "showFeedbackSystemInfoDialog", "", "systemInfoData", "myBlocks", "", "Lcom/intellij/platform/feedback/dialog/uiBlocks/FeedbackBlock;", "getMyBlocks", "()Ljava/util/List;", "improvementItems", "Lcom/intellij/platform/feedback/dialog/uiBlocks/CheckBoxItemData;", "intellij.terminal"})
public final class ReworkedTerminalFeedbackDialog
extends BlockBasedFeedbackDialog<ReworkedTerminalUsageData> {
    @NotNull
    private final Project project;
    @NotNull
    private final String myFeedbackReportId;
    @NotNull
    private final String myTitle;
    @NotNull
    private final List<FeedbackBlock> myBlocks;

    public ReworkedTerminalFeedbackDialog(@NotNull Project project, boolean forTest) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, forTest);
        this.project = project;
        this.myFeedbackReportId = "reworked_terminal";
        String string = TerminalBundle.message("feedback.dialog.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.myTitle = string;
        Object[] objectArray = new FeedbackBlock[6];
        String string2 = TerminalBundle.message("feedback.dialog.header", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        objectArray[0] = new TopLabelBlock(string2);
        String string3 = TerminalBundle.message("feedback.dialog.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        objectArray[1] = new DescriptionBlock(string3);
        String string4 = TerminalBundle.message("feedback.dialog.rating.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        objectArray[2] = new RatingBlock(string4, "overall_rating");
        String string5 = TerminalBundle.message("feedback.dialog.issues", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        objectArray[3] = new TextAreaBlock(string5, "issues");
        String string6 = TerminalBundle.message("feedback.dialog.improvement", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
        objectArray[4] = CheckBoxGroupBlock.addOtherTextField$default((CheckBoxGroupBlock)new CheckBoxGroupBlock(string6, CollectionsKt.shuffled((Iterable)this.improvementItems()), "important_improvement"), null, (int)1, null);
        String string7 = TerminalBundle.message("feedback.dialog.other", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"message(...)");
        TextAreaBlock textAreaBlock = new TextAreaBlock(string7, "extra");
        String string8 = TerminalBundle.message("feedback.dialog.other.placeholder", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"message(...)");
        objectArray[5] = textAreaBlock.setPlaceholder(string8);
        this.myBlocks = CollectionsKt.listOf((Object[])objectArray);
        this.init();
    }

    @NotNull
    protected String getMyFeedbackReportId() {
        return this.myFeedbackReportId;
    }

    @NotNull
    protected String getMyTitle() {
        return this.myTitle;
    }

    @Nullable
    protected Object computeSystemInfoData(@NotNull Continuation<? super ReworkedTerminalUsageData> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ReworkedTerminalUsageData>, Object>(this, null){
            int label;
            final /* synthetic */ ReworkedTerminalFeedbackDialog this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        return new ReworkedTerminalUsageData(TerminalShellInfoStatistics.INSTANCE.getShellNameForStat(TerminalProjectOptionsProvider.Companion.getInstance(ReworkedTerminalFeedbackDialog.access$getProject$p(this.this$0)).getShellPath()), TerminalFeedbackUtils.INSTANCE.getFeedbackMoment(ReworkedTerminalFeedbackDialog.access$getProject$p(this.this$0)), CommonFeedbackSystemData.Companion.getCurrentData());
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super ReworkedTerminalUsageData> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    protected void showFeedbackSystemInfoDialog(@NotNull ReworkedTerminalUsageData systemInfoData) {
        Intrinsics.checkNotNullParameter((Object)systemInfoData, (String)"systemInfoData");
        BaseFeedbackSystemInfoDialogKt.showFeedbackSystemInfoDialog((Project)this.getMyProject(), (CommonFeedbackSystemData)systemInfoData.getSystemInfo(), arg_0 -> ReworkedTerminalFeedbackDialog.showFeedbackSystemInfoDialog$lambda$0(systemInfoData, arg_0));
    }

    @NotNull
    protected List<FeedbackBlock> getMyBlocks() {
        return this.myBlocks;
    }

    private final List<CheckBoxItemData> improvementItems() {
        Object[] objectArray = new CheckBoxItemData[5];
        String string = TerminalBundle.message("feedback.dialog.improvement.compatibility", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        objectArray[0] = new CheckBoxItemData(string, "app_compatibility");
        String string2 = TerminalBundle.message("feedback.dialog.improvement.performance", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        objectArray[1] = new CheckBoxItemData(string2, "performance");
        String string3 = TerminalBundle.message("feedback.dialog.improvement.shell.support", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        objectArray[2] = new CheckBoxItemData(string3, "shell_support");
        String string4 = TerminalBundle.message("feedback.dialog.improvement.ai.integration", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        objectArray[3] = new CheckBoxItemData(string4, "ai_integration");
        String string5 = TerminalBundle.message("feedback.dialog.improvement.ide.integration", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        objectArray[4] = new CheckBoxItemData(string5, "ide_integration");
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final Unit showFeedbackSystemInfoDialog$lambda$0$0(ReworkedTerminalUsageData $systemInfoData, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label($systemInfoData.getSelectedShell());
        return Unit.INSTANCE;
    }

    private static final Unit showFeedbackSystemInfoDialog$lambda$0$1(ReworkedTerminalUsageData $systemInfoData, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label($systemInfoData.getFeedbackMoment().toString());
        return Unit.INSTANCE;
    }

    private static final Unit showFeedbackSystemInfoDialog$lambda$0(ReworkedTerminalUsageData $systemInfoData, Panel $this$showFeedbackSystemInfoDialog) {
        Intrinsics.checkNotNullParameter((Object)$this$showFeedbackSystemInfoDialog, (String)"$this$showFeedbackSystemInfoDialog");
        String string = TerminalBundle.message("feedback.system.info.shell", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$showFeedbackSystemInfoDialog.row(string, arg_0 -> ReworkedTerminalFeedbackDialog.showFeedbackSystemInfoDialog$lambda$0$0($systemInfoData, arg_0));
        String string2 = TerminalBundle.message("feedback.system.info.moment", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$showFeedbackSystemInfoDialog.row(string2, arg_0 -> ReworkedTerminalFeedbackDialog.showFeedbackSystemInfoDialog$lambda$0$1($systemInfoData, arg_0));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Project access$getProject$p(ReworkedTerminalFeedbackDialog $this) {
        return $this.project;
    }
}

