/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.inline;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.DocumentUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0019"}, d2={"Lcom/intellij/xdebugger/impl/inline/InlineWatch;", "", "expression", "Lcom/intellij/xdebugger/XExpression;", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "<init>", "(Lcom/intellij/xdebugger/XExpression;Lcom/intellij/xdebugger/XSourcePosition;)V", "getExpression", "()Lcom/intellij/xdebugger/XExpression;", "myFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/annotations/NotNull;", "myRangeMarker", "Lcom/intellij/openapi/editor/RangeMarker;", "value", "getPosition", "()Lcom/intellij/xdebugger/XSourcePosition;", "line", "", "getLine", "()I", "updatePosition", "", "setMarker", "intellij.platform.debugger.impl.shared"})
public final class InlineWatch {
    @NotNull
    private final XExpression expression;
    @NotNull
    private final VirtualFile myFile;
    @Nullable
    private volatile RangeMarker myRangeMarker;
    @NotNull
    private XSourcePosition position;

    public InlineWatch(@NotNull XExpression expression, @NotNull XSourcePosition position) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this.expression = expression;
        VirtualFile virtualFile = position.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        this.myFile = virtualFile;
        this.position = position;
    }

    @NotNull
    public final XExpression getExpression() {
        return this.expression;
    }

    @NotNull
    public final XSourcePosition getPosition() {
        return this.position;
    }

    public final int getLine() {
        return this.position.getLine();
    }

    public final boolean updatePosition() {
        RangeMarker rangeMarker = this.myRangeMarker;
        if (rangeMarker == null) {
            return true;
        }
        if (!rangeMarker.isValid()) {
            return false;
        }
        int line = rangeMarker.getDocument().getLineNumber(rangeMarker.getStartOffset());
        if (line != this.position.getLine()) {
            XSourcePosition xSourcePosition = XDebuggerUtil.getInstance().createPosition(this.myFile, line);
            Intrinsics.checkNotNull((Object)xSourcePosition);
            this.position = xSourcePosition;
        }
        return true;
    }

    public final boolean setMarker() {
        int line;
        ThreadingAssertions.assertReadAccess();
        if (this.myRangeMarker != null) {
            return true;
        }
        Document document = FileDocumentManager.getInstance().getCachedDocument(this.myFile);
        if (document == null) {
            if (this.myFile.getFileType().isBinary()) {
                return true;
            }
            document = FileDocumentManager.getInstance().getDocument(this.myFile);
        }
        if (this.myRangeMarker != null) {
            return true;
        }
        if (document != null && DocumentUtil.isValidLine((int)(line = this.position.getLine()), (Document)document)) {
            int offset = document.getLineEndOffset(line);
            this.myRangeMarker = document.createRangeMarker(offset, offset, true);
            return true;
        }
        return false;
    }
}

