/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Ntifs;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.WinioctlUtil;
import com.sun.jna.ptr.IntByReference;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\u001a \u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u001a\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000f\u001a\u00020\u0004H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\b\u001a\u0004\u0018\u00010\u0001*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\"\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"storeMarker", "", "getAppxFiles", "", "Ljava/nio/file/Path;", "expectedProduct", "filePattern", "Lkotlin/text/Regex;", "appxProduct", "getAppxProduct", "(Ljava/nio/file/Path;)Ljava/lang/String;", "userAppxFolder", "IO_REPARSE_TAG_APPEXECLINK", "", "getAppxTag", "path", "intellij.python.sdk"})
@SourceDebugExtension(value={"SMAP\nWinAppxTools.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WinAppxTools.kt\ncom/jetbrains/python/sdk/WinAppxToolsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,159:1\n777#2:160\n873#2,2:161\n1068#2:163\n1642#2,10:164\n1915#2:174\n1916#2:177\n1652#2:178\n1#3:175\n1#3:176\n491#4,7:179\n*S KotlinDebug\n*F\n+ 1 WinAppxTools.kt\ncom/jetbrains/python/sdk/WinAppxToolsKt\n*L\n58#1:160\n58#1:161,2\n59#1:163\n60#1:164,10\n60#1:174\n60#1:177\n60#1:178\n60#1:176\n62#1:179,7\n*E\n"})
public final class WinAppxToolsKt {
    @NotNull
    private static final String storeMarker = "DesktopAppInstaller";
    @Nullable
    private static final Path userAppxFolder;
    private static final long IO_REPARSE_TAG_APPEXECLINK = 2147483675L;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @ApiStatus.Internal
    @NotNull
    public static final Collection<Path> getAppxFiles(@Nullable String expectedProduct, @NotNull Regex filePattern) {
        Collection collection;
        List list;
        Intrinsics.checkNotNullParameter((Object)filePattern, (String)"filePattern");
        Path path = userAppxFolder;
        if (path != null && (list = PathsKt.listDirectoryEntries$default((Path)path, null, (int)1, null)) != null) {
            void $this$sortedBy$iv;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable iterable = list;
            boolean $i$f$filter22 = false;
            void var6_7 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Path it = (Path)element$iv$iv;
                boolean bl = false;
                if (!filePattern.matches((CharSequence)PathsKt.getName((Path)it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $i$f$filter22 = (List)destination$iv$iv;
            boolean $i$f$sortedBy2 = false;
            iterable = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Path it = (Path)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)PathsKt.getNameWithoutExtension((Path)it));
                    it = (Path)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)PathsKt.getNameWithoutExtension((Path)it))));
                }
            });
            if (iterable != null) {
                Map $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Iterable $i$f$sortedBy2 = iterable;
                boolean $i$f$mapNotNull = false;
                void $i$f$filterTo2 = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Pair pair;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    Path file = (Path)element$iv$iv;
                    boolean bl2 = false;
                    if (WinAppxToolsKt.getAppxProduct(file) != null) {
                        String product;
                        boolean bl3 = false;
                        pair = new Pair((Object)product, (Object)file);
                    } else {
                        pair = null;
                    }
                    if (pair == null) continue;
                    Pair it$iv$iv = pair;
                    boolean bl4 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                Map map = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
                if (map != null) {
                    void $this$filterKeys$iv;
                    $this$mapNotNullTo$iv$iv = map;
                    boolean $i$f$filterKeys = false;
                    LinkedHashMap result$iv = new LinkedHashMap();
                    for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
                        String it = (String)entry$iv.getKey();
                        boolean bl = false;
                        if (!(expectedProduct == null || StringsKt.contains$default((CharSequence)it, (CharSequence)expectedProduct, (boolean)false, (int)2, null))) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    Collection collection2 = ((Map)result$iv).values();
                    if (collection2 != null) {
                        collection = collection2;
                        return collection;
                    }
                }
            }
        }
        collection = CollectionsKt.emptyList();
        return collection;
    }

    @Nullable
    public static final String getAppxProduct(@NotNull Path $this$appxProduct) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$appxProduct, (String)"<this>");
        Path path = userAppxFolder;
        if (path == null) {
            return null;
        }
        Path userAppxFolder = path;
        if (!$this$appxProduct.startsWith(userAppxFolder)) {
            return null;
        }
        String string2 = WinAppxToolsKt.getAppxTag($this$appxProduct);
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            string = !StringsKt.contains$default((CharSequence)it, (CharSequence)storeMarker, (boolean)false, (int)2, null) ? it : null;
        } else {
            string = null;
        }
        return string;
    }

    private static final String getAppxTag(Path path) {
        if (!SystemInfo.isWin10OrNewer) {
            return null;
        }
        Kernel32 kernel = Kernel32.INSTANCE;
        Logger logger = Logger.getInstance(Kernel32.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Logger logger2 = logger;
        WinNT.HANDLE file = kernel.CreateFile(((Object)path).toString(), Integer.MIN_VALUE, 1, null, 3, 0x200000, null);
        if (Intrinsics.areEqual((Object)file, (Object)Kernel32.INVALID_HANDLE_VALUE)) {
            logger2.warn("Invalid handle for " + path);
            return null;
        }
        Ntifs.REPARSE_DATA_BUFFER buffer = new Ntifs.REPARSE_DATA_BUFFER();
        IntByReference bytesRead = new IntByReference();
        if (!kernel.DeviceIoControl(file, WinioctlUtil.FSCTL_GET_REPARSE_POINT, null, 0, buffer.getPointer(), buffer.size(), bytesRead, null)) {
            logger2.warn("DeviceIoControl error " + kernel.GetLastError());
            return null;
        }
        if (bytesRead.getValue() < 1) {
            logger2.warn("0 bytes read");
            return null;
        }
        buffer.read();
        if (buffer.ReparseTag != -2147483621) {
            logger2.warn("Wrong tag " + buffer.ReparseTag);
            return null;
        }
        CharBuffer charBuffer = Charsets.UTF_16LE.decode(ByteBuffer.wrap(buffer.u.genericReparseBuffer.DataBuffer));
        int from = 0;
        int to = 0;
        boolean startFound = false;
        Intrinsics.checkNotNull((Object)charBuffer);
        CharBuffer charBuffer2 = charBuffer;
        for (int i = 0; i < ((CharSequence)charBuffer2).length(); ++i) {
            boolean validChar;
            int i2 = i;
            char c = ((CharSequence)charBuffer2).charAt(i);
            boolean bl = validChar = Character.getType(c) != 15;
            if (validChar && !startFound) {
                from = i2;
                startFound = true;
            }
            if (validChar || !startFound) continue;
            to = i2;
            break;
        }
        return ((Object)((CharSequence)charBuffer).subSequence(from, to)).toString();
    }

    static {
        Path path;
        if (!SystemInfo.isWin10OrNewer) {
            path = null;
        } else {
            String string = System.getenv("LOCALAPPDATA");
            if (string != null) {
                String localappdata = string;
                boolean bl = false;
                String[] stringArray = new String[]{"Microsoft//WindowsApps"};
                Path appsPath = Path.of(localappdata, stringArray);
                Intrinsics.checkNotNull((Object)appsPath);
                LinkOption[] linkOptionArray = new LinkOption[]{};
                path = Files.exists(appsPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? appsPath : null;
            } else {
                path = null;
            }
        }
        userAppxFolder = path;
    }
}

