/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView;

import com.intellij.ide.projectView.NodeSortOrder;
import com.intellij.ide.projectView.NodeSortSettings;
import com.intellij.ide.projectView.RootsProvider;
import com.intellij.ide.projectView.SettingsProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.TreeNodeWithCacheableAttributes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.presentation.FilePresentationService;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import java.awt.Color;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class ProjectViewNode<Value>
extends AbstractTreeNode<Value>
implements RootsProvider,
SettingsProvider,
TreeNodeWithCacheableAttributes {
    protected static final Logger LOG = Logger.getInstance(ProjectViewNode.class);
    @ApiStatus.Internal
    public static final String CACHED_FILE_PATH_KEY = "filePath";
    @ApiStatus.Internal
    public static final String GENERIC_PROJECT_VIEW_NODE_TYPE = "GenericProjectViewNode";
    private final ViewSettings mySettings;
    private boolean myValidating;

    protected ProjectViewNode(Project project, @NotNull Value value, ViewSettings viewSettings) {
        if (value == null) {
            ProjectViewNode.$$$reportNull$$$0(0);
        }
        super(project, value);
        this.mySettings = viewSettings;
    }

    public abstract boolean contains(@NotNull VirtualFile var1);

    @Nullable
    public VirtualFile getVirtualFile() {
        return null;
    }

    @ApiStatus.Internal
    public @Nullable Map<@NotNull String, @NotNull String> getCacheableAttributes() {
        String path = this.getCacheableFilePath();
        if (path == null) {
            return null;
        }
        return Map.of(CACHED_FILE_PATH_KEY, path);
    }

    @ApiStatus.Internal
    @Nullable
    protected String getCacheableFilePath() {
        String path;
        @Nullable VirtualFile file = this.getCacheableFile();
        if (file == null) {
            return null;
        }
        String string = path = file.isInLocalFileSystem() ? file.getPath() : null;
        if (path == null) {
            return null;
        }
        return path;
    }

    @ApiStatus.Internal
    @Nullable
    protected VirtualFile getCacheableFile() {
        return this.getVirtualFile();
    }

    public final ViewSettings getSettings() {
        return this.mySettings;
    }

    public static List<AbstractTreeNode<?>> wrap(Collection<?> objects, Project project, Class<? extends AbstractTreeNode<?>> nodeClass, ViewSettings settings) {
        try {
            ArrayList result = new ArrayList();
            for (Object object : objects) {
                result.add(ProjectViewNode.createTreeNode(nodeClass, project, object, settings));
            }
            return result;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return new ArrayList();
        }
    }

    @NotNull
    public static AbstractTreeNode<?> createTreeNode(Class<? extends AbstractTreeNode<?>> nodeClass, Project project, Object value, ViewSettings settings) throws InstantiationException {
        Object[] parameters = new Object[]{project, value, settings};
        for (Constructor<?> constructor : nodeClass.getConstructors()) {
            AbstractTreeNode abstractTreeNode;
            if (constructor.getParameterCount() != 3) continue;
            try {
                abstractTreeNode = (AbstractTreeNode)constructor.newInstance(parameters);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException exception) {
                // empty catch block
            }
            if (abstractTreeNode == null) {
                ProjectViewNode.$$$reportNull$$$0(1);
            }
            return abstractTreeNode;
        }
        throw new InstantiationException("no constructor found in " + String.valueOf(nodeClass));
    }

    public boolean someChildContainsFile(VirtualFile file) {
        return this.someChildContainsFile(file, true);
    }

    public boolean someChildContainsFile(VirtualFile file, boolean optimizeByCheckingFileRootsFirst) {
        VirtualFile parent = file.getParent();
        boolean mayContain = false;
        if (optimizeByCheckingFileRootsFirst && parent != null) {
            Collection<VirtualFile> roots = this.getRoots();
            for (VirtualFile eachRoot : roots) {
                if (parent.equals(eachRoot.getParent())) {
                    mayContain = true;
                } else {
                    if (!VfsUtilCore.isAncestor((VirtualFile)eachRoot, (VirtualFile)file, (boolean)true)) continue;
                    mayContain = true;
                }
                break;
            }
        } else {
            mayContain = true;
        }
        if (!mayContain) {
            return false;
        }
        Collection kids = this.getChildren();
        for (AbstractTreeNode kid : kids) {
            ProjectViewNode node = (ProjectViewNode)kid;
            if (!node.contains(file)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public @Unmodifiable Collection<VirtualFile> getRoots() {
        Object value = this.getValue();
        if (value instanceof RootsProvider) {
            Collection collection = ((RootsProvider)value).getRoots();
            if (collection == null) {
                ProjectViewNode.$$$reportNull$$$0(2);
            }
            return collection;
        }
        if (value instanceof VirtualFile) {
            Set<VirtualFile> set = Collections.singleton((VirtualFile)value);
            if (set == null) {
                ProjectViewNode.$$$reportNull$$$0(3);
            }
            return set;
        }
        if (value instanceof PsiFileSystemItem) {
            PsiFileSystemItem item = (PsiFileSystemItem)value;
            Collection<VirtualFile> collection = ProjectViewNode.getDefaultRootsFor(item.getVirtualFile());
            if (collection == null) {
                ProjectViewNode.$$$reportNull$$$0(4);
            }
            return collection;
        }
        Set<VirtualFile> set = Collections.emptySet();
        if (set == null) {
            ProjectViewNode.$$$reportNull$$$0(5);
        }
        return set;
    }

    protected static @Unmodifiable Collection<VirtualFile> getDefaultRootsFor(@Nullable VirtualFile file) {
        return file != null ? Collections.singleton(file) : Collections.emptySet();
    }

    protected boolean hasProblemFileBeneath() {
        if (!Registry.is((String)"projectView.showHierarchyErrors")) {
            return false;
        }
        Project project = this.getProject();
        WolfTheProblemSolver wolf = project == null ? null : WolfTheProblemSolver.getInstance((Project)project);
        return wolf != null && wolf.hasProblemFilesBeneath(virtualFile -> {
            Object value;
            return this.contains((VirtualFile)virtualFile) && ((value = this.getValue()) instanceof PsiElement && Comparing.equal((Object)PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)value)), (Object)virtualFile) || this.someChildContainsFile((VirtualFile)virtualFile));
        });
    }

    public boolean canHaveChildrenMatching(Condition<? super PsiFile> condition) {
        return true;
    }

    @NlsContexts.PopupTitle
    @Nullable
    public String getTitle() {
        return null;
    }

    public boolean isSortByFirstChild() {
        return false;
    }

    @NotNull
    public NodeSortOrder getSortOrder(@NotNull NodeSortSettings settings) {
        if (settings == null) {
            ProjectViewNode.$$$reportNull$$$0(6);
        }
        NodeSortOrder nodeSortOrder = settings.isManualOrder() ? NodeSortOrder.MANUAL : NodeSortOrder.UNSPECIFIED;
        if (nodeSortOrder == null) {
            ProjectViewNode.$$$reportNull$$$0(7);
        }
        return nodeSortOrder;
    }

    public int getTypeSortWeight(boolean sortByType) {
        return 0;
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return null;
    }

    @Nullable
    public Comparable getSortKey() {
        return null;
    }

    @Nullable
    public Comparable getManualOrderKey() {
        return null;
    }

    @Nullable
    public String getQualifiedNameSortKey() {
        return null;
    }

    @Nullable
    public Comparable<?> getTimeSortKey() {
        return null;
    }

    public boolean shouldDrillDownOnEmptyElement() {
        return false;
    }

    public boolean validate() {
        this.setValidating(true);
        try {
            this.update();
        }
        finally {
            this.setValidating(false);
        }
        return this.getValue() != null;
    }

    protected boolean shouldPostprocess() {
        return !this.isValidating();
    }

    protected boolean shouldApply() {
        return !this.isValidating();
    }

    private void setValidating(boolean validating) {
        this.myValidating = validating;
    }

    public boolean isValidating() {
        return this.myValidating;
    }

    @Nullable
    protected Color computeBackgroundColor() {
        Color elementBackgroundColor = super.computeBackgroundColor();
        if (elementBackgroundColor != null) {
            return elementBackgroundColor;
        }
        return FilePresentationService.getFileBackgroundColor((Project)this.getProject(), (VirtualFile)this.getVirtualFile());
    }

    @ApiStatus.Internal
    public static boolean shouldUseSimplifiedProjectTreeState() {
        return Registry.is((String)"projectView.use.simplified.state", (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/ProjectViewNode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/ProjectViewNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createTreeNode";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortOrder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSortOrder";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 7 -> new IllegalStateException(string);
        };
    }
}

