/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.gist.storage;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.DataExternalizer;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class GistStorage {
    @NotNull
    public static GistStorage getInstance() {
        GistStorage gistStorage = (GistStorage)ApplicationManager.getApplication().getService(GistStorage.class);
        if (gistStorage == null) {
            GistStorage.$$$reportNull$$$0(0);
        }
        return gistStorage;
    }

    @NotNull
    public abstract <Data> Gist<Data> newGist(@NotNull @NonNls String var1, int var2, @NotNull DataExternalizer<Data> var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/gist/storage/GistStorage", "getInstance"));
    }

    public static final class GistData<Data> {
        public static final int NULL_STAMP = -1;
        @Nullable
        private final Data data;
        private final int stamp;
        private final boolean hasData;

        private GistData(@Nullable Data data, int stamp, boolean hasData) {
            this.data = data;
            this.stamp = stamp;
            this.hasData = hasData;
        }

        @Nullable
        public Data data() {
            return this.data;
        }

        public int gistStamp() {
            return this.stamp;
        }

        public boolean hasData() {
            return this.hasData;
        }

        public boolean isOutdated() {
            return !this.hasData && this.stamp != -1;
        }

        @Nullable
        public Data dataIfExists() throws NoSuchElementException {
            if (!this.hasData) {
                throw new NoSuchElementException("Data doesn't exist");
            }
            return this.data;
        }

        @Nullable
        public Data dataOr(@Nullable Data defaultValueIfNotExists) {
            if (!this.hasData) {
                return defaultValueIfNotExists;
            }
            return this.data;
        }

        public String toString() {
            if (!this.hasData) {
                if (this.stamp == -1) {
                    return "GistData[<none>]";
                }
                return "GistData[<outdated>, stamp: " + this.stamp + "]";
            }
            return "GistData[data: " + String.valueOf(this.data) + ", stamp: " + this.stamp + "]";
        }

        public static <Data> GistData<Data> empty() {
            return new GistData<Object>(null, -1, false);
        }

        public static <Data> GistData<Data> outdated(int gistStamp) {
            if (gistStamp == -1) {
                throw new IllegalArgumentException("gistStamp(=" + gistStamp + ") must be valid (!=-1)");
            }
            return new GistData<Object>(null, gistStamp, false);
        }

        public static <Data> GistData<Data> valid(@Nullable Data gistData, int gistStamp) {
            if (gistStamp == -1) {
                throw new IllegalArgumentException("gistStamp(=" + gistStamp + ") must be valid (!=-1)");
            }
            return new GistData<Data>(gistData, gistStamp, true);
        }
    }

    public static interface Gist<Data> {
        @NotNull
        public String id();

        public int version();

        @NotNull
        public GistData<Data> getProjectData(@Nullable Project var1, @NotNull VirtualFile var2, int var3) throws IOException;

        @NotNull
        default public GistData<Data> getGlobalData(@NotNull VirtualFile file, int expectedGistStamp) throws IOException {
            if (file == null) {
                Gist.$$$reportNull$$$0(0);
            }
            GistData<Data> gistData = this.getProjectData(null, file, expectedGistStamp);
            if (gistData == null) {
                Gist.$$$reportNull$$$0(1);
            }
            return gistData;
        }

        public void putProjectData(@Nullable Project var1, @NotNull VirtualFile var2, @Nullable Data var3, int var4) throws IOException;

        default public void putGlobalData(@NotNull VirtualFile file, @Nullable Data data, int gistStamp) throws IOException {
            if (file == null) {
                Gist.$$$reportNull$$$0(2);
            }
            this.putProjectData(null, file, data, gistStamp);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/gist/storage/GistStorage$Gist";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/gist/storage/GistStorage$Gist";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGlobalData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getGlobalData";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "putGlobalData";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

