/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip;

import com.intellij.execution.ExecutionResult;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.JavaScriptDebuggerViewSupport;
import com.intellij.javascript.debugger.JavaScriptLineBreakpointManager;
import com.intellij.javascript.debugger.actions.ReloadInBrowserAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.debugger.wip.BrowserChromeDebugProcessKt;
import com.jetbrains.debugger.wip.BrowserJavaScriptDebuggerViewSupport;
import com.jetbrains.debugger.wip.ChromeDebugProcess;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.wip.WipVm;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0014J \u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0018H\u0016\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/debugger/wip/BrowserChromeDebugProcess;", "Lcom/jetbrains/debugger/wip/ChromeDebugProcess;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "finder", "Lcom/intellij/javascript/debugger/DebuggableFileFinder;", "connection", "Lorg/jetbrains/debugger/connection/VmConnection;", "Lorg/jetbrains/wip/WipVm;", "executionResult", "Lcom/intellij/execution/ExecutionResult;", "<init>", "(Lcom/intellij/xdebugger/XDebugSession;Lcom/intellij/javascript/debugger/DebuggableFileFinder;Lorg/jetbrains/debugger/connection/VmConnection;Lcom/intellij/execution/ExecutionResult;)V", "beforeInitBreakpoints", "", "vm", "Lorg/jetbrains/debugger/Vm;", "createDebuggerViewSupport", "Lcom/intellij/javascript/debugger/JavaScriptDebuggerViewSupport;", "normalizeMemberNameIfNotProcessedByDebugAware", "", "name", "registerAdditionalActions", "leftToolbar", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "topToolbar", "settings", "intellij.javascript.debugger.backend"})
public class BrowserChromeDebugProcess
extends ChromeDebugProcess {
    public BrowserChromeDebugProcess(@NotNull XDebugSession session, @NotNull DebuggableFileFinder finder, @NotNull VmConnection<? extends WipVm> connection2, @Nullable ExecutionResult executionResult) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)finder, (String)"finder");
        Intrinsics.checkNotNullParameter(connection2, (String)"connection");
        super(session, finder, connection2, executionResult);
        this.setElementsInspectorEnabled(true);
    }

    public /* synthetic */ BrowserChromeDebugProcess(XDebugSession xDebugSession, DebuggableFileFinder debuggableFileFinder, VmConnection vmConnection, ExecutionResult executionResult, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            executionResult = null;
        }
        this(xDebugSession, debuggableFileFinder, (VmConnection<? extends WipVm>)vmConnection, executionResult);
    }

    @Override
    public void beforeInitBreakpoints(@NotNull Vm vm) {
        Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
        if (Registry.Companion.is("js.debugger.chrome.use.any.breakpoint", true)) {
            JavaScriptLineBreakpointManager.setAnyFirstLineBreakpoint$default(this.getLineBreakpointManager(), vm, "^[^/\\\\]+-\\d+\\.([jJ][sS])$", null, 4, null);
            JavaScriptLineBreakpointManager.setAnyFirstLineBreakpoint$default(this.getLineBreakpointManager(), vm, "[.\\\\/]bundle\\.js$", null, 4, null);
        }
        super.beforeInitBreakpoints(vm);
    }

    @Override
    @NotNull
    protected JavaScriptDebuggerViewSupport createDebuggerViewSupport() {
        return new BrowserJavaScriptDebuggerViewSupport(this);
    }

    @Override
    @NotNull
    protected String normalizeMemberNameIfNotProcessedByDebugAware(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = BrowserChromeDebugProcessKt.access$getHEX_POSTFIX_PATTERN$p().matcher(name).replaceAll("");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"replaceAll(...)");
        return string;
    }

    @Override
    public void registerAdditionalActions(@NotNull DefaultActionGroup leftToolbar, @NotNull DefaultActionGroup topToolbar, @NotNull DefaultActionGroup settings) {
        Intrinsics.checkNotNullParameter((Object)leftToolbar, (String)"leftToolbar");
        Intrinsics.checkNotNullParameter((Object)topToolbar, (String)"topToolbar");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super.registerAdditionalActions(leftToolbar, topToolbar, settings);
        leftToolbar.addAction((AnAction)new ReloadInBrowserAction(), new Constraints(Anchor.AFTER, "Rerun"));
    }
}

