/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.FunctionStepIntoVariant;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JavaScriptLineBreakpointManager;
import com.intellij.javascript.debugger.SyntheticSuspendBreakpointInfo;
import com.intellij.javascript.debugger.chrome.wip.WipConsoleAPICalled;
import com.intellij.javascript.debugger.chrome.wip.WipConsoleMessageTask;
import com.intellij.javascript.debugger.chrome.wip.WipCssManager;
import com.intellij.javascript.debugger.chrome.wip.WipExceptionThrown;
import com.intellij.javascript.debugger.chrome.wip.WipLogEntry;
import com.intellij.javascript.debugger.console.ConsoleMessage;
import com.intellij.javascript.debugger.console.ConsolePrinter;
import com.intellij.javascript.debugger.console.ConsolePrinterSettings;
import com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration;
import com.intellij.javascript.debugger.settings.JavaScriptDebuggerSettings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.PatternUtil;
import com.intellij.util.Url;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.jetbrains.debugger.wip.ChromeDebugProcess;
import com.jetbrains.debugger.wip.ChromeDebugProcessKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.ScriptManager;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.debugger.values.FunctionValue;
import org.jetbrains.jsonProtocol.EventType;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.NodeWipVm;
import org.jetbrains.wip.WipCallFrame;
import org.jetbrains.wip.WipCommandProcessor;
import org.jetbrains.wip.WipFunction;
import org.jetbrains.wip.WipScript;
import org.jetbrains.wip.WipSuspendContext;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.WipVmKt;
import org.jetbrains.wip.protocol.ProtocolResponseReader;
import org.jetbrains.wip.protocol.console.MessageAddedEventData;
import org.jetbrains.wip.protocol.debugger.DebuggerKt;
import org.jetbrains.wip.protocol.debugger.LocationValue;
import org.jetbrains.wip.protocol.debugger.ScriptPosition;
import org.jetbrains.wip.protocol.log.EntryAddedEventData;
import org.jetbrains.wip.protocol.runtime.ConsoleAPICalledEventData;
import org.jetbrains.wip.protocol.runtime.ExceptionThrownEventData;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0005\b\u0016\u0018\u00002\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00020\u0001B3\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0002\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0014J\b\u0010\u0019\u001a\u00020\u001aH\u0014J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\n\u0010\u001c\u001a\u0004\u0018\u00010\u000fH\u0016J\u001e\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 2\u0006\u0010!\u001a\u00020\"H\u0014J \u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010!\u001a\u00020\"H\u0014J\u0018\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170)2\u0006\u0010\u0018\u001a\u00020\u0003H\u0004J \u0010,\u001a\u00020\u00172\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.2\u0006\u00100\u001a\u00020.H\u0016J\u0010\u00101\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u000202H\u0016J\u0018\u00103\u001a\u00020\u00172\u0006\u00104\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u000202H\u0014J\u0010\u00105\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u0010\u00106\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J@\u00107\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u0002022\u0006\u00108\u001a\u0002092\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010:\u001a\u0004\u0018\u00010\u000f2\u0012\u0010;\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030)\u0018\u00010<H\u0016J\u0010\u0010=\u001a\u00020\u00112\u0006\u0010>\u001a\u00020\u000fH\u0002J\u000e\u0010?\u001a\u00020\u00172\u0006\u00104\u001a\u00020\u0011J\b\u0010@\u001a\u00020\u0011H\u0014R$\u0010\r\u001a\u0018\u0012\t\u0012\u00070\u000f\u00a2\u0006\u0002\b\u0010\u0012\t\u0012\u00070\u0011\u00a2\u0006\u0002\b\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010*\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u0006A"}, d2={"Lcom/jetbrains/debugger/wip/ChromeDebugProcess;", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "Lorg/jetbrains/debugger/connection/VmConnection;", "Lorg/jetbrains/wip/WipVm;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "finder", "Lcom/intellij/javascript/debugger/DebuggableFileFinder;", "connection", "executionResult", "Lcom/intellij/execution/ExecutionResult;", "<init>", "(Lcom/intellij/xdebugger/XDebugSession;Lcom/intellij/javascript/debugger/DebuggableFileFinder;Lorg/jetbrains/debugger/connection/VmConnection;Lcom/intellij/execution/ExecutionResult;)V", "blackBoxCache", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lcom/intellij/util/Url;", "Lkotlin/jvm/internal/EnhancedNullability;", "", "cssManager", "Lcom/intellij/javascript/debugger/chrome/wip/WipCssManager;", "getCssManager", "()Lcom/intellij/javascript/debugger/chrome/wip/WipCssManager;", "onStart", "", "vm", "configureConsolePrinter", "Lcom/intellij/javascript/debugger/console/ConsolePrinterSettings;", "registerVmPrintEvents", "getCurrentLocationUrl", "getSyntheticSuspend", "Lcom/intellij/javascript/debugger/SyntheticSuspendBreakpointInfo;", "context", "Lorg/jetbrains/debugger/SuspendContext;", "script", "Lorg/jetbrains/debugger/Script;", "compareFunctions", "expectedFunction", "Lcom/intellij/javascript/debugger/FunctionStepIntoVariant;", "topFrame", "Lorg/jetbrains/debugger/CallFrame;", "evaluateProcessName", "Lorg/jetbrains/concurrency/Promise;", "isFilesOnlyInLocalFileSystem", "()Z", "registerAdditionalActions", "leftToolbar", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "topToolbar", "settings", "beforeInitBreakpoints", "Lorg/jetbrains/debugger/Vm;", "enableBlackboxing", "state", "clearBlackboxing", "setBlackboxing", "sourceMapFound", "map", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "scriptUrl", "setPromises", "", "needsBlackboxing", "sourceUrl", "setMuteBreakpoints", "isFilePathRegexpCreator", "intellij.javascript.debugger.backend"})
@SourceDebugExtension(value={"SMAP\nChromeDebugProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChromeDebugProcess.kt\ncom/jetbrains/debugger/wip/ChromeDebugProcess\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,359:1\n1915#2,2:360\n1586#2:362\n1661#2,3:363\n1586#2:366\n1661#2,3:367\n1915#2:370\n1586#2:371\n1661#2,3:372\n1916#2:375\n1807#2,3:377\n1915#2,2:380\n1#3:376\n*S KotlinDebug\n*F\n+ 1 ChromeDebugProcess.kt\ncom/jetbrains/debugger/wip/ChromeDebugProcess\n*L\n223#1:360,2\n232#1:362\n232#1:363,3\n234#1:366\n234#1:367,3\n238#1:370\n240#1:371\n240#1:372,3\n238#1:375\n285#1:377,3\n294#1:380,2\n*E\n"})
public class ChromeDebugProcess
extends JavaScriptDebugProcess<VmConnection<? extends WipVm>> {
    @NotNull
    private final Cache<Url, Boolean> blackBoxCache;
    @NotNull
    private final WipCssManager cssManager;

    public ChromeDebugProcess(@NotNull XDebugSession session, @NotNull DebuggableFileFinder finder, @NotNull VmConnection<? extends WipVm> connection2, @Nullable ExecutionResult executionResult) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)finder, (String)"finder");
        Intrinsics.checkNotNullParameter(connection2, (String)"connection");
        super(session, finder, connection2, executionResult);
        Cache cache = Caffeine.newBuilder().weakKeys().maximumSize(3000L).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.blackBoxCache = cache;
        this.cssManager = new WipCssManager(this);
        connection2.executeOnStart((Function1)new Function1<WipVm, Unit>((Object)this){

            public final void invoke(WipVm p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((ChromeDebugProcess)this.receiver).onStart(p0);
            }
        });
        connection2.addDebugListener(new DebugEventListener(){

            public void navigated(String newUrl) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)newUrl, (String)"newUrl");
                    BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                        int label;
                        final /* synthetic */ ChromeDebugProcess this$0;
                        {
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object $result) {
                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.label = 1;
                                    Object object2 = ChromeDebugProcess.access$getConsolePrinter(this.this$0).clear((Continuation<? super Unit>)((Continuation)this));
                                    if (object2 != object) return Unit.INSTANCE;
                                    return object;
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object2 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)1, null);
                    WipCssManager wipCssManager = this.getCssManager();
                    if (wipCssManager == null) break block0;
                    wipCssManager.clear();
                }
            }

            public void childVmAdded(Vm childVm) {
                Intrinsics.checkNotNullParameter((Object)childVm, (String)"childVm");
                if (!(childVm instanceof WipVm)) {
                    return;
                }
                this.registerVmPrintEvents((WipVm)childVm);
            }
        });
        session.addSessionListener(new XDebugSessionListener(){

            public void breakpointsMuted(boolean muted) {
                this.setMuteBreakpoints(muted);
            }
        });
    }

    public /* synthetic */ ChromeDebugProcess(XDebugSession xDebugSession, DebuggableFileFinder debuggableFileFinder, VmConnection vmConnection, ExecutionResult executionResult, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            executionResult = null;
        }
        this(xDebugSession, debuggableFileFinder, (VmConnection<? extends WipVm>)vmConnection, executionResult);
    }

    @NotNull
    public final WipCssManager getCssManager() {
        return this.cssManager;
    }

    protected void onStart(@NotNull WipVm vm) {
        Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
        this.registerVmPrintEvents(vm);
        int asyncCallStackDepth = Registry.Companion.get("js.debugger.async.call.stack.depth").asInteger();
        vm.getCommandProcessor().send((Request)DebuggerKt.SetAsyncCallStackDepth((int)asyncCallStackDepth));
    }

    @Override
    @NotNull
    protected ConsolePrinterSettings configureConsolePrinter() {
        return new ConsolePrinterSettings((Function2<Object, Object, Boolean>)((Function2)configureConsolePrinter.1.INSTANCE));
    }

    private final void registerVmPrintEvents(WipVm vm) {
        ChromeDebugProcess.registerVmPrintEvents$addMessageHandler(vm, this, (EventType)ConsoleAPICalledEventData.TYPE, arg_0 -> ChromeDebugProcess.registerVmPrintEvents$lambda$1(vm, arg_0));
        ChromeDebugProcess.registerVmPrintEvents$addMessageHandler(vm, this, (EventType)EntryAddedEventData.TYPE, arg_0 -> ChromeDebugProcess.registerVmPrintEvents$lambda$2(vm, arg_0));
        ChromeDebugProcess.registerVmPrintEvents$addMessageHandler(vm, this, (EventType)ExceptionThrownEventData.TYPE, arg_0 -> ChromeDebugProcess.registerVmPrintEvents$lambda$3(vm, arg_0));
        ChromeDebugProcess.registerVmPrintEvents$addMessageHandler(vm, this, (EventType)MessageAddedEventData.TYPE, arg_0 -> ChromeDebugProcess.registerVmPrintEvents$lambda$4(vm, arg_0));
    }

    @Override
    @Nullable
    public Url getCurrentLocationUrl() {
        WipVm wipVm = (WipVm)this.getActiveOrMainVm();
        return wipVm != null ? wipVm.getCurrentUrl() : null;
    }

    @Override
    @Nullable
    protected SyntheticSuspendBreakpointInfo getSyntheticSuspend(@NotNull SuspendContext<?> context, @NotNull Script script) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Vm vm = context.getVm();
        if (context instanceof WipSuspendContext && ((WipSuspendContext)context).isBreakOnStart()) {
            this.initBreakpoints();
            if (!Intrinsics.areEqual((Object)vm, (Object)this.getMainVm()) && vm instanceof NodeWipVm) {
                Promise promise = this.evaluateProcessName((WipVm)vm).onProcessed(arg_0 -> ChromeDebugProcess.getSyntheticSuspend$lambda$1(arg_0 -> ChromeDebugProcess.getSyntheticSuspend$lambda$0(this, vm, arg_0), arg_0));
                Intrinsics.checkNotNull((Object)promise);
            } else {
                this.resume(vm);
            }
            return SyntheticSuspendBreakpointInfo.Companion.getSKIP();
        }
        return JavaScriptDebugProcess.processBreakpointsHit$default(this, context, script, null, 4, null);
    }

    @Override
    protected boolean compareFunctions(@NotNull FunctionStepIntoVariant expectedFunction, @NotNull CallFrame topFrame, @NotNull Script script) {
        Intrinsics.checkNotNullParameter((Object)((Object)expectedFunction), (String)"expectedFunction");
        Intrinsics.checkNotNullParameter((Object)topFrame, (String)"topFrame");
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        FunctionValue functionValue = expectedFunction.getRuntimeMethodInfo();
        WipFunction expectedRuntimeMethodInfo = functionValue instanceof WipFunction ? (WipFunction)functionValue : null;
        LocationValue currentFunctionLocation = ((WipCallFrame)topFrame).getFunctionLocation();
        if (expectedRuntimeMethodInfo == null || currentFunctionLocation == null) {
            return super.compareFunctions(expectedFunction, topFrame, script);
        }
        return expectedRuntimeMethodInfo.getOpenParenColumn() == currentFunctionLocation.getColumnNumber() && expectedRuntimeMethodInfo.getOpenParenLine() == currentFunctionLocation.getLineNumber() && Intrinsics.areEqual((Object)expectedRuntimeMethodInfo.getScriptId(), (Object)currentFunctionLocation.scriptId());
    }

    @NotNull
    protected final Promise<Unit> evaluateProcessName(@NotNull WipVm vm) {
        Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
        EvaluateContext evaluateContext = vm.getEvaluateContext();
        Intrinsics.checkNotNull((Object)evaluateContext);
        Promise promise = EvaluateContext.evaluate$default((EvaluateContext)evaluateContext, (String)"process.pid + \"|\" + process.argv.join(\",\")", null, (boolean)false, null, (int)14, null).then(arg_0 -> ChromeDebugProcess.evaluateProcessName$lambda$1(arg_0 -> ChromeDebugProcess.evaluateProcessName$lambda$0(vm, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"then(...)");
        return promise;
    }

    @Override
    public boolean isFilesOnlyInLocalFileSystem() {
        return this.getMainVm() instanceof NodeWipVm;
    }

    @Override
    public void registerAdditionalActions(@NotNull DefaultActionGroup leftToolbar, @NotNull DefaultActionGroup topToolbar, @NotNull DefaultActionGroup settings) {
        Intrinsics.checkNotNullParameter((Object)leftToolbar, (String)"leftToolbar");
        Intrinsics.checkNotNullParameter((Object)topToolbar, (String)"topToolbar");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super.registerAdditionalActions(leftToolbar, topToolbar, settings);
        settings.addAction((AnAction)new JavaScriptDebugProcess.WatchLastMethodReturnValueAction(), Constraints.FIRST);
        settings.addAction((AnAction)new JavaScriptDebugProcess.ShowGettersAndSettersAction(), Constraints.FIRST);
    }

    @Override
    public void beforeInitBreakpoints(@NotNull Vm vm) {
        boolean breakOnFirstStatement;
        Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
        ((WipVm)vm).getCommandProcessor().send((Request)DebuggerKt.SetSkipAllPauses((boolean)this.getSession().areBreakpointsMuted()));
        if (JavaScriptDebuggerSettings.getInstance().isDoNotStepIntoLibraryCode()) {
            this.setBlackboxing((WipVm)vm);
        }
        super.beforeInitBreakpoints(vm);
        RunProfile runProfile = this.getSession().getRunProfile();
        boolean bl = breakOnFirstStatement = runProfile instanceof JavaScriptDebugConfiguration ? ((JavaScriptDebugConfiguration)runProfile).isUseFirstLineBreakpoints() : Registry.Companion.is("js.debugger.break.on.first.statement");
        if (breakOnFirstStatement) {
            if (vm instanceof NodeWipVm) {
                JavaScriptLineBreakpointManager.setAnyFirstLineBreakpoint$default(this.getLineBreakpointManager(), vm, ".*", null, 4, null);
            } else {
                ((WipVm)vm).getBreakpointManager().setBreakOnFirstStatement();
            }
        }
    }

    @Override
    protected void enableBlackboxing(boolean state, @NotNull Vm vm) {
        Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
        if (state != !this.getDisableDoNotStepIntoLibraries() || this.getPatternsUpdateNeeded()) {
            if (state && JavaScriptDebuggerSettings.getInstance().isDoNotStepIntoLibraryCode()) {
                this.setBlackboxing((WipVm)vm);
            } else {
                this.clearBlackboxing((WipVm)vm);
            }
        }
        super.enableBlackboxing(state, vm);
    }

    private final void clearBlackboxing(WipVm vm) {
        vm.getCommandProcessor().send((Request)DebuggerKt.SetBlackboxPatterns$default((List)CollectionsKt.emptyList(), null, (int)2, null));
        Iterable $this$forEach$iv = (Iterable)this.getBlackBoxedScripts();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JavaScriptDebugProcess.ScriptRanges scriptRange = (JavaScriptDebugProcess.ScriptRanges)element$iv;
            boolean bl = false;
            vm.getCommandProcessor().send((Request)DebuggerKt.SetBlackboxedRanges((CharSequence)scriptRange.getScriptId(), (List)CollectionsKt.listOf((Object)new ScriptPosition(Integer.MAX_VALUE, Integer.MAX_VALUE))));
        }
        this.setPatternsUpdateNeeded(false);
    }

    /*
     * WARNING - void declaration
     */
    private final void setBlackboxing(WipVm vm) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv2 = this.getLibraryPatterns();
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void p0;
            Regex regex = (Regex)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toString());
        }
        List patterns = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        List<String> list = JavaScriptDebuggerSettings.getInstance().getEnabledSteppingFilters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getEnabledSteppingFilters(...)");
        Iterable $i$f$map22 = list;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String bl = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(PatternUtil.convertToRegex((String)it));
        }
        List customStepFilters = CollectionsKt.toList((Iterable)((List)destination$iv$iv2));
        patterns.addAll(customStepFilters);
        vm.getCommandProcessor().send((Request)DebuggerKt.SetBlackboxPatterns$default((List)patterns, null, (int)2, null));
        Iterable $this$forEach$iv = (Iterable)this.getBlackBoxedScripts();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Collection<ScriptPosition> collection2;
            void $this$mapTo$iv$iv3;
            void $this$map$iv3;
            Object item$iv$iv;
            JavaScriptDebugProcess.ScriptRanges scriptRanges = (JavaScriptDebugProcess.ScriptRanges)element$iv;
            boolean bl = false;
            item$iv$iv = scriptRanges.getRanges();
            CharSequence charSequence = scriptRanges.getScriptId();
            WipCommandProcessor wipCommandProcessor = vm.getCommandProcessor();
            boolean $i$f$map3 = false;
            void var14_24 = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
                Pair pair = (Pair)item$iv$iv2;
                collection2 = destination$iv$iv3;
                boolean bl3 = false;
                int line = ((Number)pair.component1()).intValue();
                int column = ((Number)pair.component2()).intValue();
                collection2.add(new ScriptPosition(line, column));
            }
            collection2 = (List)destination$iv$iv3;
            wipCommandProcessor.send((Request)DebuggerKt.SetBlackboxedRanges((CharSequence)charSequence, (List)collection2));
        }
        this.setPatternsUpdateNeeded(false);
    }

    @Override
    public void sourceMapFound(@NotNull Vm vm, @NotNull SourceMap map, @Nullable Script script, @Nullable Url scriptUrl, @Nullable List<Promise<?>> setPromises) {
        boolean startsWithUnmappedRegion;
        MappingEntry currentMapping;
        Script script2;
        Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        super.sourceMapFound(vm, map, script, scriptUrl, setPromises);
        Script script3 = script;
        if (script3 == null) {
            ScriptManager scriptManager = vm.getScriptManager();
            Url url = scriptUrl;
            Intrinsics.checkNotNull((Object)url);
            script3 = scriptManager.findScriptByUrl(url);
        }
        WipScript wipScript = (script2 = script3) instanceof WipScript ? (WipScript)script2 : null;
        if (wipScript == null) {
            return;
        }
        WipScript wipScript2 = wipScript;
        if (this.needsBlackboxing(wipScript2.getUrl())) {
            return;
        }
        JavaScriptDebugProcess.ScriptRanges scriptRanges = new JavaScriptDebugProcess.ScriptRanges(wipScript2.getId());
        boolean currentRegionBlackboxed = false;
        MappingEntry mappingEntry = currentMapping = map.getGeneratedMappings().getByIndex(0);
        Intrinsics.checkNotNull((Object)mappingEntry);
        boolean bl = startsWithUnmappedRegion = mappingEntry.getGeneratedLine() != 0 || currentMapping.getGeneratedColumn() != 0;
        if (startsWithUnmappedRegion) {
            scriptRanges.getRanges().add((Pair<Integer, Integer>)new Pair((Object)0, (Object)0));
            currentRegionBlackboxed = true;
        }
        while (currentMapping != null) {
            boolean bl2;
            int currentSource = currentMapping.getSource();
            if ((currentSource == -1 || this.needsBlackboxing(map.getSources()[currentSource])) != currentRegionBlackboxed) {
                scriptRanges.getRanges().add((Pair<Integer, Integer>)new Pair((Object)currentMapping.getGeneratedLine(), (Object)currentMapping.getGeneratedColumn()));
                currentRegionBlackboxed = !currentRegionBlackboxed;
            }
            do {
                MappingEntry mappingEntry2 = currentMapping;
                MappingEntry mappingEntry3 = currentMapping = mappingEntry2 != null ? mappingEntry2.getNextGenerated() : null;
                if (mappingEntry3 != null) {
                    if (mappingEntry3.getSource() == currentSource) {
                        bl2 = true;
                        continue;
                    }
                    bl2 = false;
                    continue;
                }
                bl2 = false;
            } while (bl2);
        }
        if (!((Collection)scriptRanges.getRanges()).isEmpty()) {
            this.getBlackBoxedScripts().add((Object)scriptRanges);
            this.setPatternsUpdateNeeded(true);
        }
    }

    private final boolean needsBlackboxing(Url sourceUrl) {
        boolean bl;
        block4: {
            Boolean bl2 = (Boolean)this.blackBoxCache.getIfPresent((Object)sourceUrl);
            if (bl2 != null) {
                boolean it = bl2;
                boolean bl3 = false;
                return it;
            }
            Iterable $this$any$iv = this.getLibraryPatterns();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Regex pattern = (Regex)element$iv;
                    boolean bl4 = false;
                    String string = sourceUrl.trimParameters().toDecodedForm();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toDecodedForm(...)");
                    if (!pattern.matches((CharSequence)string)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        boolean needBlackboxing = bl || this.matchesCustomStepFilter(sourceUrl);
        this.blackBoxCache.put((Object)sourceUrl, (Object)needBlackboxing);
        return needBlackboxing;
    }

    public final void setMuteBreakpoints(boolean state) {
        Iterable $this$forEach$iv = this.getCollectVMs();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Vm vm = (Vm)element$iv;
            boolean bl = false;
            WipVm wipVm = vm instanceof WipVm ? (WipVm)vm : null;
            if (wipVm == null || (wipVm = wipVm.getCommandProcessor()) == null) continue;
            wipVm.send((Request)DebuggerKt.SetSkipAllPauses((boolean)state));
        }
    }

    @Override
    protected boolean isFilePathRegexpCreator() {
        return this.getMainVm() instanceof NodeWipVm;
    }

    private static final Unit registerVmPrintEvents$addMessageHandler$lambda$0(WipVm $vm, ChromeDebugProcess this$0, Function1 $messageFactory, Object messageData) {
        if (!ChromeDebugProcessKt.access$isWorkerMessage(messageData, (Vm)$vm)) {
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, $vm, messageData, $messageFactory, null){
                int label;
                final /* synthetic */ ChromeDebugProcess this$0;
                final /* synthetic */ WipVm $vm;
                final /* synthetic */ T $messageData;
                final /* synthetic */ Function1<T, ConsoleMessage> $messageFactory;
                {
                    this.this$0 = $receiver;
                    this.$vm = $vm;
                    this.$messageData = $messageData;
                    this.$messageFactory = $messageFactory;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = ConsolePrinter.submitMessage$default(ChromeDebugProcess.access$getConsolePrinter(this.this$0), (Vm)this.$vm, false, this.$messageData, this.$messageFactory, (Continuation)this, 2, null);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            Object object2;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                object2 = $result;
                                return Unit.INSTANCE;
                            }
                            catch (CancellationException e) {
                                e.printStackTrace();
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }
        return Unit.INSTANCE;
    }

    private static final <T> void registerVmPrintEvents$addMessageHandler(WipVm $vm, ChromeDebugProcess this$0, EventType<T, ProtocolResponseReader> type, Function1<? super T, ? extends ConsoleMessage> messageFactory) {
        $vm.getCommandProcessor().getEventMap().add(type, arg_0 -> ChromeDebugProcess.registerVmPrintEvents$addMessageHandler$lambda$0($vm, this$0, messageFactory, arg_0));
    }

    private static final ConsoleMessage registerVmPrintEvents$lambda$1(WipVm $vm, ConsoleAPICalledEventData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new WipConsoleAPICalled(it, $vm);
    }

    private static final ConsoleMessage registerVmPrintEvents$lambda$2(WipVm $vm, EntryAddedEventData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new WipLogEntry(it.entry(), $vm.getNetworkManager().retrieveRequest(it.entry().getNetworkRequestId()));
    }

    private static final ConsoleMessage registerVmPrintEvents$lambda$3(WipVm $vm, ExceptionThrownEventData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new WipExceptionThrown(it, $vm);
    }

    private static final ConsoleMessage registerVmPrintEvents$lambda$4(WipVm $vm, MessageAddedEventData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new WipConsoleMessageTask(it.message(), $vm, $vm.getNetworkManager().retrieveRequest(it.message().getNetworkRequestId()));
    }

    private static final Unit getSyntheticSuspend$lambda$0(ChromeDebugProcess this$0, Vm $vm, Unit it) {
        this$0.resume($vm);
        return Unit.INSTANCE;
    }

    private static final void getSyntheticSuspend$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit evaluateProcessName$lambda$0(WipVm $vm, EvaluateResult evaluateResult) {
        block2: {
            char[] cArray;
            if (evaluateResult.getWasThrown()) break block2;
            Object object = evaluateResult.getValue().getValueString();
            if (object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (char[])(cArray = new char[]{'|'}), (boolean)false, (int)0, (int)6, null)) != null) {
                Object parts = object;
                boolean bl = false;
                String string = WipVmKt.computeName$default((List)parts, (int)0, (int)2, null);
                if (string != null) {
                    String it = string;
                    boolean bl2 = false;
                    $vm.setPresentableName(it);
                }
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit evaluateProcessName$lambda$1(Function1 $tmp0, Object p0) {
        return (Unit)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ ConsolePrinter access$getConsolePrinter(ChromeDebugProcess $this) {
        return $this.getConsolePrinter();
    }
}

