/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle.psi;

import com.intellij.database.dialects.oracle.types.OraTypeSystem;
import com.intellij.database.model.DataType;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.types.DasBuiltinType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeClass;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.dialects.oracle.OraTypes;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlDasTypeAwareDeepRecursiveElement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlReferenceTypeElementImpl;
import java.util.Locale;
import kotlin.DeepRecursiveScope;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\"\u0010\u000f\u001a\u00020\u0010*\u0012\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00100\u0011j\u0002`\u0013H\u0096@\u00a2\u0006\u0002\u0010\u0014R\u0013\u0010\b\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/intellij/sql/dialects/oracle/psi/OraReferenceTypeElementImpl;", "Lcom/intellij/sql/psi/impl/SqlReferenceTypeElementImpl;", "elementType", "Lcom/intellij/psi/tree/IElementType;", "<init>", "(Lcom/intellij/psi/tree/IElementType;)V", "parseDataType", "Lcom/intellij/database/model/DataType;", "suffixTokenType", "getSuffixTokenType", "()Lcom/intellij/psi/tree/IElementType;", "suffixToken", "Lcom/intellij/psi/PsiElement;", "getSuffixToken", "()Lcom/intellij/psi/PsiElement;", "computeDasType", "Lcom/intellij/database/types/DasType;", "Lkotlin/DeepRecursiveScope;", "Lcom/intellij/sql/psi/impl/SqlDasTypeAwareDeepRecursiveElement;", "Lcom/intellij/sql/psi/impl/SqlDeepRecursiveTypeEvaluationScope;", "(Lkotlin/DeepRecursiveScope;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.database.dialects.oracle"})
public final class OraReferenceTypeElementImpl
extends SqlReferenceTypeElementImpl {
    public OraReferenceTypeElementImpl(@NotNull IElementType elementType) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        super(elementType);
    }

    @NotNull
    public DataType parseDataType() {
        SqlReferenceExpression sqlReferenceExpression = this.getReferenceExpression();
        if (sqlReferenceExpression == null) {
            return super.parseDataType();
        }
        SqlReferenceExpression referenceExpression = sqlReferenceExpression;
        DataType dataType = SqlImplUtil.getNormalizedDataType((SqlReferenceExpression)referenceExpression);
        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"getNormalizedDataType(...)");
        DataType dasType = dataType;
        PsiElement psiElement = this.getSuffixToken();
        if (psiElement == null) {
            return dasType;
        }
        PsiElement suffixToken = psiElement;
        String string = suffixToken.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        DataType dataType2 = DataTypeFactory.withSuffix((DataType)dasType, (String)("%" + string2));
        Intrinsics.checkNotNullExpressionValue((Object)dataType2, (String)"withSuffix(...)");
        return dataType2;
    }

    @Nullable
    public final IElementType getSuffixTokenType() {
        IElementType lastType = PsiTreeUtilKt.getElementType((PsiElement)this.getLastChild());
        return Intrinsics.areEqual((Object)lastType, (Object)OraTypes.ORA_TYPE) || Intrinsics.areEqual((Object)lastType, (Object)OraTypes.ORA_ROWTYPE) ? lastType : null;
    }

    @Nullable
    public final PsiElement getSuffixToken() {
        return this.getSuffixTokenType() != null ? this.getLastChild() : null;
    }

    @Nullable
    public Object computeDasType(@NotNull DeepRecursiveScope<SqlDasTypeAwareDeepRecursiveElement, DasType> $this$computeDasType, @NotNull Continuation<? super DasType> $completion) {
        SqlReferenceExpression sqlReferenceExpression = this.getReferenceExpression();
        if (sqlReferenceExpression == null) {
            return this.doComputeDasType();
        }
        SqlReferenceExpression referenceExpression = sqlReferenceExpression;
        String string = referenceExpression.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String name2 = string;
        String string2 = name2.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        DasType dasType = OraTypeSystem.predefinedTypes.get(string2);
        if (dasType instanceof DasBuiltinType) {
            if (!Intrinsics.areEqual((Object)((DasTypeClass)((DasBuiltinType)dasType).getTypeClass()).getName(), (Object)name2)) {
                dasType = (DasType)DasTypeUtilsKt.withName((DasBuiltinType)((DasBuiltinType)dasType), (String)name2);
            }
            return dasType;
        }
        return this.doComputeDasType();
    }
}

