/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.PluginManagementPolicy;
import com.intellij.ide.ui.NewUiUtilKt;
import com.intellij.ide.ui.ToolbarSettings;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.RightAlignedToolbarAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.ex.TooltipDescriptionProvider;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.CeProcessCanceledException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.StatusBarWidgetFactory;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetsManager;
import com.intellij.ui.BadgeIconSupplier;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.IconManager;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.ui.popup.ActionPopupOptions;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SettingsEntryPointAction
extends ActionGroup
implements CustomComponentAction,
Toggleable,
DumbAware,
RightAlignedToolbarAction,
TooltipDescriptionProvider {
    private static final Logger LOG = Logger.getInstance(SettingsEntryPointAction.class);
    private static final BadgeIconSupplier GEAR_ICON = new BadgeIconSupplier(AllIcons.General.GearPlain);
    private static final Icon NEW_UI_ICON = IconManager.getInstance().withIconBadge(AllIcons.General.GearPlain, (Paint)JBUI.CurrentTheme.IconBadge.NEW_UI);
    private static final BadgeIconSupplier IDE_UPDATE_ICON = new BadgeIconSupplier(AllIcons.Ide.Notification.IdeUpdate);
    private static final BadgeIconSupplier PLUGIN_UPDATE_ICON = new BadgeIconSupplier(AllIcons.Ide.Notification.PluginUpdate);
    private static boolean ourShowPlatformUpdateIcon;
    private static boolean ourShowPluginsUpdateIcon;
    private static boolean ourNewUiIcon;
    private static UISettingsListener mySettingsListener;
    private static final String WIDGET_ID = "settingsEntryPointWidget";

    public SettingsEntryPointAction() {
        this.getTemplatePresentation().putClientProperty(ActionUtil.ALWAYS_VISIBLE_GROUP, (Object)true);
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
        if (presentation2 == null) {
            SettingsEntryPointAction.$$$reportNull$$$0(0);
        }
        if (place == null) {
            SettingsEntryPointAction.$$$reportNull$$$0(1);
        }
        boolean newUI = ExperimentalUI.isNewUI() && "MainToolbar".equals(place);
        return new ActionButton((AnAction)this, presentation2, place, newUI ? ActionToolbar.experimentalToolbarMinimumButtonSize() : ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE){
            {
                this.putClientProperty("AccessibleName", IdeBundle.message((String)"settings.entry.point.tooltip", (Object[])new Object[0]));
            }

            @Override
            protected void paintButtonLook(Graphics g) {
                Icon icon2 = this.getIcon();
                if (icon2 instanceof ComboIcon) {
                    ComboIcon comboIcon = (ComboIcon)icon2;
                    comboIcon.paintButton(this, this.getButtonLook(), g);
                } else {
                    super.paintButtonLook(g);
                }
            }
        };
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            SettingsEntryPointAction.$$$reportNull$$$0(2);
        }
        SettingsEntryPointAction.resetActionIcon();
        JBPopup popup2 = this.createPopup(e);
        PopupUtil.showForActionButtonEvent((JBPopup)popup2, (AnActionEvent)e);
    }

    @ApiStatus.Internal
    @NotNull
    public JBPopup createPopup(@NotNull AnActionEvent e) {
        if (e == null) {
            SettingsEntryPointAction.$$$reportNull$$$0(3);
        }
        ListPopup popup2 = SettingsEntryPointAction.createMainPopup(this, e.getDataContext(), e.getPlace());
        PopupUtil.addToggledStateListener((JBPopup)popup2, (Presentation)e.getPresentation());
        ListPopup listPopup = popup2;
        if (listPopup == null) {
            SettingsEntryPointAction.$$$reportNull$$$0(4);
        }
        return listPopup;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            SettingsEntryPointAction.$$$reportNull$$$0(5);
        }
        e.getPresentation().setPerformGroup(true);
        e.getPresentation().setPopupGroup(true);
        e.getPresentation().putClientProperty(ActionUtil.HIDE_DROPDOWN_ICON, (Object)true);
        Presentation presentation2 = e.getPresentation();
        if (e.isFromActionToolbar()) {
            presentation2.setText("");
        }
        presentation2.setDescription(SettingsEntryPointAction.getActionTooltip());
        presentation2.setIconSupplier(SettingsEntryPointAction::getActionIcon);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            SettingsEntryPointAction.$$$reportNull$$$0(6);
        }
        return actionUpdateThread;
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent event) {
        if (event == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                SettingsEntryPointAction.$$$reportNull$$$0(7);
            }
            return AnAction.EMPTY_ARRAY;
        }
        DataContext context2 = event.getDataContext();
        ArrayList result2 = new ArrayList();
        ArrayList<UpdateAction> appActions = new ArrayList<UpdateAction>();
        ArrayList<UpdateAction> pluginActions = new ArrayList<UpdateAction>();
        boolean showPluginsUpdates = SettingsEntryPointAction.isShowPluginsUpdates();
        for (ActionProvider provider : ActionProvider.EP_NAME.getExtensionList()) {
            try {
                for (UpdateAction action2 : provider.getUpdateActions(context2)) {
                    Presentation presentation2 = action2.getTemplatePresentation();
                    if (action2.isIdeUpdate()) {
                        presentation2.setIcon(AllIcons.Ide.Notification.IdeUpdate);
                        appActions.add(action2);
                    } else {
                        if (!showPluginsUpdates && action2.isPluginUpdate()) continue;
                        presentation2.setIcon(AllIcons.Ide.Notification.PluginUpdate);
                        pluginActions.add(action2);
                    }
                    action2.markAsRead();
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        result2.addAll(appActions);
        result2.addAll(pluginActions);
        if (result2.isEmpty()) {
            SettingsEntryPointAction.resetActionIcon();
        }
        ContainerUtil.addIfNotNull(result2, (Object)ActionManager.getInstance().getAction("UpdateEntryPointGroup"));
        result2.add(Separator.getInstance());
        ContainerUtil.addIfNotNull(result2, (Object)ActionManager.getInstance().getAction("SettingsEntryPointGroup"));
        if (ExperimentalUI.isNewUI() && ContainerUtil.exists((Object[])event.getPlace().split("@"), place -> place.equals("MainToolbar"))) {
            result2.add(Separator.getInstance());
            AnAction customizeMainToolbarAction = ActionManager.getInstance().getAction("CustomizeMainToolbarGroup");
            ContainerUtil.addIfNotNull(result2, (Object)customizeMainToolbarAction);
        }
        if (ExperimentalUI.isNewUI()) {
            for (ActionProvider provider : ActionProvider.EP_NAME.getExtensionList()) {
                try {
                    result2.addAll(provider.getLastActions(context2));
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        AnAction[] anActionArray = result2.toArray(AnAction.EMPTY_ARRAY);
        if (anActionArray == null) {
            SettingsEntryPointAction.$$$reportNull$$$0(8);
        }
        return anActionArray;
    }

    @NotNull
    private static ListPopup createMainPopup(@NotNull ActionGroup group2, @NotNull DataContext context2, @Nullable String eventPlace) {
        if (group2 == null) {
            SettingsEntryPointAction.$$$reportNull$$$0(9);
        }
        if (context2 == null) {
            SettingsEntryPointAction.$$$reportNull$$$0(10);
        }
        boolean hasLastActions = ContainerUtil.find((Iterable)ActionProvider.EP_NAME.getExtensionList(), o -> !o.getLastActions(context2).isEmpty()) != null;
        Object place = "SettingsEntryPoint";
        if (eventPlace != null) {
            place = (String)place + "@" + eventPlace;
        }
        place = ActionPlaces.getPopupPlace((String)place);
        ListPopup popup2 = hasLastActions && ExperimentalUI.isNewUI() ? new MyPopup(group2, context2, new PresentationFactory(), (String)place) : JBPopupFactory.getInstance().createActionGroupPopup(null, group2, context2, null, true, (String)place);
        popup2.setShowSubmenuOnHover(true);
        ListPopup listPopup = popup2;
        if (listPopup == null) {
            SettingsEntryPointAction.$$$reportNull$$$0(11);
        }
        return listPopup;
    }

    public static void updateState() {
        SettingsEntryPointAction.resetActionIcon();
        ourNewUiIcon = SettingsEntryPointAction.calculateOurNewUiIcon();
        boolean showPluginsUpdates = SettingsEntryPointAction.isShowPluginsUpdates();
        block2: for (ActionProvider provider : ActionProvider.EP_NAME.getExtensionList()) {
            try {
                for (UpdateAction action2 : provider.getUpdateActions(DataContext.EMPTY_CONTEXT)) {
                    if (!action2.isNewAction()) continue;
                    if (action2.isIdeUpdate()) {
                        ourShowPlatformUpdateIcon = true;
                    } else {
                        if (!showPluginsUpdates && action2.isPluginUpdate()) continue;
                        ourShowPluginsUpdateIcon = true;
                    }
                    if (!ourShowPlatformUpdateIcon || !ourShowPluginsUpdateIcon) continue;
                    break block2;
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        if (SettingsEntryPointAction.isAvailableInStatusBar()) {
            SettingsEntryPointAction.updateWidgets();
        }
    }

    private static boolean isShowPluginsUpdates() {
        return !PluginManagementPolicy.getInstance().isPluginAutoUpdateAllowed() || !UpdateSettings.getInstance().getState().isPluginsAutoUpdateEnabled();
    }

    private static boolean calculateOurNewUiIcon() {
        return !ExperimentalUI.isNewUI() && !ExperimentalUI.Companion.isNewUiUsedOnce() && NewUiUtilKt.getNewUiPromotionDaysCount() < 14L;
    }

    @NotNull
    @Nls
    private static String getActionTooltip() {
        boolean updates;
        boolean bl = updates = ourShowPlatformUpdateIcon || ourShowPluginsUpdateIcon;
        if (!updates) {
            boolean showPluginsUpdates = SettingsEntryPointAction.isShowPluginsUpdates();
            for (ActionProvider provider2 : ActionProvider.EP_NAME.getExtensionList()) {
                try {
                    Collection<UpdateAction> actions = provider2.getUpdateActions(DataContext.EMPTY_CONTEXT);
                    if (!showPluginsUpdates) {
                        actions = actions.stream().filter(action2 -> !action2.isPluginUpdate()).toList();
                    }
                    if (actions.isEmpty()) continue;
                    updates = true;
                    break;
                }
                catch (ProcessCanceledException pce) {
                    throw pce;
                }
                catch (CancellationException ex) {
                    throw new CeProcessCanceledException(ex);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        String message = updates ? IdeBundle.message((String)"settings.entry.point.with.updates.tooltip", (Object[])new Object[0]) : IdeBundle.message((String)(ourNewUiIcon ? "settings.entry.point.newUi.tooltip" : "settings.entry.point.tooltip"), (Object[])new Object[0]);
        ArrayList<String> tooltips = new ArrayList<String>(ContainerUtil.mapNotNull((Collection)ActionProvider.EP_NAME.getExtensionList(), provider -> provider.getTooltip()));
        if (!tooltips.isEmpty()) {
            tooltips.add(message);
            String string = "<ul style='margin-top:0;margin-bottom:0;padding-top:0;padding-bottom:0;'>" + StringUtil.join(tooltips, element -> "<li>" + element + "</li>", (String)"") + "</ul>";
            if (string == null) {
                SettingsEntryPointAction.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = message;
        if (string == null) {
            SettingsEntryPointAction.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static void resetActionIcon() {
        ourShowPlatformUpdateIcon = false;
        ourShowPluginsUpdateIcon = false;
        ourNewUiIcon = false;
    }

    @NotNull
    private static Icon calculateActionIcon() {
        if (ourShowPlatformUpdateIcon) {
            return ExperimentalUI.isNewUI() ? GEAR_ICON.getWarningIcon() : SettingsEntryPointAction.getCustomizedIcon(IDE_UPDATE_ICON);
        }
        if (ourShowPluginsUpdateIcon) {
            return ExperimentalUI.isNewUI() ? GEAR_ICON.getInfoIcon() : SettingsEntryPointAction.getCustomizedIcon(PLUGIN_UPDATE_ICON);
        }
        if (ourNewUiIcon) {
            Icon icon2 = NEW_UI_ICON;
            if (icon2 == null) {
                SettingsEntryPointAction.$$$reportNull$$$0(14);
            }
            return icon2;
        }
        return SettingsEntryPointAction.getCustomizedIcon(GEAR_ICON);
    }

    @NotNull
    private static Icon getActionIcon() {
        Icon secondIcon;
        Icon firstIcon = SettingsEntryPointAction.calculateActionIcon();
        if (ExperimentalUI.isNewUI() && (secondIcon = SettingsEntryPointAction.getSecondIcon()) != null) {
            return new ComboIcon(firstIcon, secondIcon);
        }
        Icon icon2 = firstIcon;
        if (icon2 == null) {
            SettingsEntryPointAction.$$$reportNull$$$0(15);
        }
        return icon2;
    }

    @NotNull
    private static Icon getCustomizedIcon(@NotNull BadgeIconSupplier supplier) {
        if (supplier == null) {
            SettingsEntryPointAction.$$$reportNull$$$0(16);
        }
        for (IconCustomizer customizer : IconCustomizer.EP_NAME.getExtensionList()) {
            Icon icon2;
            try {
                Icon icon3 = customizer.getCustomIcon(supplier);
                if (icon3 == null) continue;
                icon2 = icon3;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                continue;
            }
            if (icon2 == null) {
                SettingsEntryPointAction.$$$reportNull$$$0(17);
            }
            return icon2;
        }
        Icon icon4 = supplier.getOriginalIcon();
        if (icon4 == null) {
            SettingsEntryPointAction.$$$reportNull$$$0(18);
        }
        return icon4;
    }

    @Nullable
    private static Icon getSecondIcon() {
        for (IconCustomizer customizer : IconCustomizer.EP_NAME.getExtensionList()) {
            try {
                Icon icon2 = customizer.getSecondIcon();
                if (icon2 == null) continue;
                return icon2;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        return null;
    }

    private static void initUISettingsListener() {
        if (mySettingsListener == null) {
            mySettingsListener = uiSettings -> SettingsEntryPointAction.updateWidgets();
            ApplicationManager.getApplication().getMessageBus().connect().subscribe(UISettingsListener.TOPIC, (Object)mySettingsListener);
        }
    }

    private static void updateWidgets() {
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            StatusBar statusBar;
            ((StatusBarWidgetsManager)((Object)project2.getService(StatusBarWidgetsManager.class))).updateWidget(StatusBarManager.class);
            IdeFrame frame = WindowManager.getInstance().getIdeFrame(project2);
            if (frame == null || (statusBar = frame.getStatusBar()) == null) continue;
            statusBar.updateWidget(WIDGET_ID);
        }
    }

    private static boolean isAvailableInStatusBar() {
        SettingsEntryPointAction.initUISettingsListener();
        UISettings uiSettings = UISettings.getInstance();
        ToolbarSettings toolbarSettings = ToolbarSettings.getInstance();
        return !uiSettings.getShowMainToolbar() && !uiSettings.getShowNavigationBar() && !ExperimentalUI.isNewUI() && (!toolbarSettings.isAvailable() || !toolbarSettings.isVisible());
    }

    static {
        ourNewUiIcon = SettingsEntryPointAction.calculateOurNewUiIcon();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 7, 8, 11, 12, 13, 14, 15, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/SettingsEntryPointAction";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/SettingsEntryPointAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopup";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createMainPopup";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionTooltip";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateActionIcon";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionIcon";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomizedIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCustomComponent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createPopup";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createMainPopup";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCustomizedIcon";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 7, 8, 11, 12, 13, 14, 15, 17, 18 -> new IllegalStateException(string);
        };
    }

    public static interface ActionProvider {
        public static final ExtensionPointName<ActionProvider> EP_NAME = new ExtensionPointName("com.intellij.settingsEntryPointActionProvider");

        @NotNull
        public Collection<UpdateAction> getUpdateActions(@NotNull DataContext var1);

        @NotNull
        default public Collection<LastAction> getLastActions(@NotNull DataContext context2) {
            if (context2 == null) {
                ActionProvider.$$$reportNull$$$0(0);
            }
            List<LastAction> list2 = Collections.emptyList();
            if (list2 == null) {
                ActionProvider.$$$reportNull$$$0(1);
            }
            return list2;
        }

        @Nls
        @Nullable
        default public String getTooltip() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/SettingsEntryPointAction$ActionProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/SettingsEntryPointAction$ActionProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLastActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getLastActions";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static abstract class UpdateAction
    extends DumbAwareAction {
        private boolean myNewAction = true;

        protected UpdateAction() {
        }

        protected UpdateAction(@Nullable @NlsActions.ActionText String text2) {
            super(text2);
        }

        public boolean isIdeUpdate() {
            return false;
        }

        public boolean isPluginUpdate() {
            return false;
        }

        public boolean isRestartRequired() {
            return false;
        }

        public boolean isNewAction() {
            return this.myNewAction;
        }

        public void markAsRead() {
            this.myNewAction = false;
        }
    }

    private static class MyPopup
    extends PopupFactoryImpl.ActionGroupPopup {
        @NotNull
        final PresentationFactory myPresentationFactory;

        MyPopup(@NotNull ActionGroup group2, @NotNull DataContext context2, @NotNull PresentationFactory presentationFactory, @NotNull String place) {
            if (group2 == null) {
                MyPopup.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                MyPopup.$$$reportNull$$$0(1);
            }
            if (presentationFactory == null) {
                MyPopup.$$$reportNull$$$0(2);
            }
            if (place == null) {
                MyPopup.$$$reportNull$$$0(3);
            }
            super(null, null, group2, context2, place, presentationFactory, ActionPopupOptions.showDisabled(), null);
            this.myPresentationFactory = presentationFactory;
        }

        @Override
        protected JComponent createContent() {
            JComponent content2 = super.createContent();
            final JList list2 = this.getList();
            list2.setBorder((Border)JBUI.Borders.emptyTop((int)JBUI.CurrentTheme.Popup.bodyTopInsetNoHeader()));
            MouseAdapter listener2 = new MouseAdapter(this){
                LastAction myLastMouseAction = null;

                @Override
                public void mouseMoved(MouseEvent e) {
                    PopupFactoryImpl.ActionItem item;
                    AnAction action2;
                    Object value;
                    int index = list2.locationToIndex(e.getPoint());
                    ListModel model2 = list2.getModel();
                    if (index >= 0 && index < model2.getSize() && (value = model2.getElementAt(index)) instanceof PopupFactoryImpl.ActionItem && (action2 = (item = (PopupFactoryImpl.ActionItem)value).getAction()) instanceof CustomComponentAction && action2 instanceof LastAction) {
                        LastAction lastAction = (LastAction)action2;
                        lastAction.handleMouseMove(e);
                        this.myLastMouseAction = lastAction;
                        return;
                    }
                    this.mouseExited(e);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (this.myLastMouseAction != null) {
                        this.myLastMouseAction.handleMouseExit(e);
                        this.myLastMouseAction = null;
                    }
                }
            };
            list2.addMouseListener(listener2);
            list2.addMouseMotionListener(listener2);
            ClientProperty.put((JComponent)list2, LastAction.POPUP, (Object)this);
            return content2;
        }

        @Override
        protected ListCellRenderer<?> getListElementRenderer() {
            ListCellRenderer<?> renderer2 = super.getListElementRenderer();
            return (list2, value, index, isSelected, cellHasFocus) -> {
                if (value instanceof PopupFactoryImpl.ActionItem) {
                    PopupFactoryImpl.ActionItem item = (PopupFactoryImpl.ActionItem)value;
                    AnAction action2 = item.getAction();
                    Presentation presentation2 = this.myPresentationFactory.getPresentation(action2);
                    if (action2 instanceof LastAction && action2 instanceof CustomComponentAction) {
                        CustomComponentAction customComponent = (CustomComponentAction)action2;
                        return customComponent.createCustomComponent(presentation2, "");
                    }
                    String text2 = item.getText();
                    String secondText = (String)presentation2.getClientProperty(LastAction.SECOND_TEXT);
                    if (secondText != null) {
                        PopupFactoryImpl.ActionItem prevIndex;
                        AnAction prevAction;
                        final JBLabel label2 = new JBLabel(presentation2.getIcon());
                        label2.setBorder((Border)JBUI.Borders.emptyRight((int)(JBUI.CurrentTheme.ActionsList.elementIconGap() - 2)));
                        OpaquePanel panel2 = new OpaquePanel(new BorderLayout(), isSelected ? JBUI.CurrentTheme.ManagedIde.MENU_ITEM_HOVER : JBUI.CurrentTheme.Advertiser.background()){

                            public AccessibleContext getAccessibleContext() {
                                return label2.getAccessibleContext();
                            }
                        };
                        float leftRightInset = JBUI.CurrentTheme.Popup.Selection.LEFT_RIGHT_INSET.getUnscaled();
                        Insets innerInsets = JBUI.CurrentTheme.Popup.Selection.innerInsets().getUnscaled();
                        panel2.setBorder((Border)JBUI.Borders.empty((int)12, (int)((int)(leftRightInset + (float)innerInsets.left)), (int)12, (int)14));
                        NonOpaquePanel iconPanel = new NonOpaquePanel((LayoutManager)new BorderLayout());
                        iconPanel.add((Component)label2, "North");
                        panel2.add((Component)iconPanel, "West");
                        NonOpaquePanel lines = new NonOpaquePanel((LayoutManager)new BorderLayout(0, JBUI.scale((int)2)));
                        lines.add((Component)new JBLabel(text2), "North");
                        JBLabel secondLine = new JBLabel(secondText);
                        secondLine.setForeground(JBUI.CurrentTheme.Advertiser.foreground());
                        lines.add((Component)secondLine, "South");
                        panel2.add((Component)lines);
                        if (index > 0 && !((prevAction = (prevIndex = (PopupFactoryImpl.ActionItem)((ListPopupStep)this.getStep()).getValues().get(index - 1)).getAction()) instanceof LastAction)) {
                            OpaquePanel wrapper2 = new OpaquePanel(new BorderLayout(), list2.getBackground()){

                                public AccessibleContext getAccessibleContext() {
                                    return label2.getAccessibleContext();
                                }
                            };
                            wrapper2.setBorder((Border)JBUI.Borders.emptyTop((int)JBUI.CurrentTheme.Popup.bodyBottomInsetNoAd()));
                            wrapper2.add((Component)panel2);
                            return wrapper2;
                        }
                        return panel2;
                    }
                }
                return renderer2.getListCellRendererComponent(list2, value, index, isSelected, cellHasFocus);
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "group";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "presentationFactory";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "place";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/actions/SettingsEntryPointAction$MyPopup";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ComboIcon
    implements Icon {
        private final Icon myFirstIcon;
        private final Icon mySecondIcon;

        private ComboIcon(@NotNull Icon firstIcon, @NotNull Icon secondIcon) {
            if (firstIcon == null) {
                ComboIcon.$$$reportNull$$$0(0);
            }
            if (secondIcon == null) {
                ComboIcon.$$$reportNull$$$0(1);
            }
            this.myFirstIcon = firstIcon;
            this.mySecondIcon = secondIcon;
        }

        @Override
        public void paintIcon(@NotNull Component component2, @NotNull Graphics g, int x, int y) {
            if (component2 == null) {
                ComboIcon.$$$reportNull$$$0(2);
            }
            if (g == null) {
                ComboIcon.$$$reportNull$$$0(3);
            }
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintButton(@NotNull ActionButton button2, @NotNull ActionButtonLook look, @NotNull Graphics g) {
            if (button2 == null) {
                ComboIcon.$$$reportNull$$$0(4);
            }
            if (look == null) {
                ComboIcon.$$$reportNull$$$0(5);
            }
            if (g == null) {
                ComboIcon.$$$reportNull$$$0(6);
            }
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                int radius = JBUI.scale((int)12);
                boolean compactMode = UISettings.getInstance().getCompactMode();
                Insets insets = button2.getInsets();
                if (compactMode) {
                    int compact = JBUI.scale((int)3);
                    insets.set(insets.top + compact, insets.left + compact, insets.bottom + compact, insets.right + compact);
                }
                Dimension size2 = button2.getSize();
                JBInsets.removeFrom((Dimension)size2, (Insets)insets);
                g2.setColor(JBUI.CurrentTheme.ManagedIde.getBadgeBackground((button2.getPopState() != 0 ? 1 : 0) != 0));
                g2.fillRoundRect(insets.left, insets.top, size2.width, size2.height, radius, radius);
                g2.setColor(JBUI.CurrentTheme.ManagedIde.BADGE_BORDER);
                g2.drawRoundRect(insets.left, insets.top, size2.width, size2.height - 1, radius, radius);
                int offset = JBUI.scale((int)(compactMode ? 3 : 6));
                int iconSize = JBUI.scale((int)20);
                int height = button2.getHeight();
                look.paintIcon(g2, button2, this.myFirstIcon, insets.left + offset + (iconSize - this.myFirstIcon.getIconWidth()) / 2, (height - this.myFirstIcon.getIconHeight()) / 2);
                look.paintIcon(g2, button2, this.mySecondIcon, insets.left + offset + iconSize + offset + (iconSize - this.mySecondIcon.getIconWidth()) / 2, (height - this.mySecondIcon.getIconHeight()) / 2);
            }
            finally {
                g2.dispose();
            }
        }

        @Override
        public int getIconWidth() {
            return JBUI.scale((int)(UISettings.getInstance().getCompactMode() ? 52 : 58));
        }

        @Override
        public int getIconHeight() {
            return JBUI.scale((int)30);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "firstIcon";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "secondIcon";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "button";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "look";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/actions/SettingsEntryPointAction$ComboIcon";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paintIcon";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paintButton";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface IconCustomizer {
        public static final ExtensionPointName<IconCustomizer> EP_NAME = new ExtensionPointName("com.intellij.settingsEntryPointIconCustomizer");

        @Nullable
        public Icon getCustomIcon(@NotNull BadgeIconSupplier var1);

        @Nullable
        default public Icon getSecondIcon() {
            return null;
        }
    }

    static final class StatusBarManager
    implements StatusBarWidgetFactory {
        StatusBarManager() {
        }

        @NotNull
        public String getId() {
            return SettingsEntryPointAction.WIDGET_ID;
        }

        @NotNull
        public String getDisplayName() {
            String string = IdeBundle.message((String)"settings.entry.point.widget.name", (Object[])new Object[0]);
            if (string == null) {
                StatusBarManager.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project2) {
            if (project2 == null) {
                StatusBarManager.$$$reportNull$$$0(1);
            }
            return SettingsEntryPointAction.isAvailableInStatusBar();
        }

        @NotNull
        public StatusBarWidget createWidget(@NotNull Project project2) {
            if (project2 == null) {
                StatusBarManager.$$$reportNull$$$0(2);
            }
            return new MyStatusBarWidget();
        }

        public boolean canBeEnabledOn(@NotNull StatusBar statusBar) {
            if (statusBar == null) {
                StatusBarManager.$$$reportNull$$$0(3);
            }
            return SettingsEntryPointAction.isAvailableInStatusBar();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/SettingsEntryPointAction$StatusBarManager";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statusBar";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/SettingsEntryPointAction$StatusBarManager";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createWidget";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "canBeEnabledOn";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    public static abstract class LastAction
    extends DumbAwareAction {
        public static final Key<JBPopup> POPUP = Key.create((String)"JBPopup");
        public static final Key<@NlsActions.ActionText String> SECOND_TEXT = Key.create((String)"SECOND_TEXT");

        protected LastAction() {
        }

        protected LastAction(@Nullable @NlsActions.ActionText String text2) {
            super(text2);
        }

        protected LastAction(@Nullable @NlsActions.ActionText String text2, @Nullable @NlsActions.ActionDescription String description, @Nullable Icon icon2) {
            super(text2, description, icon2);
        }

        @NotNull
        @NlsActions.ActionText
        public String getSecondText() {
            return "";
        }

        protected void handleMouseMove(@NotNull MouseEvent event) {
            if (event == null) {
                LastAction.$$$reportNull$$$0(0);
            }
        }

        protected void handleMouseExit(@NotNull MouseEvent event) {
            if (event == null) {
                LastAction.$$$reportNull$$$0(1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/ide/actions/SettingsEntryPointAction$LastAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleMouseMove";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleMouseExit";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyStatusBarWidget
    implements StatusBarWidget,
    StatusBarWidget.IconPresentation {
        private StatusBar myStatusBar;

        private MyStatusBarWidget() {
        }

        @NotNull
        public String ID() {
            return SettingsEntryPointAction.WIDGET_ID;
        }

        public void install(@NotNull StatusBar statusBar) {
            if (statusBar == null) {
                MyStatusBarWidget.$$$reportNull$$$0(0);
            }
            this.myStatusBar = statusBar;
        }

        @NotNull
        public StatusBarWidget.WidgetPresentation getPresentation() {
            MyStatusBarWidget myStatusBarWidget = this;
            if (myStatusBarWidget == null) {
                MyStatusBarWidget.$$$reportNull$$$0(1);
            }
            return myStatusBarWidget;
        }

        @NlsContexts.Tooltip
        @NotNull
        public String getTooltipText() {
            String string = SettingsEntryPointAction.getActionTooltip();
            if (string == null) {
                MyStatusBarWidget.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public Consumer<MouseEvent> getClickConsumer() {
            Consumer consumer = event -> {
                SettingsEntryPointAction.resetActionIcon();
                this.myStatusBar.updateWidget(SettingsEntryPointAction.WIDGET_ID);
                final Component component2 = event.getComponent();
                final ListPopup popup2 = SettingsEntryPointAction.createMainPopup((ActionGroup)ActionManager.getInstance().getAction("SettingsEntryPoint"), DataManager.getInstance().getDataContext(component2), null);
                popup2.addListener(new JBPopupListener(){

                    public void beforeShown(@NotNull LightweightWindowEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        Point location = component2.getLocationOnScreen();
                        Dimension size2 = popup2.getSize();
                        popup2.setLocation(new Point(location.x + component2.getWidth() - size2.width, location.y - size2.height));
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/actions/SettingsEntryPointAction$MyStatusBarWidget$1", "beforeShown"));
                    }
                });
                popup2.show(component2);
            };
            if (consumer == null) {
                MyStatusBarWidget.$$$reportNull$$$0(3);
            }
            return consumer;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon2 = SettingsEntryPointAction.getActionIcon();
            if (icon2 == null) {
                MyStatusBarWidget.$$$reportNull$$$0(4);
            }
            return icon2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statusBar";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/SettingsEntryPointAction$MyStatusBarWidget";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/SettingsEntryPointAction$MyStatusBarWidget";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTooltipText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClickConsumer";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "install";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    public static interface NoDots {
    }
}

