/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.ide.actions.DistractionFreeModeController;
import com.intellij.ide.actions.TogglePresentationModeAction;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.ToolbarSettings;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsState;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.RegistryManager;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.ui.mac.MacFullScreenControlsManager;
import org.jetbrains.annotations.NotNull;

public class ToggleDistractionFreeModeAction
extends DumbAwareAction
implements LightEditCompatible,
ActionRemoteBehaviorSpecification.Frontend {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleDistractionFreeModeAction.$$$reportNull$$$0(0);
        }
        Presentation presentation2 = e.getPresentation();
        if (e.getProject() == null) {
            presentation2.setEnabled(false);
            return;
        }
        String text2 = ActionsBundle.message((String)(DistractionFreeModeController.isDistractionFreeModeEnabled() ? "action.ToggleDistractionFreeMode.exit" : "action.ToggleDistractionFreeMode.enter"), (Object[])new Object[0]);
        presentation2.setText(text2);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ToggleDistractionFreeModeAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        RegistryValue value;
        if (e == null) {
            ToggleDistractionFreeModeAction.$$$reportNull$$$0(2);
        }
        boolean enter = !(value = RegistryManager.getInstance().get("editor.distraction.free.mode")).asBoolean();
        value.setValue(enter);
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        PropertiesComponent.getInstance().setValue("DISTRACTION.MODE.ENTER.VALUE", String.valueOf(enter));
        if (SystemInfo.isMac) {
            MacFullScreenControlsManager.INSTANCE.updateForDistractionFreeMode(enter);
        }
        ToggleDistractionFreeModeAction.applyAndSave(PropertiesComponent.getInstance(), UISettings.getInstance(), ToolbarSettings.getInstance(), EditorSettingsExternalizable.getInstance().getOptions(), DaemonCodeAnalyzerSettings.getInstance(), enter ? "BEFORE.DISTRACTION.MODE." : "AFTER.DISTRACTION.MODE.", enter ? "AFTER.DISTRACTION.MODE." : "BEFORE.DISTRACTION.MODE.", !enter);
        if (enter) {
            TogglePresentationModeAction.storeToolWindows(project2, false);
        }
        UISettings uiSettings = UISettings.getInstance();
        uiSettings.fireUISettingsChanged();
        LafManager.getInstance().updateUI();
        EditorUtil.reinitSettings();
        DaemonCodeAnalyzer.getInstance((Project)project2).settingsChanged();
        EditorFactory.getInstance().refreshAllEditors();
        if (!enter) {
            TogglePresentationModeAction.restoreToolWindows(project2, false);
        }
    }

    private static void applyAndSave(@NotNull PropertiesComponent p, @NotNull UISettings uiSettings, @NotNull ToolbarSettings toolbarSettings, @NotNull EditorSettingsExternalizable.OptionSet eo, @NotNull DaemonCodeAnalyzerSettings ds, String before, String after, boolean value) {
        if (p == null) {
            ToggleDistractionFreeModeAction.$$$reportNull$$$0(3);
        }
        if (uiSettings == null) {
            ToggleDistractionFreeModeAction.$$$reportNull$$$0(4);
        }
        if (toolbarSettings == null) {
            ToggleDistractionFreeModeAction.$$$reportNull$$$0(5);
        }
        if (eo == null) {
            ToggleDistractionFreeModeAction.$$$reportNull$$$0(6);
        }
        if (ds == null) {
            ToggleDistractionFreeModeAction.$$$reportNull$$$0(7);
        }
        UISettingsState ui = uiSettings.getState();
        p.setValue(before + "SHOW_STATUS_BAR", String.valueOf(ui.getShowStatusBar()));
        ui.setShowStatusBar(p.getBoolean(after + "SHOW_STATUS_BAR", value));
        p.setValue(before + "SHOW_MAIN_TOOLBAR", String.valueOf(uiSettings.getShowMainToolbar()));
        uiSettings.setShowMainToolbar(p.getBoolean(after + "SHOW_MAIN_TOOLBAR", value));
        p.setValue(before + "SHOW_NAVIGATION_BAR", String.valueOf(uiSettings.getShowNavigationBar()));
        uiSettings.setShowNavigationBar(p.getBoolean(after + "SHOW_NAVIGATION_BAR", value));
        p.setValue(before + "SHOW_NEW_MAIN_TOOLBAR", String.valueOf(toolbarSettings.isVisible()));
        toolbarSettings.setVisible(p.getBoolean(after + "SHOW_NEW_MAIN_TOOLBAR", value));
        p.setValue(before + "IS_FOLDING_OUTLINE_SHOWN", String.valueOf(eo.IS_FOLDING_OUTLINE_SHOWN));
        eo.IS_FOLDING_OUTLINE_SHOWN = p.getBoolean(after + "IS_FOLDING_OUTLINE_SHOWN", value);
        p.setValue(before + "IS_FOLDING_OUTLINE_SHOWN_ONLY_ON_HOVER", String.valueOf(eo.IS_FOLDING_OUTLINE_SHOWN_ONLY_ON_HOVER));
        eo.IS_FOLDING_OUTLINE_SHOWN_ONLY_ON_HOVER = p.getBoolean(after + "IS_FOLDING_OUTLINE_SHOWN_ONLY_ON_HOVER", value);
        p.setValue(before + "IS_WHITESPACES_SHOWN", String.valueOf(eo.IS_WHITESPACES_SHOWN));
        eo.IS_WHITESPACES_SHOWN = p.getBoolean(after + "IS_WHITESPACES_SHOWN", value);
        p.setValue(before + "ARE_LINE_NUMBERS_SHOWN", String.valueOf(eo.ARE_LINE_NUMBERS_SHOWN));
        eo.ARE_LINE_NUMBERS_SHOWN = p.getBoolean(after + "ARE_LINE_NUMBERS_SHOWN", value);
        p.setValue(before + "ARE_GUTTER_ICONS_SHOWN", String.valueOf(eo.ARE_GUTTER_ICONS_SHOWN));
        eo.ARE_GUTTER_ICONS_SHOWN = p.getBoolean(after + "ARE_GUTTER_ICONS_SHOWN", value);
        p.setValue(before + "IS_RIGHT_MARGIN_SHOWN", String.valueOf(eo.IS_RIGHT_MARGIN_SHOWN));
        eo.IS_RIGHT_MARGIN_SHOWN = p.getBoolean(after + "IS_RIGHT_MARGIN_SHOWN", value);
        p.setValue(before + "IS_INDENT_GUIDES_SHOWN", String.valueOf(eo.IS_INDENT_GUIDES_SHOWN));
        eo.IS_INDENT_GUIDES_SHOWN = p.getBoolean(after + "IS_INDENT_GUIDES_SHOWN", value);
        p.setValue(before + "SHOW_BREADCRUMBS", String.valueOf(eo.SHOW_BREADCRUMBS));
        eo.SHOW_BREADCRUMBS = p.getBoolean(after + "SHOW_BREADCRUMBS", value);
        p.setValue(before + "SHOW_METHOD_SEPARATORS", String.valueOf(ds.SHOW_METHOD_SEPARATORS));
        ds.SHOW_METHOD_SEPARATORS = p.getBoolean(after + "SHOW_METHOD_SEPARATORS", value);
        p.setValue(before + "HIDE_TOOL_STRIPES", String.valueOf(ui.getHideToolStripes()));
        ui.setHideToolStripes(p.getBoolean(after + "HIDE_TOOL_STRIPES", !value));
        p.setValue(before + "EDITOR_TAB_PLACEMENT", String.valueOf(ui.getEditorTabPlacement()));
        ui.setEditorTabPlacement(p.getInt(after + "EDITOR_TAB_PLACEMENT", value ? 1 : 0));
    }

    @Deprecated
    public static boolean isDistractionFreeModeEnabled() {
        return DistractionFreeModeController.isDistractionFreeModeEnabled();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/ToggleDistractionFreeModeAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolbarSettings";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eo";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/ToggleDistractionFreeModeAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyAndSave";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

