/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.newui.EventHandler;
import com.intellij.ide.plugins.newui.PluginsGroupComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.AsyncProcessIcon;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class PluginsGroupComponentWithProgress
extends PluginsGroupComponent {
    private static final Logger LOG = Logger.getInstance(PluginsGroupComponentWithProgress.class);
    private AsyncProcessIcon myLoadingIcon;
    @Nullable
    private Runnable myOnBecomingVisibleCallback;

    public PluginsGroupComponentWithProgress(@NotNull EventHandler eventHandler) {
        if (eventHandler == null) {
            PluginsGroupComponentWithProgress.$$$reportNull$$$0(0);
        }
        super(eventHandler);
        this.myLoadingIcon = new AsyncProcessIcon.BigCentered(IdeBundle.message((String)"progress.text.loading", (Object[])new Object[0]));
        this.myLoadingIcon.setOpaque(false);
        this.myLoadingIcon.setPaintPassiveIcon(false);
        this.add((Component)this.myLoadingIcon);
        this.myLoadingIcon.resume();
    }

    public void doLayout() {
        super.doLayout();
        this.updateIconLocation();
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.updateIconLocation();
    }

    private void updateIconLocation() {
        if (this.myLoadingIcon != null && this.myLoadingIcon.isVisible()) {
            this.myLoadingIcon.updateLocation((JComponent)((Object)this));
        }
    }

    public void showLoadingIcon() {
        LOG.debug("Marketplace tab: loading started");
        if (this.myLoadingIcon != null) {
            this.myLoadingIcon.setVisible(true);
            this.myLoadingIcon.resume();
            this.fullRepaint();
        }
    }

    public void hideLoadingIcon() {
        LOG.debug("Marketplace tab: loading stopped");
        if (this.myLoadingIcon != null) {
            this.myLoadingIcon.suspend();
            this.myLoadingIcon.setVisible(false);
            this.fullRepaint();
        }
    }

    private void fullRepaint() {
        this.doLayout();
        this.revalidate();
        this.repaint();
    }

    public void dispose() {
        if (this.myLoadingIcon != null) {
            this.remove((Component)this.myLoadingIcon);
            Disposer.dispose((Disposable)this.myLoadingIcon);
            this.myLoadingIcon = null;
        }
    }

    @Override
    public void clear() {
        super.clear();
        if (this.myLoadingIcon != null) {
            this.add((Component)this.myLoadingIcon);
        }
    }

    public void setOnBecomingVisibleCallback(@NotNull Runnable onVisibilityChangeCallbackOnce) {
        if (onVisibilityChangeCallbackOnce == null) {
            PluginsGroupComponentWithProgress.$$$reportNull$$$0(1);
        }
        this.myOnBecomingVisibleCallback = onVisibilityChangeCallbackOnce;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.myOnBecomingVisibleCallback != null) {
            Runnable runnable2 = this.myOnBecomingVisibleCallback;
            this.myOnBecomingVisibleCallback = null;
            runnable2.run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onVisibilityChangeCallbackOnce";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/plugins/newui/PluginsGroupComponentWithProgress";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setOnBecomingVisibleCallback";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

