/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.util.GotoLineNumberDialog;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.impl.RelativeLineHelper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.PatternUtil;
import java.awt.Component;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class EditorGotoLineNumberDialog
extends GotoLineNumberDialog {
    private final Editor myEditor;
    private static final Pattern relativeNumberPattern = PatternUtil.compileSafe((String)"\\s*([+-]\\d+)\\s*", null);

    public EditorGotoLineNumberDialog(Project project2, Editor editor2) {
        super(project2);
        this.myEditor = editor2;
        this.init();
    }

    @Override
    protected GotoLineNumberDialog.Coordinates getCoordinates() {
        GotoLineNumberDialog.Coordinates c = super.getCoordinates();
        if (c != null) {
            return c;
        }
        Matcher relativeMatcher = relativeNumberPattern.matcher(this.getText());
        if (relativeMatcher.matches()) {
            int caretLine = this.myEditor.getCaretModel().getLogicalPosition().line;
            int relativeLine = Integer.parseInt(relativeMatcher.group(1));
            int logicalLine = RelativeLineHelper.INSTANCE.getLogicalLine(this.myEditor, caretLine, relativeLine);
            int linesTotal = this.myEditor.getDocument().getLineCount();
            return new GotoLineNumberDialog.Coordinates(Math.max(0, Math.min(logicalLine, linesTotal - 1)), 0);
        }
        return null;
    }

    protected void doOKAction() {
        GotoLineNumberDialog.Coordinates coordinates = this.getCoordinates();
        if (coordinates == null) {
            return;
        }
        LogicalPosition position2 = new LogicalPosition(coordinates.row(), coordinates.column());
        this.myEditor.getCaretModel().removeSecondaryCarets();
        this.myEditor.getCaretModel().moveToLogicalPosition(position2);
        this.myEditor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        this.myEditor.getSelectionModel().removeSelection();
        IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myEditor.getContentComponent(), true);
        super.doOKAction();
    }

    @Override
    protected int getLine() {
        return this.myEditor.getCaretModel().getLogicalPosition().line;
    }

    @Override
    protected int getColumn() {
        return this.myEditor.getCaretModel().getLogicalPosition().column;
    }

    @Override
    protected int getOffset() {
        return this.myEditor.getCaretModel().getOffset();
    }

    @Override
    protected int getMaxOffset() {
        return this.myEditor.getDocument().getTextLength();
    }

    @Override
    protected int coordinatesToOffset(@NotNull GotoLineNumberDialog.Coordinates coordinates) {
        if (coordinates == null) {
            EditorGotoLineNumberDialog.$$$reportNull$$$0(0);
        }
        LogicalPosition position2 = new LogicalPosition(coordinates.row(), coordinates.column());
        return this.myEditor.logicalPositionToOffset(position2);
    }

    @Override
    @NotNull
    protected GotoLineNumberDialog.Coordinates offsetToCoordinates(int offset) {
        LogicalPosition position2 = this.myEditor.offsetToLogicalPosition(offset);
        return new GotoLineNumberDialog.Coordinates(position2.line, position2.column);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coordinates", "com/intellij/ide/util/EditorGotoLineNumberDialog", "coordinatesToOffset"));
    }
}

