/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FinishMarkAction
extends BasicUndoableAction {
    @Nullable
    private final StartMarkAction startMark;
    private @NlsContexts.Command @Nullable String commandName;
    private boolean isGlobal;

    public static void finish(Project project2, Editor editor2, @Nullable StartMarkAction startAction) {
        if (startAction != null) {
            DocumentReference reference = DocumentReferenceManager.getInstance().create(editor2.getDocument());
            FinishMarkAction finishMark = new FinishMarkAction(reference, startAction);
            CommandProcessor.getInstance().executeCommand(project2, () -> {
                UndoManager.getInstance((Project)project2).undoableActionPerformed((UndoableAction)finishMark);
                StartMarkAction.markFinished(editor2);
            }, IdeBundle.message((String)"command.finish", (Object[])new Object[0]), null);
        }
    }

    FinishMarkAction(@NotNull DocumentReference reference, boolean isGlobal) {
        if (reference == null) {
            FinishMarkAction.$$$reportNull$$$0(0);
        }
        this(reference, null);
        if (isGlobal) {
            this.markGlobal(null);
        }
    }

    private FinishMarkAction(@NotNull DocumentReference reference, @Nullable StartMarkAction startMark) {
        if (reference == null) {
            FinishMarkAction.$$$reportNull$$$0(1);
        }
        super(new DocumentReference[]{reference});
        this.commandName = null;
        this.isGlobal = false;
        this.startMark = startMark;
    }

    public void undo() {
    }

    public void redo() {
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public DocumentReference @NotNull [] getAffectedDocuments() {
        DocumentReference[] documentReferenceArray = Objects.requireNonNull(super.getAffectedDocuments(), "document must be set during instance creation");
        if (documentReferenceArray == null) {
            FinishMarkAction.$$$reportNull$$$0(2);
        }
        return documentReferenceArray;
    }

    void markGlobal(@NlsContexts.Command @Nullable String commandName) {
        if (this.startMark != null) {
            this.startMark.setGlobal(true);
            this.startMark.setCommandName(commandName);
        }
        this.isGlobal = true;
        this.commandName = commandName;
    }

    @NlsContexts.Command
    @Nullable
    String getCommandName() {
        return this.commandName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/command/impl/FinishMarkAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/command/impl/FinishMarkAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedDocuments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

