/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.KillRingUtil;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import com.intellij.openapi.editor.textarea.TextComponentEditor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class KillRingSaveAction
extends TextComponentEditorAction {
    public KillRingSaveAction() {
        super(new Handler(false));
    }

    static final class Handler
    extends EditorActionHandler {
        private final boolean myRemove;

        Handler(boolean remove2) {
            this.myRemove = remove2;
        }

        public void doExecute(@NotNull Editor editor2, @Nullable Caret caret, DataContext dataContext2) {
            int end;
            SelectionModel selectionModel;
            if (editor2 == null) {
                Handler.$$$reportNull$$$0(0);
            }
            if (!(selectionModel = editor2.getSelectionModel()).hasSelection()) {
                return;
            }
            int start2 = selectionModel.getSelectionStart();
            if (start2 >= (end = selectionModel.getSelectionEnd())) {
                return;
            }
            KillRingUtil.copyToKillRing(editor2, start2, end, false);
            if (this.myRemove) {
                Runnable runnable2 = () -> editor2.getDocument().deleteString(start2, end);
                if (editor2 instanceof TextComponentEditor) {
                    runnable2.run();
                } else {
                    ApplicationManager.getApplication().runWriteAction(runnable2);
                }
            }
        }

        protected boolean isEnabledForCaret(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext2) {
            if (editor2 == null) {
                Handler.$$$reportNull$$$0(1);
            }
            if (caret == null) {
                Handler.$$$reportNull$$$0(2);
            }
            return !this.myRemove || editor2.getDocument().isWritable();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caret";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/actions/KillRingSaveAction$Handler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doExecute";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledForCaret";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

