/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.ex.SoftWrapModelEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.InlayModelImpl;
import com.intellij.openapi.editor.impl.view.EditorView;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VisualLinesIterator {
    private static final int UNSET = -1;
    private final EditorView myView;
    private final Document myDocument;
    private final int myLineHeight;
    private final FoldingModelEx myFoldingModel;
    private final FoldRegion[] myFoldRegions;
    private final InlayModel myInlayModel;
    private final List<Inlay<?>> myInlaysAbove;
    private final List<Inlay<?>> myInlaysBelow;
    private boolean myInlaysSet;
    private final SoftWrapModelEx mySoftWrapModel;
    private final List<? extends SoftWrap> mySoftWraps;
    @NotNull
    private Location myLocation;
    private Location myNextLocation;
    private int y;

    public VisualLinesIterator(@NotNull EditorImpl editor2, int startVisualLine) {
        if (editor2 == null) {
            VisualLinesIterator.$$$reportNull$$$0(0);
        }
        this(editor2.getView(), startVisualLine);
    }

    @ApiStatus.Internal
    public VisualLinesIterator(@NotNull EditorView view2, int startVisualLine) {
        if (view2 == null) {
            VisualLinesIterator.$$$reportNull$$$0(1);
        }
        this.myInlaysAbove = new ArrayList();
        this.myInlaysBelow = new ArrayList();
        this.y = -1;
        this.myView = view2;
        this.myDocument = this.myView.getDocument();
        this.myInlayModel = this.myView.getInlayModel();
        this.myFoldingModel = this.myView.getFoldingModel();
        this.mySoftWrapModel = this.myView.getSoftWrapModel();
        FoldRegion[] regions = this.myFoldingModel.fetchTopLevel();
        this.myFoldRegions = regions == null ? FoldRegion.EMPTY_ARRAY : regions;
        this.mySoftWraps = this.mySoftWrapModel.getRegisteredSoftWraps();
        this.myLineHeight = view2.getLineHeight();
        this.myLocation = new Location(startVisualLine);
    }

    public boolean atEnd() {
        return this.myLocation.atEnd();
    }

    public void advance() {
        this.checkEnd();
        if (this.y != -1) {
            this.y += EditorUtil.getTotalInlaysHeight(this.getBlockInlaysBelow());
            this.y += this.getLineHeight();
        }
        if (this.myNextLocation == null) {
            this.myLocation.advance();
        } else {
            this.myLocation = this.myNextLocation;
            this.myNextLocation = null;
        }
        this.myInlaysSet = false;
        if (this.y != -1 && !this.atEnd()) {
            this.y += EditorUtil.getTotalInlaysHeight(this.getBlockInlaysAbove());
        }
    }

    public int getVisualLine() {
        this.checkEnd();
        return this.myLocation.visualLine;
    }

    public int getVisualLineStartOffset() {
        this.checkEnd();
        return this.myLocation.offset;
    }

    public int getVisualLineEndOffset() {
        this.checkEnd();
        this.setNextLocation();
        return this.myNextLocation.atEnd() ? this.myDocument.getTextLength() : (this.myNextLocation.softWrap == this.myLocation.softWrap ? this.myDocument.getLineEndOffset(this.myNextLocation.logicalLine - 2) : this.myNextLocation.offset);
    }

    public int getDisplayedLogicalLine() {
        FoldRegion foldRegion;
        this.checkEnd();
        int foldIndex = this.myLocation.foldRegion;
        if (foldIndex < this.myFoldRegions.length && (foldRegion = this.myFoldRegions[foldIndex]).getPlaceholderText().isEmpty() && foldRegion.getStartOffset() == this.myLocation.offset) {
            return this.myDocument.getLineNumber(foldRegion.getEndOffset());
        }
        return this.myLocation.logicalLine - 1;
    }

    public int getStartLogicalLine() {
        this.checkEnd();
        return this.myLocation.logicalLine - 1;
    }

    public int getEndLogicalLine() {
        this.checkEnd();
        this.setNextLocation();
        return this.myNextLocation.atEnd() ? Math.max(0, this.myDocument.getLineCount() - 1) : this.myNextLocation.logicalLine - (this.myNextLocation.softWrap == this.myLocation.softWrap ? 2 : 1);
    }

    public int getStartOrPrevWrapIndex() {
        this.checkEnd();
        return this.myLocation.softWrap - 1;
    }

    public int getStartFoldingIndex() {
        this.checkEnd();
        return this.myLocation.foldRegion;
    }

    public int getY() {
        this.checkEnd();
        if (this.y == -1) {
            this.y = this.myView.visualLineToY(this.myLocation.visualLine);
        }
        return this.y;
    }

    public boolean startsWithSoftWrap() {
        this.checkEnd();
        return this.myLocation.softWrap > 0 && this.myLocation.softWrap <= this.mySoftWraps.size() && this.mySoftWraps.get(this.myLocation.softWrap - 1).getStart() == this.myLocation.offset;
    }

    public boolean endsWithSoftWrap() {
        this.checkEnd();
        return this.myLocation.softWrap < this.mySoftWraps.size() && this.mySoftWraps.get(this.myLocation.softWrap).getStart() == this.getVisualLineEndOffset();
    }

    public List<Inlay<?>> getBlockInlaysAbove() {
        this.checkEnd();
        this.setInlays();
        return this.myInlaysAbove;
    }

    public List<Inlay<?>> getBlockInlaysBelow() {
        this.checkEnd();
        this.setInlays();
        return this.myInlaysBelow;
    }

    @Nullable
    public CustomFoldRegion getCustomFoldRegion() {
        FoldRegion foldRegion;
        this.checkEnd();
        int foldIndex = this.myLocation.foldRegion;
        if (foldIndex < this.myFoldRegions.length && (foldRegion = this.myFoldRegions[foldIndex]) instanceof CustomFoldRegion && foldRegion.getStartOffset() == this.myLocation.offset) {
            return (CustomFoldRegion)foldRegion;
        }
        return null;
    }

    public boolean isCustomFoldRegionLine() {
        return this.getCustomFoldRegion() != null;
    }

    public int getLineHeight() {
        CustomFoldRegion region = this.getCustomFoldRegion();
        return region == null ? this.myLineHeight : region.getHeightInPixels();
    }

    private void checkEnd() {
        if (this.atEnd()) {
            throw new IllegalStateException("Iteration finished");
        }
    }

    private void setNextLocation() {
        if (this.myNextLocation == null) {
            this.myNextLocation = this.myLocation.clone();
            this.myNextLocation.advance();
        }
    }

    private void setInlays() {
        if (this.myInlaysSet) {
            return;
        }
        this.myInlaysSet = true;
        this.myInlaysAbove.clear();
        this.myInlaysBelow.clear();
        this.setNextLocation();
        List inlays = this.myInlayModel.getBlockElementsInRange(this.myLocation.offset, this.myNextLocation.atEnd() ? this.myDocument.getTextLength() : this.myNextLocation.offset - 1);
        for (Inlay inlay : inlays) {
            int foldIndex;
            int inlayOffset = inlay.getOffset() - (inlay.isRelatedToPrecedingText() ? 0 : 1);
            for (foldIndex = this.myLocation.foldRegion; foldIndex < this.myFoldRegions.length && this.myFoldRegions[foldIndex].getEndOffset() <= inlayOffset; ++foldIndex) {
            }
            if (foldIndex < this.myFoldRegions.length && this.myFoldRegions[foldIndex].getStartOffset() <= inlayOffset && !InlayModelImpl.showWhenFolded(inlay)) continue;
            (inlay.getPlacement() == Inlay.Placement.ABOVE_LINE ? this.myInlaysAbove : this.myInlaysBelow).add(inlay);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "view";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/editor/impl/view/VisualLinesIterator";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class Location
    implements Cloneable {
        private int visualLine;
        private int offset;
        private int logicalLine = 1;
        private int foldRegion;
        private int softWrap;

        private Location(int startVisualLine) {
            if (startVisualLine < 0 || startVisualLine >= VisualLinesIterator.this.myView.getVisibleLineCount()) {
                this.offset = -1;
            } else if (startVisualLine > 0) {
                this.visualLine = startVisualLine;
                this.offset = VisualLinesIterator.this.myView.visualLineToOffset(startVisualLine);
                this.logicalLine = VisualLinesIterator.this.myDocument.getLineNumber(this.offset) + 1;
                this.softWrap = VisualLinesIterator.this.mySoftWrapModel.getSoftWrapIndex(this.offset) + 1;
                if (this.softWrap <= 0) {
                    this.softWrap = -this.softWrap;
                }
                this.foldRegion = VisualLinesIterator.this.myFoldingModel.getLastCollapsedRegionBefore(this.offset) + 1;
            }
        }

        private void advance() {
            int nextWrapOffset = this.getNextSoftWrapOffset();
            this.offset = this.getNextVisualLineStartOffset(nextWrapOffset);
            if (this.offset == Integer.MAX_VALUE) {
                this.offset = -1;
            } else if (this.offset == nextWrapOffset) {
                ++this.softWrap;
            }
            ++this.visualLine;
            while (this.foldRegion < VisualLinesIterator.this.myFoldRegions.length && VisualLinesIterator.this.myFoldRegions[this.foldRegion].getStartOffset() < this.offset) {
                ++this.foldRegion;
            }
        }

        private int getNextSoftWrapOffset() {
            return this.softWrap < VisualLinesIterator.this.mySoftWraps.size() ? VisualLinesIterator.this.mySoftWraps.get(this.softWrap).getStart() : Integer.MAX_VALUE;
        }

        private int getNextVisualLineStartOffset(int nextWrapOffset) {
            while (this.logicalLine < VisualLinesIterator.this.myDocument.getLineCount()) {
                int lineStartOffset = VisualLinesIterator.this.myDocument.getLineStartOffset(this.logicalLine);
                if (lineStartOffset > nextWrapOffset) {
                    return nextWrapOffset;
                }
                ++this.logicalLine;
                if (this.isCollapsed(lineStartOffset)) continue;
                return lineStartOffset;
            }
            return nextWrapOffset;
        }

        private boolean isCollapsed(int offset) {
            while (this.foldRegion < VisualLinesIterator.this.myFoldRegions.length) {
                FoldRegion region = VisualLinesIterator.this.myFoldRegions[this.foldRegion];
                if (offset <= region.getStartOffset()) {
                    return false;
                }
                if (offset <= region.getEndOffset()) {
                    return true;
                }
                ++this.foldRegion;
            }
            return false;
        }

        private boolean atEnd() {
            return this.offset == -1;
        }

        protected Location clone() {
            try {
                return (Location)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

