/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.DynamicBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.UnlockOption;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.readOnlyHandler.FileListRenderer;
import com.intellij.openapi.vcs.readOnlyHandler.ReadOnlyStatusDialog;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class NonProjectFileWritingAccessDialog
extends DialogWrapper {
    private JPanel myPanel;
    private JLabel myListTitle;
    private JList<VirtualFile> myFileList;
    private JRadioButton myUnlockOneButton;
    private JRadioButton myUnlockDirButton;
    private JRadioButton myUnlockAllButton;

    NonProjectFileWritingAccessDialog(@NotNull Project project2, @NotNull List<? extends VirtualFile> nonProjectFiles) {
        if (project2 == null) {
            NonProjectFileWritingAccessDialog.$$$reportNull$$$0(0);
        }
        if (nonProjectFiles == null) {
            NonProjectFileWritingAccessDialog.$$$reportNull$$$0(1);
        }
        super(project2);
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(IdeBundle.message((String)"dialog.title.non.project.files.protection", (Object[])objectArray));
        this.myFileList.setPreferredSize(ReadOnlyStatusDialog.getDialogPreferredSize());
        this.myFileList.setCellRenderer(new FileListRenderer());
        this.myFileList.setModel((ListModel<VirtualFile>)new CollectionListModel(nonProjectFiles));
        boolean dirsOnly = nonProjectFiles.stream().allMatch(VirtualFile::isDirectory);
        int size2 = nonProjectFiles.size();
        String listTitle = dirsOnly ? IdeBundle.message((String)"this.directory.does.not.belong.to.the.project", (Object[])new Object[]{size2}) : IdeBundle.message((String)"this.file.does.not.belong.to.the.project", (Object[])new Object[]{size2});
        this.myListTitle.setText(listTitle);
        this.myUnlockOneButton.setSelected(true);
        String text2 = dirsOnly ? IdeBundle.message((String)"button.i.want.to.edit.choice.this.directory.anyway", (Object[])new Object[]{size2}) : IdeBundle.message((String)"button.i.want.to.edit.choice.this.file.anyway", (Object[])new Object[]{size2});
        this.setTextAndMnemonicAndListeners(this.myUnlockOneButton, text2, "edit");
        int dirsSize = ContainerUtil.map2Set(nonProjectFiles, VirtualFile::getParent).size();
        String dirsText = IdeBundle.message((String)"button.i.want.to.edit.all.files.in.choice.this.directory", (Object[])new Object[]{dirsSize});
        this.setTextAndMnemonicAndListeners(this.myUnlockDirButton, dirsText, "dir");
        this.setTextAndMnemonicAndListeners(this.myUnlockAllButton, IdeBundle.message((String)"button.i.want.to.edit.any.non.project.file.in.current.session", (Object[])new Object[0]), "any");
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.getRootPane().registerKeyboardAction(e -> this.doOKAction(), KeyStroke.getKeyStroke(10, 128), 1);
            this.getRootPane().registerKeyboardAction(e -> this.doOKAction(), KeyStroke.getKeyStroke(10, 256), 1);
        }
        this.init();
    }

    private void setTextAndMnemonicAndListeners(JRadioButton button2, @NlsContexts.RadioButton String text2, String mnemonic) {
        button2.setText(text2);
        button2.setMnemonic(mnemonic.charAt(0));
        button2.setDisplayedMnemonicIndex(button2.getText().indexOf(mnemonic));
        Runnable setDefaultButton = () -> {
            JRootPane rootPane = button2.getRootPane();
            if (rootPane != null) {
                rootPane.setDefaultButton(this.getButton(this.getOKAction()));
            }
        };
        button2.addActionListener(e -> setDefaultButton.run());
        button2.addItemListener(e -> setDefaultButton.run());
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myUnlockOneButton;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @NotNull
    public UnlockOption getUnlockOption() {
        if (this.myUnlockAllButton.isSelected()) {
            UnlockOption unlockOption = UnlockOption.UNLOCK_ALL;
            if (unlockOption == null) {
                NonProjectFileWritingAccessDialog.$$$reportNull$$$0(2);
            }
            return unlockOption;
        }
        if (this.myUnlockDirButton.isSelected()) {
            UnlockOption unlockOption = UnlockOption.UNLOCK_DIR;
            if (unlockOption == null) {
                NonProjectFileWritingAccessDialog.$$$reportNull$$$0(3);
            }
            return unlockOption;
        }
        UnlockOption unlockOption = UnlockOption.UNLOCK;
        if (unlockOption == null) {
            NonProjectFileWritingAccessDialog.$$$reportNull$$$0(4);
        }
        return unlockOption;
    }

    protected String getHelpId() {
        return "Non-Project_Files_Access_Dialog";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nonProjectFiles";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessDialog";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnlockOption";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBList jBList;
        JLabel jLabel;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 2, 1, 3, 1, null, null, null));
        this.myUnlockOneButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setSelected(false);
        this.$$$loadButtonText$$$(jRadioButton3, DynamicBundle.getBundle((String)"messages/IdeBundle", NonProjectFileWritingAccessDialog.class).getString("radio.button.unlock.one"));
        jPanel2.add((Component)jRadioButton3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 1));
        this.myUnlockAllButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/IdeBundle", NonProjectFileWritingAccessDialog.class).getString("radio.button.unlock.all"));
        jPanel2.add((Component)jRadioButton2, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null, 1));
        this.myUnlockDirButton = jRadioButton = new JRadioButton();
        jRadioButton.setSelected(false);
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/IdeBundle", NonProjectFileWritingAccessDialog.class).getString("radio.button.unlock.dir"));
        jPanel2.add((Component)jRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null, 1));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/IdeBundle", NonProjectFileWritingAccessDialog.class).getString("label.i.want.to.edit.choice"));
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myListTitle = jLabel = new JLabel();
        jLabel.setText("title");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myFileList = jBList = new JBList();
        jBScrollPane.setViewportView((Component)jBList);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

