/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl.pluginsAdvertisement;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeature;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="UnknownFeatures", storages={@Storage(value="$WORKSPACE_FILE$")})
@Service(value={Service.Level.PROJECT})
@ApiStatus.Internal
public final class UnknownFeaturesCollector
implements PersistentStateComponent<Element> {
    @NonNls
    private static final String FEATURE_ID = "featureType";
    @NonNls
    private static final String IMPLEMENTATION_NAME = "implementationName";
    private final Set<UnknownFeature> myUnknownFeatures = ConcurrentCollectionFactory.createConcurrentSet();
    private final Set<UnknownFeature> myIgnoredUnknownFeatures = new HashSet<UnknownFeature>();

    @NotNull
    public static UnknownFeaturesCollector getInstance(@NotNull Project project2) {
        if (project2 == null) {
            UnknownFeaturesCollector.$$$reportNull$$$0(0);
        }
        UnknownFeaturesCollector unknownFeaturesCollector = (UnknownFeaturesCollector)project2.getService(UnknownFeaturesCollector.class);
        if (unknownFeaturesCollector == null) {
            UnknownFeaturesCollector.$$$reportNull$$$0(1);
        }
        return unknownFeaturesCollector;
    }

    public boolean registerUnknownFeature(@NotNull UnknownFeature feature) {
        if (feature == null) {
            UnknownFeaturesCollector.$$$reportNull$$$0(2);
        }
        return !this.isIgnored(feature) && this.myUnknownFeatures.add(feature);
    }

    public boolean unregisterUnknownFeature(@NotNull UnknownFeature feature) {
        if (feature == null) {
            UnknownFeaturesCollector.$$$reportNull$$$0(3);
        }
        return this.myUnknownFeatures.remove(feature);
    }

    public boolean isIgnored(@NotNull UnknownFeature feature) {
        if (feature == null) {
            UnknownFeaturesCollector.$$$reportNull$$$0(4);
        }
        return this.myIgnoredUnknownFeatures.contains(feature);
    }

    public void ignoreFeature(@NotNull UnknownFeature feature) {
        if (feature == null) {
            UnknownFeaturesCollector.$$$reportNull$$$0(5);
        }
        this.myIgnoredUnknownFeatures.add(feature);
    }

    @NotNull
    public Set<UnknownFeature> getUnknownFeatures() {
        Set<UnknownFeature> set = Collections.unmodifiableSet(this.myUnknownFeatures);
        if (set == null) {
            UnknownFeaturesCollector.$$$reportNull$$$0(6);
        }
        return set;
    }

    @NotNull
    public Set<UnknownFeature> getUnknownFeaturesOfType(@NotNull @NonNls String featureType) {
        if (featureType == null) {
            UnknownFeaturesCollector.$$$reportNull$$$0(7);
        }
        Set<UnknownFeature> set = this.myUnknownFeatures.stream().filter(feature -> feature.getFeatureType().equals(featureType)).collect(Collectors.toUnmodifiableSet());
        if (set == null) {
            UnknownFeaturesCollector.$$$reportNull$$$0(8);
        }
        return set;
    }

    @Nullable
    public Element getState() {
        if (this.myIgnoredUnknownFeatures.isEmpty()) {
            return null;
        }
        Element ignored = new Element("ignored");
        for (UnknownFeature feature : this.myIgnoredUnknownFeatures) {
            Element option2 = new Element("option");
            option2.setAttribute(FEATURE_ID, feature.getFeatureType());
            option2.setAttribute(IMPLEMENTATION_NAME, feature.getImplementationName());
            ignored.addContent(option2);
        }
        return ignored;
    }

    public void loadState(@NotNull Element state2) {
        if (state2 == null) {
            UnknownFeaturesCollector.$$$reportNull$$$0(9);
        }
        this.myIgnoredUnknownFeatures.clear();
        for (Element element : state2.getChildren()) {
            String implementationName;
            String featureType = element.getAttributeValue(FEATURE_ID);
            if (featureType == null || (implementationName = element.getAttributeValue(IMPLEMENTATION_NAME)) == null) continue;
            this.myIgnoredUnknownFeatures.add(new UnknownFeature(featureType, implementationName));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/UnknownFeaturesCollector";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "feature";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = FEATURE_ID;
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/UnknownFeaturesCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnknownFeatures";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnknownFeaturesOfType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 6: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerUnknownFeature";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "unregisterUnknownFeature";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "ignoreFeature";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getUnknownFeaturesOfType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 6, 8 -> new IllegalStateException(string);
        };
    }
}

