/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.ex.temp;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePointerCapableFileSystem;
import com.intellij.openapi.vfs.ex.temp.TempFileSystemMarker;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemBase;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.StubVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public class TempFileSystem
extends LocalFileSystemBase
implements VirtualFilePointerCapableFileSystem,
TempFileSystemMarker {
    private static final String TEMP_PROTOCOL = "temp";
    private final FSItem myRoot = new FSDir();
    private static final Key<FSItem> FS_ITEM_KEY = Key.create((String)"FS_ITEM_KEY");

    @NotNull
    public static TempFileSystem getInstance() {
        TempFileSystem tempFileSystem = (TempFileSystem)VirtualFileManager.getInstance().getFileSystem(TEMP_PROTOCOL);
        if (tempFileSystem == null) {
            TempFileSystem.$$$reportNull$$$0(0);
        }
        return tempFileSystem;
    }

    @Override
    @NotNull
    protected String extractRootPath(@NotNull String normalizedPath) {
        if (normalizedPath == null) {
            TempFileSystem.$$$reportNull$$$0(1);
        }
        return "/";
    }

    @Override
    @Nullable
    public Path getNioPath(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(2);
        }
        return null;
    }

    @Nullable
    private FSItem convert(@NotNull VirtualFile file2) {
        VirtualFile parentFile;
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(3);
        }
        if ((parentFile = file2.getParent()) == null) {
            return this.myRoot;
        }
        FSItem item = (FSItem)file2.getUserData(FS_ITEM_KEY);
        if (item == null) {
            FSItem parentItem = this.convert(parentFile);
            if (parentItem == null || !parentItem.isDirectory()) {
                return null;
            }
            item = parentItem.findChild(file2.getName());
            TempFileSystem.registerFSItem(file2, item);
        }
        return item;
    }

    @NotNull
    private FSDir convertDirectory(@NotNull VirtualFile dir) throws IOException {
        FSItem fsItem;
        if (dir == null) {
            TempFileSystem.$$$reportNull$$$0(4);
        }
        if (!(fsItem = this.convertAndCheck(dir)).isDirectory()) {
            throw new IOException("Not a directory: " + dir.getPath());
        }
        FSDir fSDir = (FSDir)fsItem;
        if (fSDir == null) {
            TempFileSystem.$$$reportNull$$$0(5);
        }
        return fSDir;
    }

    @NotNull
    private FSItem convertAndCheck(@NotNull VirtualFile file2) {
        FSItem fsItem;
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(6);
        }
        if ((fsItem = this.convert(file2)) == null) {
            throw new IllegalStateException("Does not exist: " + file2.getPath());
        }
        FSItem fSItem = fsItem;
        if (fSItem == null) {
            TempFileSystem.$$$reportNull$$$0(7);
        }
        return fSItem;
    }

    @Override
    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile parent, @NotNull String name2) throws IOException {
        FSDir fsDir;
        FSItem existing;
        if (parent == null) {
            TempFileSystem.$$$reportNull$$$0(8);
        }
        if (name2 == null) {
            TempFileSystem.$$$reportNull$$$0(9);
        }
        if ((existing = (fsDir = this.convertDirectory(parent)).findChild(name2)) == null) {
            fsDir.addChild(name2, new FSDir());
        } else if (!existing.isDirectory()) {
            throw new IOException("File " + name2 + " already exists in " + parent.getPath());
        }
        return new FakeVirtualFile(parent, name2);
    }

    private static void registerFSItem(@NotNull VirtualFile parent, FSItem item) {
        if (parent == null) {
            TempFileSystem.$$$reportNull$$$0(10);
        }
        if (!(parent instanceof StubVirtualFile)) {
            parent.putUserData(FS_ITEM_KEY, (Object)item);
        }
    }

    @Override
    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile parent, @NotNull String name2) throws IOException {
        FSDir fsDir;
        if (parent == null) {
            TempFileSystem.$$$reportNull$$$0(11);
        }
        if (name2 == null) {
            TempFileSystem.$$$reportNull$$$0(12);
        }
        if ((fsDir = this.convertDirectory(parent)).findChild(name2) != null) {
            throw new IOException("File " + name2 + " already exists in " + parent.getPath());
        }
        fsDir.addChild(name2, new FSFile());
        return new FakeVirtualFile(parent, name2);
    }

    @TestOnly
    public void createIfNotExists(@NotNull VirtualFile parent, @NotNull String name2) throws IOException {
        FSDir fsDir;
        if (parent == null) {
            TempFileSystem.$$$reportNull$$$0(13);
        }
        if (name2 == null) {
            TempFileSystem.$$$reportNull$$$0(14);
        }
        if ((fsDir = this.convertDirectory(parent)).findChild(name2) == null) {
            fsDir.addChild(name2, new FSFile());
        }
    }

    @Override
    @NotNull
    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(15);
        }
        if (newParent == null) {
            TempFileSystem.$$$reportNull$$$0(16);
        }
        if (copyName == null) {
            TempFileSystem.$$$reportNull$$$0(17);
        }
        VirtualFile virtualFile2 = VfsUtilCore.copyFile((Object)requestor, (VirtualFile)file2, (VirtualFile)newParent, (String)copyName);
        if (virtualFile2 == null) {
            TempFileSystem.$$$reportNull$$$0(18);
        }
        return virtualFile2;
    }

    @Override
    public void deleteFile(Object requestor, @NotNull VirtualFile file2) throws IOException {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(19);
        }
        FSDir parent = this.convertAndCheckParent(file2);
        parent.removeChild(file2.getName(), file2.getParent());
        TempFileSystem.clearFsItemCache(file2);
    }

    @NotNull
    private FSDir convertAndCheckParent(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(20);
        }
        return (FSDir)this.convertAndCheck(file2.getParent());
    }

    @Override
    public void moveFile(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile newParent) throws IOException {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(21);
        }
        if (newParent == null) {
            TempFileSystem.$$$reportNull$$$0(22);
        }
        FSItem fsItem = this.convertAndCheck(file2);
        FSItem newParentItem = this.convertAndCheck(newParent);
        FSDir oldParentItem = this.convertAndCheckParent(file2);
        if (!newParentItem.isDirectory()) {
            throw new IOException("Target is not a directory: " + file2.getPath());
        }
        FSDir newDir = (FSDir)newParentItem;
        String name2 = file2.getName();
        if (newDir.findChild(name2) != null) {
            throw new IOException("Directory already contains a file named " + name2);
        }
        oldParentItem.removeChild(name2, file2.getParent());
        newDir.addChild(name2, fsItem);
        TempFileSystem.clearFsItemCache(file2);
    }

    @Override
    public void renameFile(Object requestor, @NotNull VirtualFile file2, @NotNull String newName) throws IOException {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(23);
        }
        if (newName == null) {
            TempFileSystem.$$$reportNull$$$0(24);
        }
        this.setName(file2, newName);
    }

    @Override
    @NotNull
    public String getProtocol() {
        return TEMP_PROTOCOL;
    }

    @Override
    public boolean exists(@NotNull VirtualFile fileOrDirectory) {
        if (fileOrDirectory == null) {
            TempFileSystem.$$$reportNull$$$0(25);
        }
        return this.convert(fileOrDirectory) != null;
    }

    @Override
    public String @NotNull [] list(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(26);
        }
        FSItem fsItem = this.convertAndCheck(file2);
        String[] stringArray = fsItem.list();
        if (stringArray == null) {
            TempFileSystem.$$$reportNull$$$0(27);
        }
        return stringArray;
    }

    @Override
    @NotNull
    public String getCanonicallyCasedName(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(28);
        }
        String string = file2.getName();
        if (string == null) {
            TempFileSystem.$$$reportNull$$$0(29);
        }
        return string;
    }

    @Override
    public boolean isDirectory(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(30);
        }
        return this.convert(file2) instanceof FSDir;
    }

    @Override
    public long getTimeStamp(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(31);
        }
        FSItem fsItem = this.convertAndCheck(file2);
        return fsItem.myTimestamp;
    }

    @Override
    public void setTimeStamp(@NotNull VirtualFile file2, long timeStamp) {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(32);
        }
        FSItem fsItem = this.convertAndCheck(file2);
        fsItem.myTimestamp = timeStamp > 0L ? timeStamp : LocalTimeCounter.currentTime();
    }

    @Override
    public boolean isWritable(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(33);
        }
        FSItem fsItem = this.convertAndCheck(file2);
        return fsItem.myWritable;
    }

    @Override
    public void setWritable(@NotNull VirtualFile file2, boolean writableFlag) {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(34);
        }
        FSItem fsItem = this.convertAndCheck(file2);
        fsItem.myWritable = writableFlag;
    }

    @Override
    public byte @NotNull [] contentsToByteArray(@NotNull VirtualFile file2) throws IOException {
        FSItem fsItem;
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(35);
        }
        if (!((fsItem = this.convertAndCheck(file2)) instanceof FSFile)) {
            throw new IOException("Not a file: " + file2.getPath());
        }
        if (((FSFile)fsItem).myContent == null) {
            TempFileSystem.$$$reportNull$$$0(36);
        }
        return ((FSFile)fsItem).myContent;
    }

    @Override
    @NotNull
    public InputStream getInputStream(@NotNull VirtualFile file2) throws IOException {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(37);
        }
        return new BufferExposingByteArrayInputStream(this.contentsToByteArray(file2));
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(final @NotNull VirtualFile file2, Object requestor, final long modStamp, long l) throws IOException {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(38);
        }
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                super.close();
                FSItem fsItem = TempFileSystem.this.convertAndCheck(file2);
                if (!(fsItem instanceof FSFile)) {
                    throw new IOException("Not a file: " + file2.getPath());
                }
                ((FSFile)fsItem).myContent = this.toByteArray();
                TempFileSystem.this.setTimeStamp(file2, modStamp);
            }
        };
    }

    @Override
    public long getLength(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(39);
        }
        try {
            return this.contentsToByteArray(file2).length;
        }
        catch (IOException e) {
            return 0L;
        }
    }

    private void setName(@NotNull VirtualFile file2, @NotNull String name2) {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(40);
        }
        if (name2 == null) {
            TempFileSystem.$$$reportNull$$$0(41);
        }
        FSDir parent = this.convertAndCheckParent(file2);
        FSItem fsItem = this.convertAndCheck(file2);
        parent.myChildren.remove(file2.getName());
        parent.myChildren.put(name2, fsItem);
        TempFileSystem.clearFsItemCache(file2.getParent());
        TempFileSystem.clearFsItemCache(file2);
    }

    private static void clearFsItemCache(VirtualFile file2) {
        TempFileSystem.registerFSItem(file2, null);
    }

    @Override
    public FileAttributes getAttributes(@NotNull VirtualFile file2) {
        FSItem item;
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(42);
        }
        if ((item = this.convert(file2)) == null) {
            return null;
        }
        long length = item instanceof FSFile ? (long)((FSFile)item).myContent.length : 0L;
        return new FileAttributes(item.isDirectory(), false, false, false, length, item.myTimestamp, item.myWritable, FileAttributes.CaseSensitivity.SENSITIVE);
    }

    @NotNull
    public Set<LocalFileSystem.WatchRequest> replaceWatchedRoots(@NotNull Collection<LocalFileSystem.WatchRequest> watchRequests, @Nullable Collection<String> recursiveRoots, @Nullable Collection<String> flatRoots) {
        if (watchRequests == null) {
            TempFileSystem.$$$reportNull$$$0(43);
        }
        throw new IncorrectOperationException();
    }

    @Override
    @NotNull
    protected String normalize(@NotNull String path) {
        if (path == null) {
            TempFileSystem.$$$reportNull$$$0(44);
        }
        String string = path;
        if (string == null) {
            TempFileSystem.$$$reportNull$$$0(45);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 19, 20, 21, 22, 23, 24, 25, 26, 28, 30, 31, 32, 33, 34, 35, 37, 38, 39, 40, 41, 42, 43, 44 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/ex/temp/TempFileSystem";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "normalizedPath";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 9: 
            case 12: 
            case 14: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyName";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDirectory";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watchRequests";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/ex/temp/TempFileSystem";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "convertDirectory";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "convertAndCheck";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFile";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicallyCasedName";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "normalize";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "extractRootPath";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNioPath";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "convertDirectory";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convertAndCheck";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createChildDirectory";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "registerFSItem";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createChildFile";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createIfNotExists";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "copyFile";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "deleteFile";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "convertAndCheckParent";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "moveFile";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "renameFile";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicallyCasedName";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isDirectory";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getTimeStamp";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setTimeStamp";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isWritable";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "setWritable";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "contentsToByteArray";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getInputStream";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getOutputStream";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getLength";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "replaceWatchedRoots";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "normalize";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 19, 20, 21, 22, 23, 24, 25, 26, 28, 30, 31, 32, 33, 34, 35, 37, 38, 39, 40, 41, 42, 43, 44 -> new IllegalArgumentException(string);
        };
    }

    private static final class FSDir
    extends FSItem {
        private final Map<String, FSItem> myChildren = new LinkedHashMap<String, FSItem>();

        private FSDir() {
        }

        @Override
        @Nullable
        protected FSItem findChild(@NotNull String name2) {
            if (name2 == null) {
                FSDir.$$$reportNull$$$0(0);
            }
            return this.myChildren.get(name2);
        }

        @Override
        protected boolean isDirectory() {
            return true;
        }

        private void addChild(@NotNull String name2, @NotNull FSItem item) {
            if (name2 == null) {
                FSDir.$$$reportNull$$$0(1);
            }
            if (item == null) {
                FSDir.$$$reportNull$$$0(2);
            }
            this.myChildren.put(name2, item);
        }

        private void removeChild(@NotNull String name2, @Nullable VirtualFile parent) {
            if (name2 == null) {
                FSDir.$$$reportNull$$$0(3);
            }
            if (name2.equals("src") && parent == null) {
                throw new RuntimeException("removing 'temp:///src' directory");
            }
            this.myChildren.remove(name2);
        }

        @Override
        @NotNull
        protected @NotNull String @NotNull [] list() {
            String[] stringArray = ArrayUtil.toStringArray(this.myChildren.keySet());
            if (stringArray == null) {
                FSDir.$$$reportNull$$$0(4);
            }
            return stringArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vfs/ex/temp/TempFileSystem$FSDir";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vfs/ex/temp/TempFileSystem$FSDir";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "list";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "findChild";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "addChild";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "removeChild";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    private static abstract sealed class FSItem
    permits FSDir, FSFile {
        private long myTimestamp = LocalTimeCounter.currentTime();
        private boolean myWritable = true;

        private FSItem() {
        }

        protected boolean isDirectory() {
            return false;
        }

        protected FSItem findChild(@NotNull String name2) {
            if (name2 == null) {
                FSItem.$$$reportNull$$$0(0);
            }
            return null;
        }

        @NotNull
        protected @NotNull String @NotNull [] list() {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                FSItem.$$$reportNull$$$0(1);
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vfs/ex/temp/TempFileSystem$FSItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vfs/ex/temp/TempFileSystem$FSItem";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "list";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "findChild";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static final class FSFile
    extends FSItem {
        private byte[] myContent = ArrayUtil.EMPTY_BYTE_ARRAY;

        private FSFile() {
        }
    }
}

