/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent.mapped;

import com.intellij.platform.util.io.storages.mmapped.MMappedFileStorage;
import io.opentelemetry.api.metrics.BatchCallback;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class MappedStorageOTelMonitor
implements AutoCloseable {
    private final BatchCallback otelCallback;

    public MappedStorageOTelMonitor(@NotNull Meter meter) {
        if (meter == null) {
            MappedStorageOTelMonitor.$$$reportNull$$$0(0);
        }
        ObservableLongMeasurement storagesCounter = meter.gaugeBuilder("MappedFileStorage.storages").setDescription("MappedFileStorage instances in operation at the moment").ofLongs().buildObserver();
        ObservableLongMeasurement pagesCounter = meter.gaugeBuilder("MappedFileStorage.totalPagesMapped").setDescription("MappedFileStorage.Page instances in operation at the moment").ofLongs().buildObserver();
        ObservableLongMeasurement pagesBytesCounter = meter.gaugeBuilder("MappedFileStorage.totalBytesMapped").setDescription("Total size of MappedByteBuffers in use by MappedFileStorage at the moment").setUnit("bytes").ofLongs().buildObserver();
        ObservableLongMeasurement mappingTimeCounter = meter.gaugeBuilder("MappedFileStorage.totalTimeSpentOnMappingUs").setDescription("Total time (us) spent inside Page.map() method (file expansion/zeroing, + mmap)").setUnit("us").ofLongs().buildObserver();
        this.otelCallback = meter.batchCallback(() -> {
            storagesCounter.record((long)MMappedFileStorage.openedStoragesCount());
            pagesCounter.record((long)MMappedFileStorage.totalPagesMapped());
            pagesBytesCounter.record(MMappedFileStorage.totalBytesMapped());
            mappingTimeCounter.record(MMappedFileStorage.totalTimeForPageMap((TimeUnit)TimeUnit.MICROSECONDS));
        }, (ObservableMeasurement)storagesCounter, new ObservableMeasurement[]{pagesCounter, pagesBytesCounter, mappingTimeCounter});
    }

    @Override
    public void close() throws Exception {
        this.otelCallback.close();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meter", "com/intellij/openapi/vfs/newvfs/persistent/mapped/MappedStorageOTelMonitor", "<init>"));
    }
}

