/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.ide.ActivityTracker;
import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.dnd.DnDTargetChecker;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.impl.InternalUICustomization;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.openapi.wm.impl.content.ContentLayout;
import com.intellij.openapi.wm.impl.content.ContentTabLabel;
import com.intellij.openapi.wm.impl.content.SelectContentStep;
import com.intellij.openapi.wm.impl.content.TabbedContentTabLabel;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.MouseDragHelper;
import com.intellij.ui.UIBundle;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.TabbedContent;
import com.intellij.ui.paint.RectanglePainter;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.tabs.JBTabPainter;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.impl.MorePopupAware;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.BaseButtonBehavior;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TabContentLayout
extends ContentLayout
implements MorePopupAware {
    static final int MORE_ICON_BORDER = 6;
    public static final int TAB_LAYOUT_START = 4;
    protected boolean isSingleContentView;
    protected JLabel dropOverPlaceholder;
    private LayoutData lastLayout;
    final List<ContentTabLabel> tabs;
    private final Map<Content, ContentTabLabel> contentToTabs;
    List<AnAction> doubleClickActions;
    protected final JBTabPainter tabPainter;

    TabContentLayout(@NotNull ToolWindowContentUi ui) {
        if (ui == null) {
            TabContentLayout.$$$reportNull$$$0(0);
        }
        super(ui);
        this.isSingleContentView = false;
        this.tabs = new ArrayList<ContentTabLabel>();
        this.contentToTabs = new HashMap<Content, ContentTabLabel>();
        this.doubleClickActions = new ArrayList<AnAction>();
        this.tabPainter = TabContentLayout.createTabPainter();
        BaseButtonBehavior behavior2 = new BaseButtonBehavior(ui.getTabComponent(), null){

            protected void execute(MouseEvent e) {
                if (!TabContentLayout.this.ui.isCurrent(TabContentLayout.this)) {
                    return;
                }
                if (TabContentLayout.this.canShowMorePopup()) {
                    TabContentLayout.this.showMorePopup();
                }
            }
        };
        behavior2.setupListeners();
    }

    @Override
    public void init(@NotNull ContentManager contentManager) {
        if (contentManager == null) {
            TabContentLayout.$$$reportNull$$$0(1);
        }
        this.reset();
        this.idLabel = new BaseLabel(this.ui, ExperimentalUI.isNewUI()){

            @Override
            protected boolean allowEngravement() {
                return this.myUi.window.isActive();
            }
        };
        this.dropOverPlaceholder = new JLabel(){

            @Override
            public void paint(Graphics g) {
                g.setColor(JBUI.CurrentTheme.DragAndDrop.Area.BACKGROUND);
                RectanglePainter.FILL.paint((Graphics2D)g, 0, 0, this.getWidth(), this.getHeight(), null);
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(TabContentLayout.this.ui.dropOverWidth, 1);
            }
        };
        MouseDragHelper.setComponentDraggable((JComponent)this.idLabel, (boolean)true);
        for (int i2 = 0; i2 < contentManager.getContentCount(); ++i2) {
            this.contentAdded(new ContentManagerEvent((Object)this, contentManager.getContent(i2), i2));
        }
    }

    @Override
    public void reset() {
        this.tabs.clear();
        this.contentToTabs.clear();
        this.idLabel = null;
        this.dropOverPlaceholder = null;
    }

    void setTabDoubleClickActions(@NotNull List<AnAction> actions) {
        if (actions == null) {
            TabContentLayout.$$$reportNull$$$0(2);
        }
        this.doubleClickActions = actions;
    }

    @Nullable
    private Point getMorePopupOffset() {
        return this.lastLayout != null ? this.lastLayout.morePopupOffset : null;
    }

    public void dropCaches() {
        this.lastLayout = null;
    }

    public boolean canShowMorePopup() {
        return this.getMorePopupOffset() != null;
    }

    @Nullable
    public JBPopup showMorePopup() {
        Point offset = this.getMorePopupOffset();
        if (offset == null) {
            return null;
        }
        List hiddenTabs = ContainerUtil.filter(this.tabs, tab -> tab.getWidth() == 0);
        List contentsToShow = ContainerUtil.map((Collection)hiddenTabs, ContentTabLabel::getContent);
        SelectContentStep step2 = new SelectContentStep(contentsToShow);
        RelativePoint point = new RelativePoint((Component)this.ui.getTabComponent(), offset);
        ListPopup popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step2);
        popup2.show(point);
        return popup2;
    }

    @Override
    public void layout() {
        ActionToolbar tabToolbar;
        Rectangle bounds = this.ui.getTabComponent().getBounds();
        ContentManager manager2 = this.ui.getContentManager();
        LayoutData data2 = new LayoutData(this.ui);
        data2.toolbarWidth = this.getTabToolbarPreferredWidth();
        data2.eachX = this.getTabLayoutStart();
        data2.eachY = 0;
        if (this.isIdVisible()) {
            this.idLabel.setBounds(data2.eachX, data2.eachY, this.idLabel.getPreferredSize().width, bounds.height);
            data2.eachX += this.idLabel.getPreferredSize().width;
        } else {
            this.idLabel.setBounds(data2.eachX, data2.eachY, 0, 0);
        }
        int tabsStart = data2.eachX;
        boolean toolbarUpdateNeeded = false;
        if (manager2.getContentCount() != 0) {
            Content selected = manager2.getSelectedContent();
            if (selected == null) {
                selected = manager2.getContents()[0];
            }
            if (this.lastLayout != null && (this.idLabel == null || this.idLabel.isValid()) && this.lastLayout.layoutSize.equals(bounds.getSize()) && this.lastLayout.contentCount == manager2.getContentCount() && this.lastLayout.toolbarWidth == data2.toolbarWidth && ContainerUtil.all(this.tabs, Component::isValid)) {
                for (ContentTabLabel each : this.tabs) {
                    if (each.getContent() != selected || each.getBounds().width == 0) continue;
                    return;
                }
            }
            ArrayList<JLabel> toLayout = new ArrayList<JLabel>();
            HashSet<JLabel> toDrop = new HashSet<JLabel>();
            for (JLabel jLabel : this.tabs) {
                Dimension eachSize = jLabel.getPreferredSize();
                data2.requiredWidth += eachSize.width;
                toLayout.add(jLabel);
            }
            if (this.ui.dropOverIndex != -1 && !this.isSingleContentView) {
                data2.requiredWidth += this.ui.dropOverWidth;
                int index = Math.min(toLayout.size(), Math.max(0, this.ui.dropOverIndex - 1));
                toLayout.add(index, this.dropOverPlaceholder);
            }
            data2.toFitWidth = bounds.getSize().width - data2.toolbarWidth - data2.eachX;
            ContentTabLabel selectedTab = this.contentToTabs.get(selected);
            while (data2.requiredWidth > data2.toFitWidth && toLayout.size() > 1) {
                JLabel labelToDrop;
                JLabel jLabel = (JLabel)toLayout.get(0);
                JLabel lastLabel = (JLabel)toLayout.get(toLayout.size() - 1);
                if (jLabel != selectedTab && jLabel != this.dropOverPlaceholder) {
                    labelToDrop = jLabel;
                } else {
                    if (lastLabel == selectedTab || lastLabel == this.dropOverPlaceholder) break;
                    labelToDrop = lastLabel;
                }
                data2.requiredWidth -= labelToDrop.getPreferredSize().width + 1;
                toDrop.add(labelToDrop);
                toLayout.remove(labelToDrop);
            }
            boolean bl = false;
            TabsDrawMode toDrawTabs = this.isToDrawTabs();
            for (JLabel each : toLayout) {
                boolean bl2;
                if (toDrawTabs == TabsDrawMode.HIDE) {
                    each.setBounds(0, 0, 0, 0);
                    continue;
                }
                data2.eachY = 0;
                Dimension eachSize = each.getPreferredSize();
                if (data2.eachX + eachSize.width < data2.toFitWidth + tabsStart) {
                    each.setBounds(data2.eachX, data2.eachY, eachSize.width, bounds.height - data2.eachY);
                    data2.eachX += eachSize.width;
                    continue;
                }
                if (!bl2) {
                    int width = bounds.width - data2.eachX - data2.toolbarWidth;
                    each.setBounds(data2.eachX, data2.eachY, width, bounds.height - data2.eachY);
                    data2.eachX += width;
                } else {
                    each.setBounds(0, 0, 0, 0);
                }
                bl2 = true;
            }
            for (JLabel each : toDrop) {
                each.setBounds(0, 0, 0, 0);
            }
            if (toDrop.isEmpty()) {
                toolbarUpdateNeeded = this.lastLayout != null && this.lastLayout.morePopupOffset != null;
                data2.morePopupOffset = null;
            } else {
                toolbarUpdateNeeded = this.lastLayout != null && this.lastLayout.morePopupOffset == null;
                data2.morePopupOffset = new Point(data2.eachX + data2.toolbarWidth + 6, bounds.height);
            }
        }
        if ((tabToolbar = this.ui.getTabToolbar()) != null) {
            JComponent component2 = tabToolbar.getComponent();
            Dimension size2 = component2.getPreferredSize();
            component2.setBounds(data2.eachX, data2.eachY + (bounds.height - size2.height) / 2, size2.width, size2.height);
            data2.eachX += component2.getWidth();
        }
        this.lastLayout = data2;
        if (toolbarUpdateNeeded) {
            ActivityTracker.getInstance().inc();
        }
    }

    @Override
    public int getMinimumWidth() {
        ContentTabLabel label2;
        ContentManager contentManager;
        Content selected;
        int result2 = 0;
        if (this.idLabel != null && this.isIdVisible()) {
            result2 += this.idLabel.getPreferredSize().width;
            Insets insets = this.idLabel.getInsets();
            if (insets != null) {
                result2 += insets.left + insets.right;
            }
        }
        if ((selected = (contentManager = this.ui.getContentManager()).getSelectedContent()) == null && contentManager.getContentCount() > 0) {
            selected = contentManager.getContents()[0];
        }
        if (!ExperimentalUI.isNewUI() && selected != null && (label2 = this.contentToTabs.get(selected)) != null) {
            result2 += label2.getMinimumSize().width;
        }
        return result2 += this.getTabToolbarPreferredWidth();
    }

    @Nullable
    ContentTabLabel findTabLabelByContent(@Nullable Content content2) {
        return this.contentToTabs.get(content2);
    }

    @NotNull
    TabsDrawMode isToDrawTabs() {
        int size2 = this.tabs.size();
        if (size2 > 1) {
            TabsDrawMode tabsDrawMode = TabsDrawMode.PAINT_ALL;
            if (tabsDrawMode == null) {
                TabContentLayout.$$$reportNull$$$0(3);
            }
            return tabsDrawMode;
        }
        if (size2 == 1) {
            ContentTabLabel tabLabel = this.tabs.get(0);
            Content content2 = tabLabel.getContent();
            if (!StringUtil.isEmptyOrSpaces((String)content2.getToolwindowTitle())) {
                if (Boolean.TRUE.equals(content2.getUserData(Content.SIMPLIFIED_TAB_RENDERING_KEY))) {
                    TabsDrawMode tabsDrawMode = TabsDrawMode.PAINT_SIMPLIFIED;
                    if (tabsDrawMode == null) {
                        TabContentLayout.$$$reportNull$$$0(4);
                    }
                    return tabsDrawMode;
                }
                TabsDrawMode tabsDrawMode = TabsDrawMode.PAINT_ALL;
                if (tabsDrawMode == null) {
                    TabContentLayout.$$$reportNull$$$0(5);
                }
                return tabsDrawMode;
            }
            if (tabLabel.hasActiveIcons()) {
                TabsDrawMode tabsDrawMode = TabsDrawMode.PAINT_SIMPLIFIED;
                if (tabsDrawMode == null) {
                    TabContentLayout.$$$reportNull$$$0(6);
                }
                return tabsDrawMode;
            }
            TabsDrawMode tabsDrawMode = TabsDrawMode.HIDE;
            if (tabsDrawMode == null) {
                TabContentLayout.$$$reportNull$$$0(7);
            }
            return tabsDrawMode;
        }
        TabsDrawMode tabsDrawMode = TabsDrawMode.HIDE;
        if (tabsDrawMode == null) {
            TabContentLayout.$$$reportNull$$$0(8);
        }
        return tabsDrawMode;
    }

    @NotNull
    private static JBTabPainter createTabPainter() {
        InternalUICustomization customization = InternalUICustomization.getInstance();
        JBTabPainter jBTabPainter = customization == null ? JBTabPainter.getTOOL_WINDOW() : customization.getToolWindowTabPainter();
        if (jBTabPainter == null) {
            TabContentLayout.$$$reportNull$$$0(9);
        }
        return jBTabPainter;
    }

    @Override
    public void paintComponent(Graphics g) {
        TabsDrawMode toDrawTabs = this.isToDrawTabs();
        if (toDrawTabs == TabsDrawMode.HIDE) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        for (ContentTabLabel each : this.tabs) {
            int borderThickness = JBUIScale.scale((int)1);
            Rectangle r = each.getBounds();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (toDrawTabs != TabsDrawMode.PAINT_ALL) continue;
            if (each.isSelected()) {
                this.tabPainter.paintSelectedTab(this.getTabsPosition(), g2d, r, borderThickness, each.getTabColor(), this.ui.window.isActive() && this.ui.isActive() != false, each.isHovered());
                continue;
            }
            this.tabPainter.paintTab(this.getTabsPosition(), g2d, r, borderThickness, each.getTabColor(), this.ui.window.isActive(), each.isHovered());
        }
        g2d.dispose();
    }

    @Override
    public void update() {
        for (ContentTabLabel each : this.tabs) {
            each.update();
        }
        this.updateIdLabel(this.idLabel);
    }

    @Override
    public void rebuild() {
        JPanel tabComponent = this.ui.getTabComponent();
        tabComponent.removeAll();
        tabComponent.add(this.idLabel);
        ToolWindowContentUi.initMouseListeners(this.idLabel, this.ui, true);
        for (ContentTabLabel each : this.tabs) {
            tabComponent.add(each);
            ToolWindowContentUi.initMouseListeners(each, this.ui, false);
        }
        if (!(this.isSingleContentView && Registry.is((String)"debugger.new.tool.window.layout.dnd", (boolean)false) || this.ui.dropOverIndex < 0 || this.tabs.isEmpty())) {
            int index = Math.min(this.ui.dropOverIndex, tabComponent.getComponentCount());
            tabComponent.add((Component)this.dropOverPlaceholder, index);
        }
        this.ui.connectTabToolbar();
    }

    @Override
    public void contentAdded(@NotNull ContentManagerEvent event) {
        Content content2;
        if (event == null) {
            TabContentLayout.$$$reportNull$$$0(10);
        }
        ContentTabLabel tab = (content2 = event.getContent()) instanceof TabbedContent ? new TabbedContentTabLabel((TabbedContent)content2, this) : new ContentTabLabel(content2, this);
        this.tabs.add(Math.min(event.getIndex(), this.tabs.size()), tab);
        this.contentToTabs.put(content2, tab);
        DnDTarget target = TabContentLayout.getDnDTarget(content2);
        if (target != null) {
            DnDSupport.createBuilder((JComponent)tab).setDropHandler((DnDDropHandler)target).setTargetChecker((DnDTargetChecker)target).setCleanUpOnLeaveCallback(() -> target.cleanUpOnLeave()).install();
        }
    }

    @Nullable
    private static DnDTarget getDnDTarget(Content content2) {
        DnDTarget target = (DnDTarget)content2.getUserData(Content.TAB_DND_TARGET_KEY);
        if (target != null) {
            return target;
        }
        return (DnDTarget)ObjectUtils.tryCast((Object)content2, DnDTarget.class);
    }

    @Override
    public void contentRemoved(@NotNull ContentManagerEvent event) {
        ContentTabLabel tab;
        if (event == null) {
            TabContentLayout.$$$reportNull$$$0(11);
        }
        if ((tab = this.contentToTabs.get(event.getContent())) != null) {
            this.tabs.remove(tab);
            this.contentToTabs.remove(event.getContent());
        }
    }

    @Override
    public void showContentPopup(ListPopup listPopup) {
        Content selected = this.ui.getContentManager().getSelectedContent();
        if (selected != null) {
            ContentTabLabel tab = this.contentToTabs.get(selected);
            listPopup.showUnderneathOf((Component)tab);
        } else {
            listPopup.showUnderneathOf((Component)this.idLabel);
        }
    }

    @Override
    @NlsActions.ActionText
    public String getCloseActionName() {
        return UIBundle.message((String)"tabbed.pane.close.tab.action.name", (Object[])new Object[0]);
    }

    @Override
    @NlsActions.ActionText
    public String getCloseAllButThisActionName() {
        return UIBundle.message((String)"tabbed.pane.close.all.tabs.but.this.action.name", (Object[])new Object[0]);
    }

    @Override
    @NlsActions.ActionText
    public String getPreviousContentActionName() {
        return UIBundle.message((String)"tabbed.pane.select.previous.tab", (Object[])new Object[0]);
    }

    @Override
    @NlsActions.ActionText
    public String getNextContentActionName() {
        return UIBundle.message((String)"tabbed.pane.select.next.tab", (Object[])new Object[0]);
    }

    public int getTabLayoutStart() {
        InternalUICustomization customization = InternalUICustomization.getInstance();
        if (customization != null) {
            return customization.getTabLayoutStart(this);
        }
        return TabContentLayout.defaultTabLayoutStart();
    }

    public static int defaultTabLayoutStart() {
        return ExperimentalUI.isNewUI() ? 0 : 4;
    }

    public JBTabsPosition getTabsPosition() {
        return JBTabsPosition.top;
    }

    public int getTabHOffsetUnscaled() {
        InternalUICustomization customization = InternalUICustomization.getInstance();
        if (customization == null) {
            return 0;
        }
        return customization.getTabHOffsetUnscaled(UISettings.getInstance().getCompactMode(), this.getTabsPosition());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/content/TabContentLayout";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/content/TabContentLayout";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "isToDrawTabs";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createTabPainter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setTabDoubleClickActions";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "contentAdded";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "contentRemoved";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }

    static final class LayoutData {
        int toFitWidth;
        int requiredWidth;
        Dimension layoutSize;
        Point morePopupOffset;
        public int eachX;
        public int eachY;
        public int contentCount;
        public int toolbarWidth;

        LayoutData(ToolWindowContentUi ui) {
            this.layoutSize = ui.getTabComponent().getSize();
            this.contentCount = ui.getContentManager().getContentCount();
        }
    }

    static enum TabsDrawMode {
        PAINT_ALL,
        PAINT_SIMPLIFIED,
        HIDE;

    }
}

