/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.diagnostic.PlatformMemoryUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.platform.util.io.storages.mmapped.MMappedFileStorage;
import com.intellij.ui.ClickListener;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.UIBundle;
import com.intellij.util.LazyInitializer;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.io.DirectByteBufferAllocator;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.StorageLockContext;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.jetbrains.JBR;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadMXBean;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class MemoryUsagePanel
implements CustomStatusBarWidget,
Activatable {
    public static final String WIDGET_ID = "Memory";
    public static final String SHOW_TOTAL_MEMORY_ESTIMATION_REGISTRY_KEY = "idea.memory.usage.show.total.memory.estimation";
    private final LazyInitializer.LazyValue<MemoryUsagePanelImpl> myComponent = LazyInitializer.create(() -> new MemoryUsagePanelImpl());
    private ScheduledFuture<?> myFuture;
    private static final MemoryMXBean MEMORY_MX_BEAN = ManagementFactory.getMemoryMXBean();
    private static final ThreadMXBean THREAD_MX_BEAN = ManagementFactory.getThreadMXBean();

    public void showNotify() {
        this.myFuture = EdtExecutorService.getScheduledExecutorInstance().scheduleWithFixedDelay(() -> ((MemoryUsagePanelImpl)this.myComponent.get()).updateState(), 1L, 5L, TimeUnit.SECONDS);
    }

    public void hideNotify() {
        if (this.myFuture != null) {
            this.myFuture.cancel(true);
            this.myFuture = null;
        }
    }

    @Nullable
    public StatusBarWidget.WidgetPresentation getPresentation() {
        return null;
    }

    @NotNull
    public String ID() {
        return WIDGET_ID;
    }

    public JComponent getComponent() {
        return (JComponent)this.myComponent.get();
    }

    public static boolean isInstance(@NotNull JComponent component2) {
        if (component2 == null) {
            MemoryUsagePanel.$$$reportNull$$$0(0);
        }
        return component2 instanceof MemoryUsagePanelImpl;
    }

    public void addMouseListener(MouseListener l) {
        ((MemoryUsagePanelImpl)this.myComponent.get()).addMouseListener(l);
    }

    public MouseListener[] getMouseListeners() {
        return ((MemoryUsagePanelImpl)this.myComponent.get()).getMouseListeners();
    }

    public void removeMouseListener(MouseListener l) {
        ((MemoryUsagePanelImpl)this.myComponent.get()).removeMouseListener(l);
    }

    private static AppMemoryUsage calculateMemoryUsage() {
        MemoryUsage heapMemoryUsage = MEMORY_MX_BEAN.getHeapMemoryUsage();
        long directBuffersUsedByFileCacheBytes = DirectByteBufferAllocator.ALLOCATOR.getStatistics().totalSizeOfBuffersAllocatedInBytes;
        long directBuffersUsedBytes = IOUtil.directBuffersTotalAllocatedSize();
        if (directBuffersUsedBytes <= 0L) {
            directBuffersUsedBytes = directBuffersUsedByFileCacheBytes;
        }
        long threadsStackBytes = (long)THREAD_MX_BEAN.getThreadCount() * 0x100000L;
        long jvmInternalsMemoryBytes = MemoryUsagePanel.jvmInternalsMemory(ManagementFactory.getMemoryPoolMXBeans());
        long memoryMappedFilesBytes = MMappedFileStorage.totalBytesMapped();
        return new AppMemoryUsage(heapMemoryUsage.getMax(), heapMemoryUsage.getCommitted(), heapMemoryUsage.getUsed(), jvmInternalsMemoryBytes, directBuffersUsedBytes, directBuffersUsedByFileCacheBytes, threadsStackBytes, memoryMappedFilesBytes);
    }

    private static long jvmInternalsMemory(@NotNull List<MemoryPoolMXBean> memoryPools) {
        if (memoryPools == null) {
            MemoryUsagePanel.$$$reportNull$$$0(1);
        }
        return memoryPools.stream().filter(pool -> pool.getType() == MemoryType.NON_HEAP).mapToLong(pool -> pool.getUsage().getUsed()).sum();
    }

    private static long roundUpTo(long value, long bucket) {
        long fraction = value / bucket;
        long remainder = value % bucket;
        if (remainder > 0L) {
            return (fraction + 1L) * bucket;
        }
        return value;
    }

    private static long toMb(long value) {
        return value / 0x100000L;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memoryPools";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/wm/impl/status/MemoryUsagePanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "jvmInternalsMemory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class MemoryUsagePanelImpl
    extends TextPanel {
        private final Color myUsedColor = JBColor.namedColor((String)"MemoryIndicator.usedBackground", (Color)new JBColor((Color)Gray._185, (Color)Gray._110));
        private final Color myUnusedColor = JBColor.namedColor((String)"MemoryIndicator.allocatedBackground", (Color)new JBColor((Color)Gray._215, (Color)Gray._90));
        private long lastCommitedMb = -1L;
        private long lastUsedMb = -1L;

        MemoryUsagePanelImpl() {
            this.setFocusable(false);
            this.setTextAlignment(0.5f);
            new ClickListener(){

                public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (clickCount == 1) {
                        System.gc();
                    } else if (clickCount == 2) {
                        if (JBR.isSystemUtilsSupported()) {
                            JBR.getSystemUtils().fullGC();
                        } else {
                            System.gc();
                        }
                        StorageLockContext.forceDirectMemoryCache();
                        DirectByteBufferAllocator.ALLOCATOR.releaseCachedBuffers();
                        PlatformMemoryUtil.getInstance().trimLinuxNativeHeap();
                    }
                    MemoryUsagePanelImpl.this.updateState();
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/wm/impl/status/MemoryUsagePanel$MemoryUsagePanelImpl$1", "onClick"));
                }
            }.installOn((Component)this, true);
            this.setBorder((Border)JBUI.Borders.empty((int)0, (int)2));
            this.updateUI();
            UiNotifyConnector.installOn((Component)this, (Activatable)MemoryUsagePanel.this);
        }

        @Override
        public Color getBackground() {
            return null;
        }

        public void setShowing(boolean showing2) {
            if (showing2 != this.isVisible()) {
                this.setVisible(showing2);
                this.revalidate();
            }
        }

        @Override
        public void paintComponent(Graphics g) {
            long usedMem;
            long allocatedMem;
            long maxMem;
            Dimension size2 = this.getSize();
            int barWidth = size2.width;
            if (Registry.is((String)MemoryUsagePanel.SHOW_TOTAL_MEMORY_ESTIMATION_REGISTRY_KEY)) {
                AppMemoryUsage memoryUsage = MemoryUsagePanel.calculateMemoryUsage();
                maxMem = MemoryUsagePanel.toMb(memoryUsage.estimatedTotalMemoryUsedBytes());
                allocatedMem = MemoryUsagePanel.toMb(memoryUsage.heapCommitedBytes);
                usedMem = MemoryUsagePanel.toMb(memoryUsage.heapUsedBytes);
            } else {
                Runtime runtime = Runtime.getRuntime();
                maxMem = runtime.maxMemory();
                allocatedMem = runtime.totalMemory();
                usedMem = allocatedMem - runtime.freeMemory();
            }
            int usedBarLength = (int)((long)barWidth * usedMem / maxMem);
            int allocatedBarLength = (int)((long)barWidth * allocatedMem / maxMem);
            g.setColor(UIUtil.getPanelBackground());
            g.fillRect(0, 0, barWidth, size2.height);
            g.setColor(this.myUnusedColor);
            g.fillRect(0, 0, allocatedBarLength, size2.height);
            g.setColor(this.myUsedColor);
            g.fillRect(0, 0, usedBarLength, size2.height);
            super.paintComponent(g);
        }

        @Override
        protected String getTextForPreferredSize() {
            long maxMemoryMb;
            long l = maxMemoryMb = Registry.is((String)MemoryUsagePanel.SHOW_TOTAL_MEMORY_ESTIMATION_REGISTRY_KEY) ? MemoryUsagePanel.toMb(Runtime.getRuntime().maxMemory()) * 2L : MemoryUsagePanel.toMb(Runtime.getRuntime().maxMemory());
            long sample = maxMemoryMb < 1000L ? 999L : (maxMemoryMb < 10000L ? 9999L : 99999L);
            return " " + UIBundle.message((String)"memory.usage.panel.message.text", (Object[])new Object[]{sample, sample});
        }

        private void updateState() {
            String text2;
            if (!this.isShowing()) {
                return;
            }
            AppMemoryUsage memoryUsage = MemoryUsagePanel.calculateMemoryUsage();
            long heapMaxMb = MemoryUsagePanel.toMb(memoryUsage.heapMaxBytes);
            long heapCommitedMb = MemoryUsagePanel.toMb(memoryUsage.heapCommitedBytes);
            long heapUsedMb = MemoryUsagePanel.toMb(memoryUsage.heapUsedBytes);
            long directBuffersUsedMb = MemoryUsagePanel.toMb(memoryUsage.directByteBuffersBytes);
            long directBuffersFileCacheUsedMb = MemoryUsagePanel.toMb(memoryUsage.directBuffersFileCacheUsedBytes);
            long jvmInternalsMb = MemoryUsagePanel.toMb(memoryUsage.jvmInternalsMemoryBytes);
            long threadStacksMemoryMb = MemoryUsagePanel.toMb(memoryUsage.threadStacksBytes);
            long memoryMappedFilesMb = MemoryUsagePanel.toMb(memoryUsage.memoryMappedFilesBytes);
            long estimatedTotalMemoryUsedMb = MemoryUsagePanel.toMb(memoryUsage.estimatedTotalMemoryUsedBytes());
            PlatformMemoryUtil.MemoryStats stats = PlatformMemoryUtil.getInstance().getCurrentProcessMemoryStats();
            if (stats != null && stats.getRamMinusFileMappings() == 0L) {
                stats = null;
            }
            long fileMappingsRamMb = MemoryUsagePanel.toMb(stats != null ? stats.getFileMappingsRam() : 0L);
            long ramMinusFileMappingsMb = MemoryUsagePanel.toMb(stats != null ? stats.getRamMinusFileMappings() : 0L);
            long ramPlusSwapMinusFileMappings = MemoryUsagePanel.toMb(stats != null ? stats.getRamPlusSwapMinusFileMappings() : 0L);
            String string = text2 = Registry.is((String)MemoryUsagePanel.SHOW_TOTAL_MEMORY_ESTIMATION_REGISTRY_KEY) ? UIBundle.message((String)"memory.usage.panel.message.text", (Object[])new Object[]{heapUsedMb, estimatedTotalMemoryUsedMb}) : UIBundle.message((String)"memory.usage.panel.message.text", (Object[])new Object[]{heapUsedMb, heapMaxMb});
            if (heapCommitedMb != this.lastCommitedMb || heapUsedMb != this.lastUsedMb || !text2.equals(this.getText())) {
                this.lastCommitedMb = heapCommitedMb;
                this.lastUsedMb = heapUsedMb;
                this.setText(text2);
                String i18nBundleKey = stats != null ? "memory.usage.panel.message.tooltip-extended" : "memory.usage.panel.message.tooltip";
                this.setToolTipText(UIBundle.message((String)i18nBundleKey, (Object[])new Object[]{heapUsedMb, heapCommitedMb, heapMaxMb, directBuffersFileCacheUsedMb, directBuffersUsedMb - directBuffersFileCacheUsedMb, jvmInternalsMb, threadStacksMemoryMb, estimatedTotalMemoryUsedMb, memoryMappedFilesMb, fileMappingsRamMb, ramMinusFileMappingsMb, ramPlusSwapMinusFileMappings}));
            }
        }
    }

    private static final class AppMemoryUsage {
        public final long heapMaxBytes;
        public final long heapCommitedBytes;
        public final long heapUsedBytes;
        public final long jvmInternalsMemoryBytes;
        public final long directByteBuffersBytes;
        public final long directBuffersFileCacheUsedBytes;
        public final long threadStacksBytes;
        public final long memoryMappedFilesBytes;

        private AppMemoryUsage(long heapMaxBytes, long heapCommitedBytes, long heapUsedBytes, long jvmInternalsMemoryBytes, long directByteBuffersBytes, long directBuffersFileCacheUsedBytes, long threadStacksBytes, long memoryMappedFilesBytes) {
            this.heapMaxBytes = heapMaxBytes;
            this.heapCommitedBytes = heapCommitedBytes;
            this.heapUsedBytes = heapUsedBytes;
            this.jvmInternalsMemoryBytes = jvmInternalsMemoryBytes;
            this.directByteBuffersBytes = directByteBuffersBytes;
            this.directBuffersFileCacheUsedBytes = directBuffersFileCacheUsedBytes;
            this.threadStacksBytes = threadStacksBytes;
            this.memoryMappedFilesBytes = memoryMappedFilesBytes;
        }

        public long estimatedTotalMemoryUsedBytes() {
            return MemoryUsagePanel.roundUpTo(this.heapCommitedBytes + this.threadStacksBytes + this.directByteBuffersBytes + this.jvmInternalsMemoryBytes, 0x6400000L);
        }
    }
}

