/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization.stateProperties;

import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.JsonSchemaType;
import com.intellij.openapi.components.ScalarProperty;
import com.intellij.openapi.components.StoredProperty;
import com.intellij.openapi.components.StoredPropertyBase;
import com.intellij.serialization.stateProperties.LongStoredPropertyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B4\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012#\u0010\u0005\u001a\u001f\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0016\u0010\u0014\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018H\u0016J\u0014\u0010\u0019\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u001aH\u0096\u0082\u0004J\n\u0010\u001b\u001a\u00020\u001cH\u0096\u0080\u0004J\n\u0010\u001d\u001a\u00020\u001eH\u0096\u0080\u0004J\b\u0010\u001f\u001a\u00020\u0016H\u0016J\u0012\u0010 \u001a\u00020\u00152\b\u0010!\u001a\u0004\u0018\u00010\u001eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0005\u001a\u001f\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\""}, d2={"Lcom/intellij/serialization/stateProperties/LongStoredProperty;", "Lcom/intellij/openapi/components/StoredPropertyBase;", "", "Lcom/intellij/openapi/components/ScalarProperty;", "defaultValue", "valueNormalizer", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "value", "<init>", "(JLkotlin/jvm/functions/Function1;)V", "jsonType", "Lcom/intellij/openapi/components/JsonSchemaType;", "getJsonType", "()Lcom/intellij/openapi/components/JsonSchemaType;", "getValue", "thisRef", "Lcom/intellij/openapi/components/BaseState;", "(Lcom/intellij/openapi/components/BaseState;)Ljava/lang/Long;", "setValue", "", "", "other", "Lcom/intellij/openapi/components/StoredProperty;", "equals", "", "hashCode", "", "toString", "", "isEqualToDefault", "parseAndSetValue", "rawValue", "intellij.platform.objectSerializer"})
public final class LongStoredProperty
extends StoredPropertyBase<Long>
implements ScalarProperty {
    private final long defaultValue;
    @Nullable
    private final Function1<Long, Long> valueNormalizer;
    private long value;

    public LongStoredProperty(long defaultValue, @Nullable Function1<? super Long, Long> valueNormalizer) {
        this.defaultValue = defaultValue;
        this.valueNormalizer = valueNormalizer;
        this.value = this.defaultValue;
    }

    @NotNull
    public JsonSchemaType getJsonType() {
        return JsonSchemaType.INTEGER;
    }

    @NotNull
    public Long getValue(@NotNull BaseState thisRef) {
        Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
        return this.value;
    }

    public void setValue(@NotNull BaseState thisRef, long value) {
        long newValue;
        Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
        Function1<Long, Long> function1 = this.valueNormalizer;
        long l = newValue = function1 != null ? ((Number)function1.invoke((Object)value)).longValue() : value;
        if (this.value != newValue) {
            thisRef.intIncrementModificationCount();
            this.value = newValue;
        }
    }

    public boolean setValue(@NotNull StoredProperty<Long> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        long newValue = ((LongStoredProperty)other).value;
        if (newValue == this.value) {
            return false;
        }
        this.value = newValue;
        return true;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof LongStoredProperty && this.value == ((LongStoredProperty)((Object)other)).value;
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    @NotNull
    public String toString() {
        return this.getName() + " = " + this.value + (this.value == this.defaultValue ? " (default)" : "");
    }

    public boolean isEqualToDefault() {
        return this.value == this.defaultValue;
    }

    public void parseAndSetValue(@Nullable String rawValue) {
        if (rawValue == null) {
            return;
        }
        this.value = LongStoredPropertyKt.access$parseYamlLong(rawValue);
    }
}

