/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010$\n\u0002\b\b\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u0012\u0010\u0004\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0003\u001a\u0014\u0010\u0006\u001a\u00020\u0001*\u00020\u00012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u001a\u0014\u0010\b\u001a\u00020\u0001*\u00020\u00012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u001a\u0012\u0010\n\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f\u001a\u001a\u0010\r\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0003\u001aj\u0010\u0010\u001a\u00020\u0001*\u00020\u00012\b\u0010\u0011\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00032\b\u0010\u0015\u001a\u0004\u0018\u00010\u00032\b\u0010\u0016\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0017\u001a\u00020\f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00032\b\u0010\u0019\u001a\u0004\u0018\u00010\u00032\b\u0010\u001a\u001a\u0004\u0018\u00010\u00032\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003\u001a\u001e\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0003H\u0002\u001a\u001e\u0010$\u001a\u00020\u0001*\u00020\u00012\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001d\"!\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001d*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b \u0010!\"!\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001d*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b#\u0010!\u00a8\u0006%"}, d2={"withFragment", "Ljava/net/URI;", "newFragment", "", "withScheme", "newScheme", "withPath", "newPath", "withQuery", "newQuery", "withPort", "newPort", "", "changeQuery", "originalUri", "newRawQuery", "fromRawParts", "scheme", "isOpaque", "", "schemeSpecificPart", "userInfo", "host", "port", "authority", "path", "query", "fragment", "parseParameters", "", "input", "fragmentParameters", "getFragmentParameters", "(Ljava/net/URI;)Ljava/util/Map;", "queryParameters", "getQueryParameters", "newURIWithFragmentParameters", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nUriUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UriUtil.kt\ncom/intellij/util/UriUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,131:1\n1642#2,10:132\n1915#2:142\n1916#2:144\n1652#2:145\n1#3:143\n*S KotlinDebug\n*F\n+ 1 UriUtil.kt\ncom/intellij/util/UriUtilKt\n*L\n114#1:132,10\n114#1:142\n114#1:144\n114#1:145\n114#1:143\n*E\n"})
public final class UriUtilKt {
    @NotNull
    public static final URI withFragment(@NotNull URI $this$withFragment, @Nullable String newFragment) {
        Intrinsics.checkNotNullParameter((Object)$this$withFragment, (String)"<this>");
        return new URI($this$withFragment.getScheme(), $this$withFragment.getUserInfo(), $this$withFragment.getHost(), $this$withFragment.getPort(), $this$withFragment.getPath(), $this$withFragment.getQuery(), newFragment);
    }

    @NotNull
    public static final URI withScheme(@NotNull URI $this$withScheme, @NotNull String newScheme) {
        Intrinsics.checkNotNullParameter((Object)$this$withScheme, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)newScheme, (String)"newScheme");
        return new URI(newScheme, $this$withScheme.getUserInfo(), $this$withScheme.getHost(), $this$withScheme.getPort(), $this$withScheme.getPath(), $this$withScheme.getQuery(), $this$withScheme.getFragment());
    }

    @NotNull
    public static final URI withPath(@NotNull URI $this$withPath, @Nullable String newPath) {
        Intrinsics.checkNotNullParameter((Object)$this$withPath, (String)"<this>");
        return new URI($this$withPath.getScheme(), $this$withPath.getUserInfo(), $this$withPath.getHost(), $this$withPath.getPort(), newPath, $this$withPath.getQuery(), $this$withPath.getFragment());
    }

    @NotNull
    public static final URI withQuery(@NotNull URI $this$withQuery, @Nullable String newQuery) {
        Intrinsics.checkNotNullParameter((Object)$this$withQuery, (String)"<this>");
        return new URI($this$withQuery.getScheme(), $this$withQuery.getUserInfo(), $this$withQuery.getHost(), $this$withQuery.getPort(), $this$withQuery.getPath(), newQuery, $this$withQuery.getFragment());
    }

    @NotNull
    public static final URI withPort(@NotNull URI $this$withPort, int newPort) {
        Intrinsics.checkNotNullParameter((Object)$this$withPort, (String)"<this>");
        return new URI($this$withPort.getScheme(), $this$withPort.getUserInfo(), $this$withPort.getHost(), newPort, $this$withPort.getPath(), $this$withPort.getQuery(), $this$withPort.getFragment());
    }

    @NotNull
    public static final URI changeQuery(@NotNull URI $this$changeQuery, @NotNull URI originalUri, @NotNull String newRawQuery) {
        Intrinsics.checkNotNullParameter((Object)$this$changeQuery, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)originalUri, (String)"originalUri");
        Intrinsics.checkNotNullParameter((Object)newRawQuery, (String)"newRawQuery");
        return UriUtilKt.fromRawParts($this$changeQuery, originalUri.getScheme(), originalUri.isOpaque(), originalUri.getRawSchemeSpecificPart(), originalUri.getRawUserInfo(), originalUri.getHost(), originalUri.getPort(), originalUri.getAuthority(), originalUri.getRawPath(), newRawQuery, originalUri.getRawFragment());
    }

    @NotNull
    public static final URI fromRawParts(@NotNull URI $this$fromRawParts, @Nullable String scheme, boolean isOpaque, @Nullable String schemeSpecificPart, @Nullable String userInfo, @Nullable String host, int port, @Nullable String authority, @Nullable String path, @Nullable String query, @Nullable String fragment) {
        Intrinsics.checkNotNullParameter((Object)$this$fromRawParts, (String)"<this>");
        StringBuilder sb = new StringBuilder();
        CharSequence charSequence = scheme;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            sb.append(scheme);
            sb.append(':');
        }
        if (isOpaque) {
            sb.append(schemeSpecificPart);
        } else {
            charSequence = host;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                boolean needBrackets;
                sb.append("//");
                charSequence = userInfo;
                if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                    sb.append(userInfo);
                    sb.append('@');
                }
                boolean bl = needBrackets = StringsKt.indexOf$default((CharSequence)host, (char)':', (int)0, (boolean)false, (int)6, null) >= 0 && !StringsKt.startsWith$default((String)host, (String)"[", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)host, (String)"]", (boolean)false, (int)2, null);
                if (needBrackets) {
                    sb.append('[');
                }
                sb.append(host);
                if (needBrackets) {
                    sb.append(']');
                }
                if (port != -1) {
                    sb.append(':');
                    sb.append(port);
                }
            } else {
                charSequence = authority;
                if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                    sb.append("//");
                    sb.append(authority);
                }
            }
            if (path != null) {
                sb.append(path);
            }
            if (query != null) {
                sb.append('?');
                sb.append(query);
            }
        }
        if (fragment != null) {
            sb.append('#');
            sb.append(fragment);
        }
        return new URI(sb.toString());
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<String, String> parseParameters(String input) {
        void $this$mapNotNullTo$iv$iv;
        Object object = input;
        if (object == null || StringsKt.isBlank((CharSequence)object)) {
            return MapsKt.emptyMap();
        }
        object = new char[1];
        object[0] = 38;
        Iterable $this$mapNotNull$iv = StringsKt.split$default((CharSequence)input, (char[])object, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Pair it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            char[] cArray = new char[]{'='};
            List split = StringsKt.split$default((CharSequence)it, (char[])cArray, (boolean)false, (int)2, (int)2, null);
            if ((split.size() != 2 ? null : TuplesKt.to(split.get(0), split.get(1))) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public static final Map<String, String> getFragmentParameters(@NotNull URI $this$fragmentParameters) {
        Intrinsics.checkNotNullParameter((Object)$this$fragmentParameters, (String)"<this>");
        return UriUtilKt.parseParameters($this$fragmentParameters.getFragment());
    }

    @NotNull
    public static final Map<String, String> getQueryParameters(@NotNull URI $this$queryParameters) {
        Intrinsics.checkNotNullParameter((Object)$this$queryParameters, (String)"<this>");
        return UriUtilKt.parseParameters($this$queryParameters.getQuery());
    }

    @NotNull
    public static final URI newURIWithFragmentParameters(@NotNull URI $this$newURIWithFragmentParameters, @NotNull Map<String, String> fragmentParameters) {
        Intrinsics.checkNotNullParameter((Object)$this$newURIWithFragmentParameters, (String)"<this>");
        Intrinsics.checkNotNullParameter(fragmentParameters, (String)"fragmentParameters");
        String newFragment = CollectionsKt.joinToString$default((Iterable)MapsKt.toList(fragmentParameters), (CharSequence)"&", null, null, (int)0, null, UriUtilKt::newURIWithFragmentParameters$lambda$0, (int)30, null);
        return new URI($this$newURIWithFragmentParameters.getScheme(), $this$newURIWithFragmentParameters.getUserInfo(), $this$newURIWithFragmentParameters.getHost(), $this$newURIWithFragmentParameters.getPort(), $this$newURIWithFragmentParameters.getPath(), $this$newURIWithFragmentParameters.getQuery(), newFragment);
    }

    private static final CharSequence newURIWithFragmentParameters$lambda$0(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getFirst() + "=" + it.getSecond();
    }
}

