/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.undo;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.impl.CommandId;
import com.intellij.openapi.command.impl.UndoDocumentUtil;
import com.intellij.openapi.command.impl.UndoableActionType;
import com.intellij.openapi.command.impl.cmd.CmdEvent;
import com.intellij.openapi.command.impl.cmd.CmdMeta;
import com.intellij.openapi.command.impl.cmd.UndoMeta;
import com.intellij.openapi.command.impl.cmd.UndoableActionMeta;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.UtilKt;
import com.jetbrains.rd.ide.model.RdCmdGroupId;
import com.jetbrains.rd.ide.model.RdCmdId;
import com.jetbrains.rd.ide.model.RdCmdItem;
import com.jetbrains.rd.ide.model.RdCmdItemVersion;
import com.jetbrains.rd.ide.model.RdCmdVersion;
import com.jetbrains.rd.ide.model.RdCommandName;
import com.jetbrains.rd.ide.model.RdDelGroupId;
import com.jetbrains.rd.ide.model.RdDocGroupId;
import com.jetbrains.rd.ide.model.RdEdtGroupId;
import com.jetbrains.rd.ide.model.RdFileEditorId;
import com.jetbrains.rd.ide.model.RdFileId;
import com.jetbrains.rd.ide.model.RdIntGroupId;
import com.jetbrains.rd.ide.model.RdPatch;
import com.jetbrains.rd.ide.model.RdPatchCmdBase;
import com.jetbrains.rd.ide.model.RdPatchCmdFinish;
import com.jetbrains.rd.ide.model.RdPatchCmdStart;
import com.jetbrains.rd.ide.model.RdPatchItem;
import com.jetbrains.rd.ide.model.RdPatchItemId;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.ide.model.RdStringGroupId;
import com.jetbrains.rd.ide.model.RdUndoConfirmationPolicy;
import com.jetbrains.rd.ide.model.RdUndoMeta;
import com.jetbrains.rd.ide.model.RdUndoableAction;
import com.jetbrains.rd.ide.model.RdUndoableActionType;
import com.jetbrains.rd.platform.ProjectUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u0000 F2\u00020\u0001:\u0002EFB\u0014\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\tH&J\u000e\u0010\n\u001a\u0004\u0018\u00010\t*\u00020\bH$J\u000e\u0010\u0007\u001a\u0004\u0018\u00010\u000b*\u00020\fH$J\u000e\u0010\n\u001a\u0004\u0018\u00010\f*\u00020\u000bH$J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000eJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u000eJ\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001bJ\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"H\u0002J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\b\u0010&\u001a\u0004\u0018\u00010\bJ\u0012\u0010'\u001a\u0004\u0018\u00010%2\u0006\u0010(\u001a\u00020)H\u0002J\f\u0010\u0007\u001a\u00020\u001b*\u00020*H\u0002J\f\u0010\n\u001a\u00020**\u00020\u001bH\u0002J\f\u0010\u0007\u001a\u0004\u0018\u00010+*\u00020,J\f\u0010\n\u001a\u00020,*\u00020+H\u0002J\f\u0010\u0007\u001a\u00020-*\u00020.H\u0002J\u000e\u0010\n\u001a\u0004\u0018\u00010.*\u00020-H\u0002J\u0012\u0010\n\u001a\b\u0012\u0004\u0012\u0002000/*\u000201H\u0002J\u0012\u0010\u0007\u001a\u000201*\b\u0012\u0004\u0012\u0002000/H\u0002J\f\u0010\n\u001a\u000200*\u000202H\u0002J\f\u0010\u0007\u001a\u000202*\u000200H\u0002J\u000e\u00103\u001a\u0004\u0018\u000104*\u00020\u0001H\u0002J\u000e\u0010\u0007\u001a\u0004\u0018\u00010\u0001*\u000204H\u0002J\u0012\u00105\u001a\u0004\u0018\u00010\f2\u0006\u0010(\u001a\u00020)H\u0004J\u0012\u00106\u001a\u0004\u0018\u0001072\u0006\u00108\u001a\u00020\fH\u0002J\u0012\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u000207H\u0002J\u0010\u0010<\u001a\u0002042\u0006\u0010=\u001a\u00020\u0001H\u0002J\u0012\u00105\u001a\u0004\u0018\u00010\f2\u0006\u0010>\u001a\u000207H\u0002J\u0014\u0010?\u001a\u0004\u0018\u00010)2\b\u00108\u001a\u0004\u0018\u00010\fH\u0002J\u0011\u0010\n\u001a\u00020@*\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u0002J\u0011\u0010\u0007\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004*\u00020@H\u0002J\f\u0010\n\u001a\u00020A*\u00020BH\u0002J\f\u0010\u0007\u001a\u00020B*\u00020AH\u0002J\f\u0010\n\u001a\u00020C*\u00020DH\u0002J\f\u0010\u0007\u001a\u00020D*\u00020CH\u0002R\u0013\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/jetbrains/rd/platform/undo/RdCmdModelSupport;", "", "commandNamePrefix", "", "Lcom/intellij/openapi/util/NlsContexts$Command;", "<init>", "(Ljava/lang/String;)V", "fromModel", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Lcom/jetbrains/rd/ide/model/RdFileEditorId;", "toModel", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/jetbrains/rd/ide/model/RdFileId;", "getCmdStartEvent", "Lcom/intellij/openapi/command/impl/cmd/CmdEvent;", "speculativePatch", "Lcom/jetbrains/rd/ide/model/RdPatch;", "getCmdFinishEvent", "getCmdEvent", "model", "Lcom/jetbrains/rd/ide/model/RdPatchCmdBase;", "getPatchCmdStart", "Lcom/jetbrains/rd/ide/model/RdPatchCmdStart;", "cmdEvent", "getPatchCmdFinish", "Lcom/jetbrains/rd/ide/model/RdPatchCmdFinish;", "getCmdVersion", "Lcom/intellij/openapi/command/impl/CommandId;", "Lcom/jetbrains/rd/ide/model/RdCmdItemVersion;", "getPatchCmdVersion", "commandId", "getCmdEventFromPatch", "patch", "isStart", "", "getDocRefs", "", "Lcom/jetbrains/rd/platform/undo/RdCmdModelSupport$DocRefWithId;", "editor", "docRefWithId", "docRef", "Lcom/intellij/openapi/command/undo/DocumentReference;", "", "Lcom/intellij/openapi/project/Project;", "Lcom/jetbrains/rd/ide/model/RdProjectId;", "Lcom/intellij/openapi/command/impl/cmd/UndoableActionMeta;", "Lcom/jetbrains/rd/ide/model/RdUndoableAction;", "", "Lcom/jetbrains/rd/ide/model/RdUndoMeta;", "Lcom/intellij/openapi/command/impl/cmd/CmdMeta;", "Lcom/intellij/openapi/command/impl/cmd/UndoMeta;", "groupIdToModel", "Lcom/jetbrains/rd/ide/model/RdCmdGroupId;", "getFileId", "getDocument", "Lcom/intellij/openapi/editor/Document;", "fileId", "getRdDocGroupId", "Lcom/jetbrains/rd/ide/model/RdDocGroupId;", "commandGroupId", "getSyntheticGroupId", "obj", "document", "getDocRef", "Lcom/jetbrains/rd/ide/model/RdCommandName;", "Lcom/jetbrains/rd/ide/model/RdUndoableActionType;", "Lcom/intellij/openapi/command/impl/UndoableActionType;", "Lcom/jetbrains/rd/ide/model/RdUndoConfirmationPolicy;", "Lcom/intellij/openapi/command/UndoConfirmationPolicy;", "DocRefWithId", "Companion", "intellij.rd.platform"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nRdCmdModelSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RdCmdModelSupport.kt\ncom/jetbrains/rd/platform/undo/RdCmdModelSupport\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,404:1\n1642#2,10:405\n1915#2:415\n1916#2:417\n1652#2:418\n1642#2,10:419\n1915#2:429\n1916#2:431\n1652#2:432\n1642#2,10:434\n1915#2:444\n1916#2:446\n1652#2:447\n1586#2:448\n1661#2,3:449\n1586#2:452\n1661#2,3:453\n1642#2,10:456\n1915#2:466\n1916#2:468\n1652#2:469\n1586#2:470\n1661#2,3:471\n1#3:416\n1#3:430\n1#3:433\n1#3:445\n1#3:467\n13#4:474\n*S KotlinDebug\n*F\n+ 1 RdCmdModelSupport.kt\ncom/jetbrains/rd/platform/undo/RdCmdModelSupport\n*L\n159#1:405,10\n159#1:415\n159#1:417\n159#1:418\n196#1:419,10\n196#1:429\n196#1:431\n196#1:432\n209#1:434,10\n209#1:444\n209#1:446\n209#1:447\n222#1:448\n222#1:449,3\n226#1:452\n226#1:453,3\n234#1:456,10\n234#1:466\n234#1:468\n234#1:469\n243#1:470\n243#1:471,3\n159#1:416\n196#1:430\n209#1:445\n234#1:467\n401#1:474\n*E\n"})
public abstract class RdCmdModelSupport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String commandNamePrefix;
    private static final int SYNTHETIC_GROUP_ID_MAX_LENGTH = 100;
    @NotNull
    private static final Logger LOG;

    public RdCmdModelSupport(@NotNull String commandNamePrefix) {
        Intrinsics.checkNotNullParameter((Object)commandNamePrefix, (String)"commandNamePrefix");
        this.commandNamePrefix = commandNamePrefix;
    }

    @Nullable
    public abstract FileEditor fromModel(@NotNull RdFileEditorId var1);

    @Nullable
    protected abstract RdFileEditorId toModel(@NotNull FileEditor var1);

    @Nullable
    protected abstract VirtualFile fromModel(@NotNull RdFileId var1);

    @Nullable
    protected abstract RdFileId toModel(@NotNull VirtualFile var1);

    @Nullable
    public final CmdEvent getCmdStartEvent(@NotNull RdPatch speculativePatch) {
        Intrinsics.checkNotNullParameter((Object)speculativePatch, (String)"speculativePatch");
        return this.getCmdEventFromPatch(speculativePatch, true);
    }

    @Nullable
    public final CmdEvent getCmdFinishEvent(@NotNull RdPatch speculativePatch) {
        Intrinsics.checkNotNullParameter((Object)speculativePatch, (String)"speculativePatch");
        return this.getCmdEventFromPatch(speculativePatch, false);
    }

    @NotNull
    public final CmdEvent getCmdEvent(@NotNull RdPatchCmdBase model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        CommandId commandId = this.fromModel(model.getCommandId());
        CmdMeta commandMeta = this.fromModel(model.getCommandMeta());
        if (model.isTransparent()) {
            return CmdEvent.Companion.createTransparent(commandId, true, commandMeta);
        }
        RdProjectId rdProjectId = model.getCommandProjectId();
        Project commandProject = rdProjectId != null ? this.fromModel(rdProjectId) : null;
        RdCmdGroupId rdCmdGroupId = model.getGroupId();
        Object groupId = rdCmdGroupId != null ? this.fromModel(rdCmdGroupId) : null;
        RdCommandName rdCommandName = model.getCommandName();
        String commandName = rdCommandName != null ? this.fromModel(rdCommandName) : null;
        UndoConfirmationPolicy confirmationPolicy = this.fromModel(model.getConfirmationPolicy());
        return CmdEvent.Companion.create(commandId, commandProject, commandName, groupId, confirmationPolicy, false, true, commandMeta);
    }

    @NotNull
    public final RdPatchCmdStart getPatchCmdStart(@NotNull CmdEvent cmdEvent) {
        Intrinsics.checkNotNullParameter((Object)cmdEvent, (String)"cmdEvent");
        long commandId = this.toModel(cmdEvent.id());
        String string = cmdEvent.name();
        RdCommandName commandName = string != null ? this.toModel(string) : null;
        List<RdUndoMeta> commandMeta = this.toModel(cmdEvent.meta());
        if (cmdEvent.isTransparent()) {
            return new RdPatchCmdStart(commandId, null, null, commandName, this.toModel(UndoConfirmationPolicy.DEFAULT), true, commandMeta);
        }
        Project project = cmdEvent.project();
        RdProjectId commandProjectId = project != null ? this.toModel(project) : null;
        Object object = cmdEvent.groupId();
        RdCmdGroupId groupId = object != null ? this.groupIdToModel(object) : null;
        RdUndoConfirmationPolicy confirmationPolicy = this.toModel(cmdEvent.confirmationPolicy());
        return new RdPatchCmdStart(commandId, commandProjectId, groupId, commandName, confirmationPolicy, false, commandMeta);
    }

    @NotNull
    public final RdPatchCmdFinish getPatchCmdFinish(@NotNull CmdEvent cmdEvent) {
        Intrinsics.checkNotNullParameter((Object)cmdEvent, (String)"cmdEvent");
        long commandId = this.toModel(cmdEvent.id());
        String string = cmdEvent.name();
        RdCommandName commandName = string != null ? this.toModel(string) : null;
        List<RdUndoMeta> commandMeta = this.toModel(cmdEvent.meta());
        if (cmdEvent.isTransparent()) {
            return new RdPatchCmdFinish(commandId, null, null, commandName, this.toModel(UndoConfirmationPolicy.DEFAULT), true, commandMeta);
        }
        Project project = cmdEvent.project();
        RdProjectId commandProjectId = project != null ? this.toModel(project) : null;
        Object object = cmdEvent.groupId();
        RdCmdGroupId groupId = object != null ? this.groupIdToModel(object) : null;
        RdUndoConfirmationPolicy confirmationPolicy = this.toModel(cmdEvent.confirmationPolicy());
        return new RdPatchCmdFinish(commandId, commandProjectId, groupId, commandName, confirmationPolicy, false, commandMeta);
    }

    @NotNull
    public final CommandId getCmdVersion(@NotNull RdCmdItemVersion model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        return this.fromModel(model.getVersion().getHash());
    }

    @NotNull
    public final RdCmdItemVersion getPatchCmdVersion(@NotNull CommandId commandId) {
        Intrinsics.checkNotNullParameter((Object)commandId, (String)"commandId");
        long id = this.toModel(commandId);
        return new RdCmdItemVersion(new RdCmdVersion(id), (RdPatchItemId)new RdCmdId());
    }

    private final CmdEvent getCmdEventFromPatch(RdPatch patch, boolean isStart) {
        List changes = isStart ? patch.getChanges() : CollectionsKt.asReversed((List)patch.getChanges());
        for (RdPatchItem item : changes) {
            if (!(item instanceof RdCmdItem)) continue;
            return this.getCmdEvent(((RdCmdItem)item).getDescriptor());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<DocRefWithId> getDocRefs(@Nullable FileEditor editor) {
        void $this$mapNotNullTo$iv$iv;
        Collection docRefs = UndoDocumentUtil.getDocRefs((FileEditor)editor);
        if (!(docRefs != null)) {
            boolean $i$a$-require-RdCmdModelSupport$getDocRefs$22 = false;
            String $i$a$-require-RdCmdModelSupport$getDocRefs$22 = "undo/redo not available without doc refs";
            throw new IllegalArgumentException($i$a$-require-RdCmdModelSupport$getDocRefs$22.toString());
        }
        Iterable $this$mapNotNull$iv = docRefs;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            DocRefWithId it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DocumentReference it = (DocumentReference)element$iv$iv;
            boolean bl2 = false;
            if (this.docRefWithId(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final DocRefWithId docRefWithId(DocumentReference docRef) {
        RdFileId fileId = this.getFileId(docRef);
        if (fileId != null) {
            return new DocRefWithId(fileId, docRef);
        }
        return null;
    }

    private final CommandId fromModel(long $this$fromModel) {
        CommandId commandId = CommandId.fromLong((long)$this$fromModel);
        Intrinsics.checkNotNullExpressionValue((Object)commandId, (String)"fromLong(...)");
        return commandId;
    }

    private final long toModel(CommandId $this$toModel) {
        return $this$toModel.asLong();
    }

    @Nullable
    public final Project fromModel(@NotNull RdProjectId $this$fromModel) {
        Intrinsics.checkNotNullParameter((Object)$this$fromModel, (String)"<this>");
        RdProjectId projectId = $this$fromModel;
        Project project = ProjectUtilKt.toProjectOrNull(projectId);
        if (project == null) {
            LOG.warn("Failed to get project for id " + projectId + ", it may lead to undo corruption");
        }
        return project;
    }

    private final RdProjectId toModel(Project $this$toModel) {
        return ProjectUtilKt.getOrCreateRdProjectId($this$toModel);
    }

    /*
     * Unable to fully structure code
     */
    private final UndoableActionMeta fromModel(RdUndoableAction $this$fromModel) {
        model = $this$fromModel;
        actionType = this.fromModel(model.getActionType());
        isGlobal = model.isGlobal();
        var6_5 = model.getAffectedFiles();
        if (var6_5 == null) ** GOTO lbl-1000
        var7_6 = var6_5;
        $i$f$mapNotNull = false;
        var9_9 = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        var14_15 = $this$forEach$iv$iv$iv.iterator();
        while (var14_15.hasNext()) {
            element$iv$iv = element$iv$iv$iv = var14_15.next();
            $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
            it = (RdFileId)element$iv$iv;
            $i$a$-mapNotNull-RdCmdModelSupport$fromModel$affectedDocuments$1 = false;
            if (this.getDocRef(it) == null) continue;
            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        var8_8 = (List)destination$iv$iv;
        if (var8_8.isEmpty()) {
            $i$a$-ifEmpty-RdCmdModelSupport$fromModel$affectedDocuments$2 = false;
            v0 = null;
        } else {
            v0 = var8_8;
        }
        var7_6 = (List)v0;
        if (var7_6 != null) {
            v1 = (Collection)var7_6;
            Intrinsics.checkNotNullExpressionValue((Object)DocumentReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            v2 = (DocumentReference[])UtilKt.toArray((Collection)v1, (Object[])DocumentReference.EMPTY_ARRAY);
        } else lbl-1000:
        // 2 sources

        {
            v2 = null;
        }
        affectedDocuments = v2;
        return UndoableActionMeta.Companion.create(actionType, affectedDocuments, isGlobal);
    }

    /*
     * WARNING - void declaration
     */
    private final RdUndoableAction toModel(UndoableActionMeta $this$toModel) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        UndoableActionMeta action = $this$toModel;
        Collection affectedDocs = action.affectedDocuments();
        if (affectedDocs == null) {
            return null;
        }
        Iterable iterable = affectedDocs;
        boolean $i$f$mapNotNull = false;
        void var7_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            RdFileId it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DocumentReference it = (DocumentReference)element$iv$iv;
            boolean bl2 = false;
            if (this.getFileId(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List affectedFileIds = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        if (affectedFileIds.isEmpty()) {
            return null;
        }
        return new RdUndoableAction(this.toModel(action.type()), affectedFileIds, action.isGlobal());
    }

    /*
     * WARNING - void declaration
     */
    private final List<RdUndoMeta> toModel(CmdMeta $this$toModel) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$toModel.undoMeta();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UndoMeta undoMeta = (UndoMeta)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.toModel((UndoMeta)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final CmdMeta fromModel(List<RdUndoMeta> $this$fromModel) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$fromModel;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RdUndoMeta rdUndoMeta = (RdUndoMeta)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.fromModel((RdUndoMeta)it));
        }
        List metaList = (List)destination$iv$iv;
        return CmdMeta.Companion.create(metaList);
    }

    /*
     * WARNING - void declaration
     */
    private final RdUndoMeta toModel(UndoMeta $this$toModel) {
        void $this$mapNotNullTo$iv$iv;
        UndoMeta undoMeta = $this$toModel;
        Project project = undoMeta.undoProject();
        RdProjectId undoProjectId = project != null ? this.toModel(project) : null;
        FileEditor fileEditor = undoMeta.focusedEditor();
        RdFileEditorId fileEditorId = fileEditor != null ? this.toModel(fileEditor) : null;
        Iterable $this$mapNotNull$iv = undoMeta.undoableActions();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            RdUndoableAction it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            UndoableActionMeta it = (UndoableActionMeta)element$iv$iv;
            boolean bl2 = false;
            if (this.toModel(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List undoableActions = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        boolean isForcedGlobal = undoMeta.isForcedGlobal();
        return new RdUndoMeta(undoProjectId, fileEditorId, undoableActions, isForcedGlobal);
    }

    /*
     * WARNING - void declaration
     */
    private final UndoMeta fromModel(RdUndoMeta $this$fromModel) {
        void $this$mapTo$iv$iv;
        RdUndoMeta model = $this$fromModel;
        RdProjectId rdProjectId = model.getUndoProjectId();
        Project project = rdProjectId != null ? this.fromModel(rdProjectId) : null;
        RdFileEditorId rdFileEditorId = model.getFileEditorId();
        FileEditor editor = rdFileEditorId != null ? this.fromModel(rdFileEditorId) : null;
        Iterable $this$map$iv = model.getUndoableActions();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RdUndoableAction rdUndoableAction = (RdUndoableAction)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.fromModel((RdUndoableAction)it));
        }
        List undoableActions = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        boolean isForcedGlobal = model.isForcedGlobal();
        return UndoMeta.Companion.create(project, editor, undoableActions, isForcedGlobal);
    }

    private final RdCmdGroupId groupIdToModel(Object $this$groupIdToModel) {
        Object commandGroupId = $this$groupIdToModel;
        if (commandGroupId == EditorActionUtil.EDIT_COMMAND_GROUP) {
            return (RdCmdGroupId)new RdEdtGroupId();
        }
        if (commandGroupId == EditorActionUtil.DELETE_COMMAND_GROUP) {
            return (RdCmdGroupId)new RdDelGroupId();
        }
        if (commandGroupId instanceof DocCommandGroupId) {
            return null;
        }
        if (commandGroupId instanceof String) {
            return (RdCmdGroupId)new RdStringGroupId((String)commandGroupId);
        }
        if (commandGroupId instanceof Integer) {
            return (RdCmdGroupId)new RdIntGroupId(((Number)commandGroupId).intValue());
        }
        if (commandGroupId instanceof Document) {
            return (RdCmdGroupId)this.getRdDocGroupId((Document)commandGroupId);
        }
        return this.getSyntheticGroupId(commandGroupId);
    }

    private final Object fromModel(RdCmdGroupId $this$fromModel) {
        Object object;
        RdCmdGroupId rdCommandGroupId = $this$fromModel;
        RdCmdGroupId rdCmdGroupId = rdCommandGroupId;
        if (rdCmdGroupId instanceof RdEdtGroupId) {
            object = EditorActionUtil.EDIT_COMMAND_GROUP;
        } else if (rdCmdGroupId instanceof RdDelGroupId) {
            object = EditorActionUtil.DELETE_COMMAND_GROUP;
        } else if (rdCmdGroupId instanceof RdStringGroupId) {
            object = ((RdStringGroupId)rdCommandGroupId).getGroupId();
        } else if (rdCmdGroupId instanceof RdIntGroupId) {
            object = ((RdIntGroupId)rdCommandGroupId).getGroupId();
        } else if (rdCmdGroupId instanceof RdDocGroupId) {
            object = this.getDocument(((RdDocGroupId)rdCommandGroupId).getFileId());
        } else {
            throw new IllegalArgumentException("Unknown command group id: " + rdCommandGroupId);
        }
        return object;
    }

    @Nullable
    protected final RdFileId getFileId(@NotNull DocumentReference docRef) {
        VirtualFile file;
        Intrinsics.checkNotNullParameter((Object)docRef, (String)"docRef");
        VirtualFile file2 = docRef.getFile();
        if (file2 != null) {
            return this.toModel(file2);
        }
        Document document = docRef.getDocument();
        if (document != null && (file = FileDocumentManager.getInstance().getFile(document)) != null) {
            return this.toModel(file);
        }
        return null;
    }

    private final Document getDocument(RdFileId fileId) {
        VirtualFile file = this.fromModel(fileId);
        if (file != null) {
            return (Document)ActionsKt.runReadAction(() -> RdCmdModelSupport.getDocument$lambda$0(file));
        }
        return null;
    }

    private final RdDocGroupId getRdDocGroupId(Document commandGroupId) {
        RdFileId fileId = this.getFileId(commandGroupId);
        if (fileId != null) {
            return new RdDocGroupId(fileId);
        }
        return null;
    }

    private final RdCmdGroupId getSyntheticGroupId(Object obj) {
        Object objString = obj.toString();
        if (((String)objString).length() > 100) {
            LOG.warn("Synthetic group id for " + obj.getClass() + " is too long, it might be a performance issue");
            String prefix2 = StringsKt.take((String)objString, (int)50);
            String suffix = StringsKt.takeLast((String)objString, (int)50);
            objString = prefix2 + "..." + suffix;
        }
        String hashCode = Integer.toHexString(System.identityHashCode(obj));
        return (RdCmdGroupId)new RdStringGroupId((String)objString + "@" + hashCode);
    }

    private final RdFileId getFileId(Document document) {
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        if (file != null) {
            return this.toModel(file);
        }
        return null;
    }

    private final DocumentReference getDocRef(RdFileId fileId) {
        VirtualFile file;
        RdFileId rdFileId = fileId;
        VirtualFile virtualFile = file = rdFileId != null ? this.fromModel(rdFileId) : null;
        if (file != null) {
            return DocumentReferenceManager.getInstance().create(file);
        }
        return null;
    }

    private final RdCommandName toModel(String $this$toModel) {
        return new RdCommandName(this.commandNamePrefix + $this$toModel);
    }

    private final String fromModel(RdCommandName $this$fromModel) {
        return $this$fromModel.getName();
    }

    private final RdUndoableActionType toModel(UndoableActionType $this$toModel) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toModel.ordinal()]) {
            case 1 -> RdUndoableActionType.START_MARK;
            case 2 -> RdUndoableActionType.FINISH_MARK;
            case 3 -> RdUndoableActionType.MENTION_ONLY;
            case 4 -> RdUndoableActionType.EDITOR_CHANGE;
            case 5 -> RdUndoableActionType.NON_UNDOABLE;
            case 6 -> RdUndoableActionType.GLOBAL;
            case 7 -> RdUndoableActionType.OTHER;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final UndoableActionType fromModel(RdUndoableActionType $this$fromModel) {
        return switch (WhenMappings.$EnumSwitchMapping$1[$this$fromModel.ordinal()]) {
            case 1 -> UndoableActionType.START_MARK;
            case 2 -> UndoableActionType.FINISH_MARK;
            case 3 -> UndoableActionType.MENTION_ONLY;
            case 4 -> UndoableActionType.EDITOR_CHANGE;
            case 5 -> UndoableActionType.NON_UNDOABLE;
            case 6 -> UndoableActionType.GLOBAL;
            case 7 -> UndoableActionType.OTHER;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final RdUndoConfirmationPolicy toModel(UndoConfirmationPolicy $this$toModel) {
        return switch (WhenMappings.$EnumSwitchMapping$2[$this$toModel.ordinal()]) {
            case 1 -> RdUndoConfirmationPolicy.DEFAULT;
            case 2 -> RdUndoConfirmationPolicy.REQUEST_CONFIRMATION;
            case 3 -> RdUndoConfirmationPolicy.DO_NOT_REQUEST_CONFIRMATION;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final UndoConfirmationPolicy fromModel(RdUndoConfirmationPolicy $this$fromModel) {
        return switch (WhenMappings.$EnumSwitchMapping$3[$this$fromModel.ordinal()]) {
            case 1 -> UndoConfirmationPolicy.DEFAULT;
            case 2 -> UndoConfirmationPolicy.REQUEST_CONFIRMATION;
            case 3 -> UndoConfirmationPolicy.DO_NOT_REQUEST_CONFIRMATION;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final Document getDocument$lambda$0(VirtualFile $file) {
        return FileDocumentManager.getInstance().getDocument($file);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RdCmdModelSupport.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rd/platform/undo/RdCmdModelSupport$Companion;", "", "<init>", "()V", "SYNTHETIC_GROUP_ID_MAX_LENGTH", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.platform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rd/platform/undo/RdCmdModelSupport$DocRefWithId;", "", "fileId", "Lcom/jetbrains/rd/ide/model/RdFileId;", "docRef", "Lcom/intellij/openapi/command/undo/DocumentReference;", "<init>", "(Lcom/jetbrains/rd/ide/model/RdFileId;Lcom/intellij/openapi/command/undo/DocumentReference;)V", "getFileId", "()Lcom/jetbrains/rd/ide/model/RdFileId;", "getDocRef", "()Lcom/intellij/openapi/command/undo/DocumentReference;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.rd.platform"})
    public static final class DocRefWithId {
        @NotNull
        private final RdFileId fileId;
        @NotNull
        private final DocumentReference docRef;

        public DocRefWithId(@NotNull RdFileId fileId, @NotNull DocumentReference docRef) {
            Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
            Intrinsics.checkNotNullParameter((Object)docRef, (String)"docRef");
            this.fileId = fileId;
            this.docRef = docRef;
        }

        @NotNull
        public final RdFileId getFileId() {
            return this.fileId;
        }

        @NotNull
        public final DocumentReference getDocRef() {
            return this.docRef;
        }

        @NotNull
        public final RdFileId component1() {
            return this.fileId;
        }

        @NotNull
        public final DocumentReference component2() {
            return this.docRef;
        }

        @NotNull
        public final DocRefWithId copy(@NotNull RdFileId fileId, @NotNull DocumentReference docRef) {
            Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
            Intrinsics.checkNotNullParameter((Object)docRef, (String)"docRef");
            return new DocRefWithId(fileId, docRef);
        }

        public static /* synthetic */ DocRefWithId copy$default(DocRefWithId docRefWithId, RdFileId rdFileId, DocumentReference documentReference, int n, Object object) {
            if ((n & 1) != 0) {
                rdFileId = docRefWithId.fileId;
            }
            if ((n & 2) != 0) {
                documentReference = docRefWithId.docRef;
            }
            return docRefWithId.copy(rdFileId, documentReference);
        }

        @NotNull
        public String toString() {
            return "DocRefWithId(fileId=" + this.fileId + ", docRef=" + this.docRef + ")";
        }

        public int hashCode() {
            int result = this.fileId.hashCode();
            result = result * 31 + this.docRef.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DocRefWithId)) {
                return false;
            }
            DocRefWithId docRefWithId = (DocRefWithId)other;
            if (!Intrinsics.areEqual((Object)this.fileId, (Object)docRefWithId.fileId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.docRef, (Object)docRefWithId.docRef);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;

        static {
            int[] nArray = new int[UndoableActionType.values().length];
            try {
                nArray[UndoableActionType.START_MARK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UndoableActionType.FINISH_MARK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UndoableActionType.MENTION_ONLY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UndoableActionType.EDITOR_CHANGE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UndoableActionType.NON_UNDOABLE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UndoableActionType.GLOBAL.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UndoableActionType.OTHER.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[RdUndoableActionType.values().length];
            try {
                nArray[RdUndoableActionType.START_MARK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdUndoableActionType.FINISH_MARK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdUndoableActionType.MENTION_ONLY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdUndoableActionType.EDITOR_CHANGE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdUndoableActionType.NON_UNDOABLE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdUndoableActionType.GLOBAL.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdUndoableActionType.OTHER.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[UndoConfirmationPolicy.values().length];
            try {
                nArray[UndoConfirmationPolicy.DEFAULT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UndoConfirmationPolicy.REQUEST_CONFIRMATION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UndoConfirmationPolicy.DO_NOT_REQUEST_CONFIRMATION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[RdUndoConfirmationPolicy.values().length];
            try {
                nArray[RdUndoConfirmationPolicy.DEFAULT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdUndoConfirmationPolicy.REQUEST_CONFIRMATION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdUndoConfirmationPolicy.DO_NOT_REQUEST_CONFIRMATION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
        }
    }
}

