/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.core;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.settingsSync.core.SettingsSyncEventListener;
import com.intellij.settingsSync.core.SettingsSyncEvents;
import com.intellij.settingsSync.core.SyncSettingsEvent;
import com.intellij.settingsSync.core.communicator.RemoteCommunicatorHolder;
import com.intellij.util.EventDispatcher;
import java.awt.Component;
import java.util.EventListener;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0003\u001c\u001d\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0010\u001a\u00020\u0011J\u0013\u0010\u0012\u001a\u00020\u00112\u000b\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u0015J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0005J\u000e\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\nJ\u000e\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\b\u001a\u0015\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\t\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lcom/intellij/settingsSync/core/SettingsSyncStatusTracker;", "", "<init>", "()V", "lastSyncTime", "", "state", "Lcom/intellij/settingsSync/core/SettingsSyncStatusTracker$SyncStatus;", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/settingsSync/core/SettingsSyncStatusTracker$Listener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "currentStatus", "getCurrentStatus", "()Lcom/intellij/settingsSync/core/SettingsSyncStatusTracker$SyncStatus;", "updateOnSuccess", "", "updateOnError", "message", "", "Lorg/jetbrains/annotations/Nls;", "isSyncSuccessful", "", "getLastSyncTime", "addListener", "listener", "removeListener", "Companion", "Listener", "SyncStatus", "intellij.settingsSync.core"})
public final class SettingsSyncStatusTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long lastSyncTime = -1L;
    @NotNull
    private SyncStatus state = SyncStatus.Success.INSTANCE;
    @NotNull
    private final EventDispatcher<Listener> eventDispatcher;

    public SettingsSyncStatusTracker() {
        EventDispatcher eventDispatcher = EventDispatcher.create(Listener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.eventDispatcher = eventDispatcher;
        SettingsSyncEvents.Companion.getInstance().addListener(new SettingsSyncEventListener(){

            @Override
            public void settingChanged(SyncSettingsEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event instanceof SyncSettingsEvent.CloudChange) {
                    this.updateOnSuccess();
                }
            }

            @Override
            public void enabledStateChanged(boolean syncEnabled) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(SettingsSyncStatusTracker.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.info("Settings sync enabled state changed to: " + syncEnabled);
                state = SyncStatus.Success.INSTANCE;
            }
        });
    }

    @NotNull
    public final SyncStatus getCurrentStatus() {
        if (RemoteCommunicatorHolder.INSTANCE.isPendingAction()) {
            return SyncStatus.UserActionRequired.INSTANCE;
        }
        return this.state;
    }

    public final void updateOnSuccess() {
        if (this.state instanceof SyncStatus.ActionRequired) {
            return;
        }
        this.lastSyncTime = System.currentTimeMillis();
        this.state = SyncStatus.Success.INSTANCE;
        ((Listener)this.eventDispatcher.getMulticaster()).syncStatusChanged();
    }

    public final void updateOnError(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (this.state instanceof SyncStatus.ActionRequired) {
            return;
        }
        this.lastSyncTime = -1L;
        this.state = new SyncStatus.Error(message);
        ((Listener)this.eventDispatcher.getMulticaster()).syncStatusChanged();
    }

    public final boolean isSyncSuccessful() {
        return Intrinsics.areEqual((Object)this.state, (Object)SyncStatus.Success.INSTANCE);
    }

    public final long getLastSyncTime() {
        return this.lastSyncTime;
    }

    public final void addListener(@NotNull Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.eventDispatcher.addListener((EventListener)listener);
    }

    public final void removeListener(@NotNull Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.eventDispatcher.removeListener((EventListener)listener);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/settingsSync/core/SettingsSyncStatusTracker$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/settingsSync/core/SettingsSyncStatusTracker;", "intellij.settingsSync.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SettingsSyncStatusTracker getInstance() {
            Object object = ApplicationManager.getApplication().getService(SettingsSyncStatusTracker.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (SettingsSyncStatusTracker)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lcom/intellij/settingsSync/core/SettingsSyncStatusTracker$Listener;", "Ljava/util/EventListener;", "syncStatusChanged", "", "intellij.settingsSync.core"})
    public static interface Listener
    extends EventListener {
        public void syncStatusChanged();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\u0004\u0005\u0006\u0007B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0004\b\t\n\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/settingsSync/core/SettingsSyncStatusTracker$SyncStatus;", "", "<init>", "()V", "Success", "Error", "UserActionRequired", "ActionRequired", "Lcom/intellij/settingsSync/core/SettingsSyncStatusTracker$SyncStatus$ActionRequired;", "Lcom/intellij/settingsSync/core/SettingsSyncStatusTracker$SyncStatus$Error;", "Lcom/intellij/settingsSync/core/SettingsSyncStatusTracker$SyncStatus$Success;", "Lcom/intellij/settingsSync/core/SettingsSyncStatusTracker$SyncStatus$UserActionRequired;", "intellij.settingsSync.core"})
    public static abstract sealed class SyncStatus {
        private SyncStatus() {
        }

        public /* synthetic */ SyncStatus(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Deprecated(message="Use SettingsSyncAuthService.PendingUserAction instead")
        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0000\n\u0002\b\u000b\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015BG\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u000b\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012$\u0010\u0006\u001a \b\u0001\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u0010\u0012\u001a\u00020\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\bH\u0086@\u00a2\u0006\u0002\u0010\u0014R\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR.\u0010\u0006\u001a \b\u0001\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lcom/intellij/settingsSync/core/SettingsSyncStatusTracker$SyncStatus$ActionRequired;", "Lcom/intellij/settingsSync/core/SettingsSyncStatusTracker$SyncStatus;", "message", "", "Lorg/jetbrains/annotations/Nls;", "actionTitle", "action", "Lkotlin/Function2;", "Ljava/awt/Component;", "Lkotlin/coroutines/Continuation;", "", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function2;)V", "getMessage", "()Ljava/lang/String;", "getActionTitle", "Lkotlin/jvm/functions/Function2;", "execute", "component", "(Ljava/awt/Component;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.settingsSync.core"})
        public static final class ActionRequired
        extends SyncStatus {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private final String message;
            @NotNull
            private final String actionTitle;
            @NotNull
            private final Function2<Component, Continuation<? super Unit>, Object> action;
            @NotNull
            private static final ActionRequired DUMMY_INSTANCE = new ActionRequired("", "", (Function2<? super Component, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<Component, Continuation<? super Unit>, Object>(null){
                int label;

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(Component p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));

            public ActionRequired(@NotNull String message, @NotNull String actionTitle, @NotNull Function2<? super Component, ? super Continuation<? super Unit>, ? extends Object> action) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Intrinsics.checkNotNullParameter((Object)actionTitle, (String)"actionTitle");
                Intrinsics.checkNotNullParameter(action, (String)"action");
                super(null);
                this.message = message;
                this.actionTitle = actionTitle;
                this.action = action;
            }

            @NotNull
            public final String getMessage() {
                return this.message;
            }

            @NotNull
            public final String getActionTitle() {
                return this.actionTitle;
            }

            @Nullable
            public final Object execute(@Nullable Component component, @NotNull Continuation<? super Unit> $completion) {
                Object object = this.action.invoke((Object)component, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }

            @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/settingsSync/core/SettingsSyncStatusTracker$SyncStatus$ActionRequired$Companion;", "", "<init>", "()V", "DUMMY_INSTANCE", "Lcom/intellij/settingsSync/core/SettingsSyncStatusTracker$SyncStatus$ActionRequired;", "getDUMMY_INSTANCE", "()Lcom/intellij/settingsSync/core/SettingsSyncStatusTracker$SyncStatus$ActionRequired;", "intellij.settingsSync.core"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final ActionRequired getDUMMY_INSTANCE() {
                    return DUMMY_INSTANCE;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0014\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/settingsSync/core/SettingsSyncStatusTracker$SyncStatus$Error;", "Lcom/intellij/settingsSync/core/SettingsSyncStatusTracker$SyncStatus;", "errorMessage", "", "Lorg/jetbrains/annotations/Nls;", "<init>", "(Ljava/lang/String;)V", "getErrorMessage", "()Ljava/lang/String;", "intellij.settingsSync.core"})
        public static final class Error
        extends SyncStatus {
            @NotNull
            private final String errorMessage;

            public Error(@NotNull String errorMessage) {
                Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
                super(null);
                this.errorMessage = errorMessage;
            }

            @NotNull
            public final String getErrorMessage() {
                return this.errorMessage;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/settingsSync/core/SettingsSyncStatusTracker$SyncStatus$Success;", "Lcom/intellij/settingsSync/core/SettingsSyncStatusTracker$SyncStatus;", "<init>", "()V", "intellij.settingsSync.core"})
        public static final class Success
        extends SyncStatus {
            @NotNull
            public static final Success INSTANCE = new Success();

            private Success() {
                super(null);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/settingsSync/core/SettingsSyncStatusTracker$SyncStatus$UserActionRequired;", "Lcom/intellij/settingsSync/core/SettingsSyncStatusTracker$SyncStatus;", "<init>", "()V", "intellij.settingsSync.core"})
        public static final class UserActionRequired
        extends SyncStatus {
            @NotNull
            public static final UserActionRequired INSTANCE = new UserActionRequired();

            private UserActionRequired() {
                super(null);
            }
        }
    }
}

