/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.grazie;

import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextContentBuilder;
import com.intellij.grazie.text.TextExtractor;
import com.intellij.grazie.utils.PsiUtilsKt;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.PsiCommentImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.python.grazie.PythonTextExtractorKt;
import com.jetbrains.python.PyStringFormatParser;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.ast.PyAstStringElement;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyFormattedStringElement;
import com.jetbrains.python.psi.PyStringElement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.impl.PyStringLiteralDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0014J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\bH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/python/grazie/PythonTextExtractor;", "Lcom/intellij/grazie/text/TextExtractor;", "<init>", "()V", "buildTextContents", "", "Lcom/intellij/grazie/text/TextContent;", "root", "Lcom/intellij/psi/PsiElement;", "allowedDomains", "", "Lcom/intellij/grazie/text/TextContent$TextDomain;", "getDomain", "element", "intellij.python.grazie"})
@SourceDebugExtension(value={"SMAP\nPythonTextExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PythonTextExtractor.kt\ncom/intellij/python/grazie/PythonTextExtractor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,83:1\n1915#2:84\n1916#2:86\n1915#2:87\n1915#2:88\n1586#2:89\n1661#2,3:90\n1915#2,2:93\n1916#2:95\n1916#2:96\n1642#2,10:97\n1915#2:107\n1916#2:109\n1652#2:110\n1#3:85\n1#3:108\n*S KotlinDebug\n*F\n+ 1 PythonTextExtractor.kt\ncom/intellij/python/grazie/PythonTextExtractor\n*L\n33#1:84\n33#1:86\n43#1:87\n47#1:88\n48#1:89\n48#1:90,3\n49#1:93,2\n47#1:95\n43#1:96\n67#1:97,10\n67#1:107\n67#1:109\n67#1:110\n67#1:108\n*E\n"})
public final class PythonTextExtractor
extends TextExtractor {
    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<TextContent> buildTextContents(@NotNull PsiElement root, @NotNull Set<? extends TextContent.TextDomain> allowedDomains) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(allowedDomains, (String)"allowedDomains");
        if (root instanceof PyStringLiteralExpression) {
            List texts = new ArrayList();
            PsiElement parent = ((PyStringLiteralExpression)root).getParent();
            if (parent instanceof PyBinaryExpression && root == ((PyBinaryExpression)parent).getLeftExpression() && ((PyBinaryExpression)parent).getOperator() == PyTokenTypes.PERC) {
                List list = PyStringFormatParser.parsePercentFormat((String)((PyStringLiteralExpression)root).getStringValue());
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"parsePercentFormat(...)");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TextContent it;
                    int endIndex;
                    PyStringFormatParser.FormatStringChunk chunk = (PyStringFormatParser.FormatStringChunk)element$iv;
                    boolean bl = false;
                    if (!(chunk instanceof PyStringFormatParser.ConstantChunk)) continue;
                    int startIndex = ((PyStringLiteralExpression)root).valueOffsetToTextOffset(((PyStringFormatParser.ConstantChunk)chunk).getStartIndex());
                    if (TextContentBuilder.FromPsi.build(root, TextContent.TextDomain.LITERALS, new TextRange(startIndex, endIndex = ((PyStringLiteralExpression)root).valueOffsetToTextOffset(((PyStringFormatParser.ConstantChunk)chunk).getEndIndex()))) == null) continue;
                    boolean bl2 = false;
                    texts.add(it);
                }
                return texts;
            }
            List list = ((PyStringLiteralExpression)root).getStringElements();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStringElements(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                List list2;
                PyStringElement element = (PyStringElement)element$iv;
                boolean bl = false;
                if (element.isFormatted()) {
                    Intrinsics.checkNotNull((Object)element, (String)"null cannot be cast to non-null type com.jetbrains.python.psi.PyFormattedStringElement");
                    List list3 = ((PyFormattedStringElement)element).getLiteralPartRanges();
                    list2 = list3;
                    Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getLiteralPartRanges(...)");
                } else {
                    list2 = CollectionsKt.listOf((Object)element.getContentRange());
                }
                List ranges = list2;
                PyStringLiteralDecoder decoder = new PyStringLiteralDecoder((PyAstStringElement)element);
                boolean containsEscapes = element.textContains('\\');
                Iterable $this$forEach$iv2 = ranges;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Pair pair;
                    List list4;
                    TextRange range = (TextRange)element$iv2;
                    boolean bl3 = false;
                    if (element.isRaw() || !containsEscapes) {
                        list4 = CollectionsKt.listOf((Object)range);
                    } else {
                        void $this$mapTo$iv$iv;
                        List list5 = decoder.decodeRange(range);
                        Intrinsics.checkNotNullExpressionValue((Object)list5, (String)"decodeRange(...)");
                        Iterable $this$map$iv = list5;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            pair = (Pair)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl4 = false;
                            collection.add((TextRange)it.first);
                        }
                        list4 = (List)destination$iv$iv;
                    }
                    List escapeAwareRanges = list4;
                    Iterable $this$forEach$iv3 = escapeAwareRanges;
                    boolean $i$f$forEach3 = false;
                    for (Object element$iv3 : $this$forEach$iv3) {
                        TextRange escapeAwareRange = (TextRange)element$iv3;
                        boolean bl5 = false;
                        Intrinsics.checkNotNull((Object)element);
                        TextContent.TextDomain domain = this.getDomain((PsiElement)element);
                        pair = TextContentBuilder.FromPsi.removingIndents(" \t").removingLineSuffixes(" \t").build((PsiElement)element, domain, escapeAwareRange);
                        if (pair == null) continue;
                        Pair text = pair;
                        boolean bl6 = false;
                        if (domain == TextContent.TextDomain.DOCUMENTATION) {
                            if (PythonTextExtractorKt.access$excludeDocstringTags((TextContent)text) != null) {
                                TextContent it;
                                boolean bl7 = false;
                                texts.add(it);
                            }
                            continue;
                        }
                        texts.add(text);
                    }
                }
            }
            return texts;
        }
        if (root instanceof PsiCommentImpl && allowedDomains.contains(TextContent.TextDomain.COMMENTS)) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            List siblings = PsiUtilsKt.getNotSoDistantSimilarSiblings((PsiElement)root, PythonTextExtractor::buildTextContents$lambda$2);
            Iterable $i$f$forEach = siblings;
            char c = '\n';
            boolean $i$f$mapNotNull = false;
            void element$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach4 = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                TextContent it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                PsiElement it = (PsiElement)element$iv$iv;
                boolean bl8 = false;
                if (TextContent.builder().build(it, TextContent.TextDomain.COMMENTS) == null) continue;
                boolean bl9 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list = (List)destination$iv$iv;
            TextContent textContent = TextContent.joinWithWhitespace((char)c, (List)list);
            if (textContent == null) {
                return CollectionsKt.emptyList();
            }
            TextContent text = textContent;
            return CollectionsKt.listOf((Object)text);
        }
        return CollectionsKt.emptyList();
    }

    private final TextContent.TextDomain getDomain(PsiElement element) {
        IElementType elementType = PsiUtilCore.getElementType((PsiElement)element);
        return Intrinsics.areEqual((Object)elementType, (Object)PyTokenTypes.DOCSTRING) ? TextContent.TextDomain.DOCUMENTATION : TextContent.TextDomain.LITERALS;
    }

    private static final boolean buildTextContents$lambda$2(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof PsiCommentImpl;
    }
}

