/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.github.ultimate.features.ide.psi;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.vcs.github.ultimate.features.cache.GitHubActionsCatalog;
import com.intellij.vcs.github.ultimate.features.cache.metadata.GitHubActionMetadata;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.exceptions.GithubStatusCodeException;
import org.jetbrains.yaml.psi.YAMLPsiElement;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fJ\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/vcs/github/ultimate/features/ide/psi/FilePsiReference;", "Lcom/intellij/psi/PsiReferenceBase;", "Lorg/jetbrains/yaml/psi/YAMLPsiElement;", "element", "<init>", "(Lorg/jetbrains/yaml/psi/YAMLPsiElement;)V", "getFileByReference", "Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "referenceText", "", "getFileByReference$intellij_vcs_github_ultimate_features", "resolve", "Lcom/intellij/psi/PsiElement;", "intellij.vcs.github.ultimate.features"})
@SourceDebugExtension(value={"SMAP\nFilePsiReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilePsiReference.kt\ncom/intellij/vcs/github/ultimate/features/ide/psi/FilePsiReference\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,38:1\n30#2,2:39\n13#3:41\n1#4:42\n*S KotlinDebug\n*F\n+ 1 FilePsiReference.kt\ncom/intellij/vcs/github/ultimate/features/ide/psi/FilePsiReference\n*L\n19#1:39,2\n25#1:41\n*E\n"})
public class FilePsiReference
extends PsiReferenceBase<YAMLPsiElement> {
    public FilePsiReference(@NotNull YAMLPsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super((PsiElement)element, true);
    }

    @Nullable
    public final PsiFile getFileByReference$intellij_vcs_github_ultimate_features(@NotNull Project project, @NotNull String referenceText) {
        VirtualFile virtualFile;
        String fileUrl;
        String $i$f$service2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)referenceText, (String)"referenceText");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service2 = false;
        Class<GitHubActionsCatalog> serviceClass$iv = GitHubActionsCatalog.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        GitHubActionsCatalog actionsCatalog = (GitHubActionsCatalog)object;
        if (StringsKt.isBlank((CharSequence)referenceText)) {
            return null;
        }
        try {
            GitHubActionMetadata gitHubActionMetadata = actionsCatalog.resolveActionMetadata(referenceText);
            $i$f$service2 = gitHubActionMetadata != null ? gitHubActionMetadata.getFileUrl() : null;
        }
        catch (GithubStatusCodeException e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(FilePsiReference.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warnWithDebug((Throwable)e);
            $i$f$service2 = null;
        }
        String string = fileUrl = $i$f$service2;
        if (string != null) {
            String it = string;
            boolean bl = false;
            virtualFile = VirtualFileManager.getInstance().findFileByUrl(fileUrl);
        } else {
            virtualFile = null;
        }
        VirtualFile actionFile = virtualFile;
        return actionFile != null && actionFile.isValid() ? PsiManager.getInstance((Project)project).findFile(actionFile) : null;
    }

    @Nullable
    public PsiElement resolve() {
        Project project = ((YAMLPsiElement)this.getElement()).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String string = ((YAMLPsiElement)this.getElement()).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return (PsiElement)this.getFileByReference$intellij_vcs_github_ultimate_features(project, string);
    }
}

