/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.terminal;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.download.NodeDownloadUtil;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.NioFiles;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.starter.ShellCustomizer;
import org.jetbrains.plugins.terminal.starter.ShellExecOptions;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/javascript/terminal/DownloadedNodeInterpreterTerminalCustomizer;", "Lorg/jetbrains/plugins/terminal/starter/ShellCustomizer;", "<init>", "()V", "customizeExecOptions", "", "project", "Lcom/intellij/openapi/project/Project;", "shellExecOptions", "Lorg/jetbrains/plugins/terminal/starter/ShellExecOptions;", "intellij.javascript.terminal"})
public final class DownloadedNodeInterpreterTerminalCustomizer
implements ShellCustomizer {
    public void customizeExecOptions(@NotNull Project project, @NotNull ShellExecOptions shellExecOptions) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)shellExecOptions, (String)"shellExecOptions");
        NodeJsInterpreter interpreter = NodeJsInterpreterManager.getInstance((Project)project).getInterpreter();
        if (interpreter != null && NodeDownloadUtil.INSTANCE.isDownloaded(interpreter) && interpreter instanceof NodeJsLocalInterpreter) {
            Path path = NioFiles.toPath((String)((NodeJsLocalInterpreter)interpreter).getInterpreterSystemIndependentPath());
            if (path == null || (path = path.getParent()) == null) {
                return;
            }
            Path nodeBinDir = path;
            shellExecOptions.prependEntryToPATH(nodeBinDir);
        }
    }
}

