/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringArrayRestElement;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSEmptyExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.openapi.editor.actions.FlipCommaIntention;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;

public class JSCommaFlipper
implements FlipCommaIntention.Flipper {
    public boolean flip(@NotNull PsiElement left, @NotNull PsiElement right) {
        PsiElement parent;
        if (left == null) {
            JSCommaFlipper.$$$reportNull$$$0(0);
        }
        if (right == null) {
            JSCommaFlipper.$$$reportNull$$$0(1);
        }
        if ((parent = left.getParent()) instanceof JSArrayLiteralExpression || parent instanceof JSDestructuringArray) {
            if (PsiUtilCore.getElementType((PsiElement)left) == JSTokenTypes.COMMA) {
                PsiElement element = PsiTreeUtil.skipWhitespacesForward((PsiElement)left);
                if (element instanceof JSEmptyExpression) {
                    element.delete();
                }
                left.getParent().addAfter(right.copy(), left);
                right.replace((PsiElement)JSChangeUtil.createEmptyExpression(right));
                return true;
            }
            if (PsiUtilCore.getElementType((PsiElement)right) == JSTokenTypes.COMMA) {
                PsiElement element = PsiTreeUtil.skipWhitespacesBackward((PsiElement)right);
                if (element instanceof JSEmptyExpression) {
                    element.delete();
                }
                right.getParent().addBefore(left.copy(), right);
                left.replace((PsiElement)JSChangeUtil.createEmptyExpression(left));
                return true;
            }
        }
        return false;
    }

    public boolean canFlip(@NotNull PsiElement left, @NotNull PsiElement right) {
        if (left == null) {
            JSCommaFlipper.$$$reportNull$$$0(2);
        }
        if (right == null) {
            JSCommaFlipper.$$$reportNull$$$0(3);
        }
        if (right instanceof JSSpreadExpression && JSDestructuringUtil.getDestructuringAssignmentSource((JSExpression)right) != null) {
            return false;
        }
        if (right instanceof JSDestructuringProperty && ((JSDestructuringProperty)right).isRest()) {
            return false;
        }
        if (right instanceof JSDestructuringArrayRestElement) {
            return false;
        }
        return !(right instanceof JSParameterListElement) || !((JSParameterListElement)right).isRest();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/intentions/JSCommaFlipper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "flip";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "canFlip";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

