/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.resolve.JSEvaluationStatisticsCollectorKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\tJ\u0006\u0010\u000b\u001a\u00020\tJ\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0012\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/lang/javascript/psi/resolve/JSEvaluationStatisticsCollector;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "responsesReceived", "Ljava/util/concurrent/atomic/AtomicInteger;", "responsesGotFromCache", "evaluatedTypeCount", "responseReceived", "", "responseGotFromCache", "typeEvaluated", "getEvaluatedTypeCount", "", "getResponseReceivedCount", "reset", "", "getResponseGotFromCacheCount", "dispose", "State", "intellij.javascript.psi.impl"})
@SourceDebugExtension(value={"SMAP\nJSEvaluationStatisticsCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSEvaluationStatisticsCollector.kt\ncom/intellij/lang/javascript/psi/resolve/JSEvaluationStatisticsCollector\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,51:1\n13#2:52\n*S KotlinDebug\n*F\n+ 1 JSEvaluationStatisticsCollector.kt\ncom/intellij/lang/javascript/psi/resolve/JSEvaluationStatisticsCollector\n*L\n36#1:52\n*E\n"})
public final class JSEvaluationStatisticsCollector
implements Disposable {
    @NotNull
    private final AtomicInteger responsesReceived = new AtomicInteger(0);
    @NotNull
    private final AtomicInteger responsesGotFromCache = new AtomicInteger(0);
    @NotNull
    private final AtomicInteger evaluatedTypeCount = new AtomicInteger(0);

    public final void responseReceived() {
        this.responsesReceived.incrementAndGet();
    }

    public final void responseGotFromCache() {
        this.responsesGotFromCache.incrementAndGet();
    }

    public final void typeEvaluated() {
        this.evaluatedTypeCount.incrementAndGet();
    }

    public final int getEvaluatedTypeCount() {
        return this.evaluatedTypeCount.get();
    }

    public final int getResponseReceivedCount(boolean reset) {
        return reset ? this.responsesReceived.getAndSet(0) : this.responsesReceived.get();
    }

    public static /* synthetic */ int getResponseReceivedCount$default(JSEvaluationStatisticsCollector jSEvaluationStatisticsCollector, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return jSEvaluationStatisticsCollector.getResponseReceivedCount(bl);
    }

    public final int getResponseGotFromCacheCount(boolean reset) {
        return reset ? this.responsesGotFromCache.getAndSet(0) : this.responsesGotFromCache.get();
    }

    public static /* synthetic */ int getResponseGotFromCacheCount$default(JSEvaluationStatisticsCollector jSEvaluationStatisticsCollector, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return jSEvaluationStatisticsCollector.getResponseGotFromCacheCount(bl);
    }

    public void dispose() {
        int responseReceivedCount = this.getResponseReceivedCount(true);
        if (responseReceivedCount > 0) {
            StringBuilder builder = new StringBuilder();
            JSEvaluationStatisticsCollectorKt.printEvaluationStatistics(responseReceivedCount, this.getResponseGotFromCacheCount(true), builder);
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(JSEvaluationStatisticsCollector.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info(builder.toString());
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/lang/javascript/psi/resolve/JSEvaluationStatisticsCollector$State;", "", "<init>", "()V", "isEnabled", "", "intellij.javascript.psi.impl"})
    public static final class State {
        @NotNull
        public static final State INSTANCE = new State();

        private State() {
        }

        public final boolean isEnabled() {
            return ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isInternal();
        }
    }
}

