/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.local.tokenizer;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.local.tokenizer.BaseEncoder;
import org.jetbrains.completion.full.line.local.utils.Caching;
import org.jetbrains.completion.full.line.tokenizer.Tokenizer;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0006\u0018\u0000 /2\u00020\u0001:\u0001/B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JH\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00180\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u00182\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001b2\b\b\u0002\u0010\u001d\u001a\u00020\u001b2\b\b\u0002\u0010\u001e\u001a\u00020\u001fJ \u0010 \u001a\b\u0012\u0004\u0012\u00020\u00160\u00182\u0012\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00180\u0018J>\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u00182\u0006\u0010\"\u001a\u00020\u00162\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001b2\b\b\u0002\u0010\u001d\u001a\u00020\u001b2\b\b\u0002\u0010\u001e\u001a\u00020\u001fH\u0002J\u0014\u0010 \u001a\u00020\u00162\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00070\u0018J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020#0\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u0018H\u0016J\u0010\u0010\u0017\u001a\u00020#2\u0006\u0010\"\u001a\u00020\u0016H\u0016J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020#H\u0016J\u0018\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0016H\u0016J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u0007H\u0016J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00070\u00112\u0006\u0010'\u001a\u00020(H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0014\u0010\u000e\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R \u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00110\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00070*X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u001a\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u0013\u00a8\u00060"}, d2={"Lorg/jetbrains/completion/full/line/local/tokenizer/FullLineTokenizer;", "Lorg/jetbrains/completion/full/line/tokenizer/Tokenizer;", "encoder", "Lorg/jetbrains/completion/full/line/local/tokenizer/BaseEncoder;", "<init>", "(Lorg/jetbrains/completion/full/line/local/tokenizer/BaseEncoder;)V", "vocabSize", "", "getVocabSize", "()I", "eosTokenId", "getEosTokenId", "scopeInId", "getScopeInId", "scopeOutId", "getScopeOutId", "invalidIds", "", "getInvalidIds", "()Ljava/util/Set;", "idsByRegexCache", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "encode", "", "sentences", "bos", "", "eos", "reverse", "dropoutProb", "", "decode", "ids", "sentence", "", "separator", "id", "idsByRegex", "regex", "Lkotlin/text/Regex;", "vocab", "", "getVocab", "()Ljava/util/Map;", "vocabIds", "getVocabIds", "Companion", "intellij.fullLine.local"})
@SourceDebugExtension(value={"SMAP\nFullLineTokenizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullLineTokenizer.kt\norg/jetbrains/completion/full/line/local/tokenizer/FullLineTokenizer\n+ 2 Caching.kt\norg/jetbrains/completion/full/line/local/utils/Caching\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,529:1\n8#2,5:530\n1596#3:535\n1629#3,4:536\n1586#3:540\n1661#3,3:541\n11735#4:544\n12085#4,3:545\n491#5,7:548\n*S KotlinDebug\n*F\n+ 1 FullLineTokenizer.kt\norg/jetbrains/completion/full/line/local/tokenizer/FullLineTokenizer\n*L\n142#1:530,5\n225#1:535\n225#1:536,4\n196#1:540\n196#1:541,3\n208#1:544\n208#1:545,3\n221#1:548,7\n*E\n"})
public final class FullLineTokenizer
implements Tokenizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private BaseEncoder encoder;
    private final int vocabSize;
    private final int eosTokenId;
    private final int scopeInId;
    private final int scopeOutId;
    @NotNull
    private final Set<Integer> invalidIds;
    @NotNull
    private final Cache<String, Set<Integer>> idsByRegexCache;
    @NotNull
    private final Map<String, Integer> vocab;
    @NotNull
    private final Set<Integer> vocabIds;

    /*
     * WARNING - void declaration
     */
    private FullLineTokenizer(BaseEncoder encoder) {
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        this.encoder = encoder;
        this.vocabSize = this.encoder.vocabSize$intellij_fullLine_local();
        this.eosTokenId = this.encoder.getBpeState$intellij_fullLine_local().getSpecialTokens().getEosId();
        this.scopeInId = this.encode("\u21e5")[1];
        this.scopeOutId = this.encode("\u21e4")[1];
        Object[] objectArray = new Integer[]{this.encoder.getBpeState$intellij_fullLine_local().getSpecialTokens().getUnkId(), this.encoder.getBpeState$intellij_fullLine_local().getSpecialTokens().getPadId(), this.encoder.getBpeState$intellij_fullLine_local().getSpecialTokens().getBosId(), this.encoder.getBpeState$intellij_fullLine_local().getSpecialTokens().getEosId()};
        this.invalidIds = SetsKt.setOf((Object[])objectArray);
        Object $this$iv = Caching.INSTANCE;
        long total$iv = 100L;
        long minutes$iv = 5L;
        boolean $i$f$default = false;
        Cache cache = Caffeine.newBuilder().maximumSize(total$iv).expireAfterAccess(minutes$iv, TimeUnit.MINUTES).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.idsByRegexCache = cache;
        $this$iv = this.encoder.vocabulary$intellij_fullLine_local();
        FullLineTokenizer fullLineTokenizer = this;
        boolean $i$f$mapIndexed = false;
        void var4_9 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void s;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair((Object)s, (Object)((int)index)));
        }
        fullLineTokenizer.vocab = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        this.vocabIds = CollectionsKt.toHashSet((Iterable)this.getVocab().values());
    }

    public int getVocabSize() {
        return this.vocabSize;
    }

    public int getEosTokenId() {
        return this.eosTokenId;
    }

    public int getScopeInId() {
        return this.scopeInId;
    }

    public int getScopeOutId() {
        return this.scopeOutId;
    }

    @NotNull
    public Set<Integer> getInvalidIds() {
        return this.invalidIds;
    }

    @NotNull
    public final List<List<Integer>> encode(@NotNull List<String> sentences, boolean bos, boolean eos, boolean reverse, double dropoutProb) {
        Intrinsics.checkNotNullParameter(sentences, (String)"sentences");
        if (dropoutProb < 0.0 || dropoutProb > 1.0) {
            throw new IllegalArgumentException("dropoutProb value must be in the range [0, 1]. Current value of dropoutProb = " + dropoutProb);
        }
        BaseEncoder.EncodingResult encodingResult = this.encoder.encodeAsIds(sentences, bos, eos, reverse, dropoutProb);
        if (encodingResult.getStatus().getCode() != 0 || encodingResult.getIds() == null) {
            throw new IllegalArgumentException(encodingResult.getStatus().getMessage());
        }
        return encodingResult.getIds();
    }

    public static /* synthetic */ List encode$default(FullLineTokenizer fullLineTokenizer, List list, boolean bl, boolean bl2, boolean bl3, double d, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        if ((n & 0x10) != 0) {
            d = 0.0;
        }
        return fullLineTokenizer.encode(list, bl, bl2, bl3, d);
    }

    @NotNull
    public final List<String> decode(@NotNull List<? extends List<Integer>> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        return this.encoder.decodeIds(ids).getSentences();
    }

    private final List<Integer> encode(String sentence, boolean bos, boolean eos, boolean reverse, double dropoutProb) {
        return this.encode(CollectionsKt.listOf((Object)sentence), bos, eos, reverse, dropoutProb).get(0);
    }

    static /* synthetic */ List encode$default(FullLineTokenizer fullLineTokenizer, String string, boolean bl, boolean bl2, boolean bl3, double d, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        if ((n & 0x10) != 0) {
            d = 0.0;
        }
        return fullLineTokenizer.encode(string, bl, bl2, bl3, d);
    }

    @NotNull
    public final String decode(@NotNull List<Integer> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        return this.decode(CollectionsKt.listOf(ids)).get(0);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<int[]> encode(@NotNull List<String> sentences) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(sentences, (String)"sentences");
        Iterable $this$map$iv = this.encode(sentences, false, false, false, 0.0);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            List list = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(CollectionsKt.toIntArray((Collection)((Collection)it)));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public int[] encode(@NotNull String sentence) {
        Intrinsics.checkNotNullParameter((Object)sentence, (String)"sentence");
        return CollectionsKt.toIntArray((Collection)this.encode(sentence, false, false, false, 0.0));
    }

    @NotNull
    public String decode(@NotNull int[] ids) {
        Intrinsics.checkNotNullParameter((Object)ids, (String)"ids");
        return this.decode(CollectionsKt.listOf((Object)ArraysKt.toList((int[])ids))).get(0);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String decode(@NotNull int[] ids, @NotNull String separator) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ids, (String)"ids");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        int[] $this$map$iv = ids;
        boolean $i$f$map = false;
        int[] nArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_11 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.decode((int)it));
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)separator, null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public String decode(int id) {
        return this.encoder.idToSubword$intellij_fullLine_local(id, true);
    }

    @NotNull
    public Set<Integer> idsByRegex(@NotNull Regex regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        Object object = this.idsByRegexCache.get((Object)regex.getPattern(), arg_0 -> FullLineTokenizer.idsByRegex$lambda$1(arg_0 -> FullLineTokenizer.idsByRegex$lambda$0(this, regex, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Set)object;
    }

    @NotNull
    public Map<String, Integer> getVocab() {
        return this.vocab;
    }

    @NotNull
    public Set<Integer> getVocabIds() {
        return this.vocabIds;
    }

    private static final Set idsByRegex$lambda$0(FullLineTokenizer this$0, Regex $regex, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Map<String, Integer> $this$filterKeys$iv = this$0.getVocab();
        boolean $i$f$filterKeys = false;
        LinkedHashMap<String, Integer> result$iv = new LinkedHashMap<String, Integer>();
        for (Map.Entry<String, Integer> entry$iv : $this$filterKeys$iv.entrySet()) {
            String it2 = entry$iv.getKey();
            boolean bl = false;
            if (!$regex.containsMatchIn((CharSequence)it2)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return CollectionsKt.toSet((Iterable)((Map)result$iv).values());
    }

    private static final Set idsByRegex$lambda$1(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }

    public /* synthetic */ FullLineTokenizer(BaseEncoder encoder, DefaultConstructorMarker $constructor_marker) {
        this(encoder);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/completion/full/line/local/tokenizer/FullLineTokenizer$Companion;", "", "<init>", "()V", "load", "Lorg/jetbrains/completion/full/line/local/tokenizer/FullLineTokenizer;", "modelFile", "Ljava/io/File;", "intellij.fullLine.local"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FullLineTokenizer load(@NotNull File modelFile) {
            Intrinsics.checkNotNullParameter((Object)modelFile, (String)"modelFile");
            return new FullLineTokenizer(BaseEncoder.Companion.load(modelFile), null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

