/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.mtls;

import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.auth.http.HttpTransportFactory;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Objects;

public class MtlsHttpTransportFactory
implements HttpTransportFactory {
    private final KeyStore mtlsKeyStore;

    public MtlsHttpTransportFactory(KeyStore mtlsKeyStore) {
        this.mtlsKeyStore = Objects.requireNonNull(mtlsKeyStore, "mtlsKeyStore cannot be null");
    }

    @Override
    public NetHttpTransport create() {
        try {
            return new NetHttpTransport.Builder().trustCertificates(null, this.mtlsKeyStore, "").build();
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Failed to initialize mTLS transport.", e);
        }
    }
}

