/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.idea.AppMode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.PlatformUtils;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class AppModeAssertions {
    private AppModeAssertions() {
    }

    public static void assertFrontend(boolean hard) {
        if (!AppMode.isRemoteDevHost()) {
            return;
        }
        AppModeAssertionError e = new AppModeAssertionError("frontend");
        if (hard) {
            throw e;
        }
        Holder.LOG.error((Throwable)((Object)e));
    }

    public static void assertBackend(boolean hard) {
        if (!PlatformUtils.isJetBrainsClient()) {
            return;
        }
        AppModeAssertionError e = new AppModeAssertionError("backend");
        if (hard) {
            throw e;
        }
        Holder.LOG.error((Throwable)((Object)e));
    }

    private static final class AppModeAssertionError
    extends AssertionError {
        private AppModeAssertionError(String expectedMode) {
            super((Object)("The operations is allowed only in " + expectedMode + "; Platform prefix: " + System.getProperty("idea.platform.prefix", "not defined") + "; getPlatformPrefix: " + PlatformUtils.getPlatformPrefix()));
        }
    }

    private static final class Holder {
        private static final Logger LOG = Logger.getInstance(AppModeAssertions.class);

        private Holder() {
        }
    }
}

